/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.JarClassLoader;
import org.netbeans.Stamps;

class Archive
implements Stamps.Updater {
    private static final long magic = 6836742066851800321L;
    private volatile boolean saved;
    private final boolean prepopulated;
    private volatile boolean gathering;
    private final Object gatheringLock = new Object();
    private Map<String, Boolean> requests = new LinkedHashMap<String, Boolean>();
    private Map<String, JarClassLoader.JarSource> knownSources = new HashMap<String, JarClassLoader.JarSource>();
    private volatile boolean active;
    private Map<String, Integer> sources = new HashMap<String, Integer>();
    private Map<Entry, Entry> entries = new HashMap<Entry, Entry>();

    public Archive() {
        this.gathering = false;
        this.active = false;
        this.prepopulated = false;
    }

    Archive(Stamps stamps) {
        ByteBuffer byteBuffer = stamps.asByteBuffer("all-resources.dat");
        try {
            this.parse(byteBuffer, stamps.lastModified());
        }
        catch (Exception exception) {
            this.sources.clear();
            this.entries.clear();
        }
        this.prepopulated = this.entries.size() > 0;
        this.active = true;
        this.gathering = true;
    }

    final boolean isActive() {
        return this.active;
    }

    private void parse(ByteBuffer byteBuffer, long l) throws Exception {
        if (byteBuffer.remaining() < 16) {
            throw new IllegalStateException("Cache invalid");
        }
        if (byteBuffer.getLong() != 6836742066851800321L) {
            throw new IllegalStateException("Wrong format");
        }
        if (byteBuffer.getLong() < l) {
            throw new IllegalStateException("Cache outdated");
        }
        int n = 0;
        block4: while (byteBuffer.remaining() > 0) {
            byte by = byteBuffer.get();
            switch (by) {
                case 1: {
                    String string = Archive.parseString(byteBuffer);
                    this.sources.put(string, n++);
                    continue block4;
                }
                case 2: {
                    Entry entry = new Entry(byteBuffer);
                    this.entries.put(entry, entry);
                    continue block4;
                }
            }
            throw new IllegalStateException("Cache invalid");
        }
        byteBuffer.rewind();
    }

    private static String parseString(ByteBuffer byteBuffer) {
        char c = byteBuffer.getChar();
        byte[] byArray = new byte[c];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    private static void writeString(DataOutputStream dataOutputStream, String string) throws UnsupportedEncodingException, IOException {
        byte[] byArray = string.getBytes("UTF8");
        dataOutputStream.writeChar(byArray.length);
        dataOutputStream.write(byArray);
    }

    private Entry getEntry(JarClassLoader.JarSource jarSource, String string) {
        Integer n = this.sources.get(jarSource.getIdentifier());
        if (n == null) {
            return null;
        }
        return this.entries.get(new Template(n, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(JarClassLoader.JarSource jarSource, String string) throws IOException {
        Object object;
        Entry entry = null;
        if (this.active && (entry = this.getEntry(jarSource, string)) == null && this.gathering) {
            object = jarSource.getIdentifier();
            String string2 = (String)object + "!/" + string;
            Object object2 = this.gatheringLock;
            synchronized (object2) {
                if (!this.knownSources.containsKey(object)) {
                    this.knownSources.put((String)object, jarSource);
                }
                if (!this.requests.containsKey(string2)) {
                    this.requests.put(string2, Boolean.TRUE);
                }
            }
        }
        if (entry == null) {
            object = jarSource.resource(string);
            return object;
        }
        return entry.getContent();
    }

    public void stopGathering() {
        this.gathering = false;
    }

    public void stopServing() {
        this.active = false;
        this.entries = null;
    }

    public void save(Stamps stamps) throws IOException {
        if (this.saved) {
            return;
        }
        this.saved = true;
        stamps.scheduleSave(this, "all-resources.dat", this.prepopulated);
    }

    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        assert (!this.gathering);
        assert (!this.active);
        if (!this.prepopulated) {
            dataOutputStream.writeLong(6836742066851800321L);
            dataOutputStream.writeLong(System.currentTimeMillis());
        }
        for (String string : this.requests.keySet()) {
            String[] stringArray = string.split("!/");
            JarClassLoader.JarSource jarSource = this.knownSources.get(stringArray[0]);
            byte[] byArray = jarSource.resource(stringArray[1]);
            Integer n = this.sources.get(stringArray[0]);
            if (n == null) {
                n = this.sources.size();
                this.sources.put(stringArray[0], n);
                dataOutputStream.write(1);
                Archive.writeString(dataOutputStream, jarSource.getIdentifier());
            }
            dataOutputStream.write(2);
            dataOutputStream.writeChar(n);
            dataOutputStream.writeInt(byArray == null ? -1 : byArray.length);
            Archive.writeString(dataOutputStream, stringArray[1]);
            if (byArray == null) continue;
            dataOutputStream.write(byArray);
        }
        dataOutputStream.close();
        this.requests = null;
        this.knownSources = null;
        this.sources = null;
    }

    public void cacheReady() {
    }

    private static class Entry {
        private final int offset;
        private final ByteBuffer master;

        Entry(ByteBuffer byteBuffer) {
            this.master = byteBuffer;
            this.offset = this.master.position();
            int n = this.master.getInt(this.offset + 2);
            char c = this.master.getChar(this.offset + 6);
            if (n < 0) {
                n = 0;
            }
            this.master.position(this.offset + 8 + c + n);
        }

        String getName() {
            ByteBuffer byteBuffer = this.master.duplicate();
            byteBuffer.position(this.offset + 6);
            return Archive.parseString(byteBuffer);
        }

        int getSource() {
            return this.master.getChar(this.offset);
        }

        byte[] getContent() {
            int n = this.master.getInt(this.offset + 2);
            char c = this.master.getChar(this.offset + 6);
            if (n < 0) {
                return null;
            }
            ByteBuffer byteBuffer = this.master.duplicate();
            byteBuffer.position(this.offset + 8 + c);
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }

        public int hashCode() {
            ByteBuffer byteBuffer = this.master.duplicate();
            byteBuffer.position(this.offset + 8);
            byteBuffer.limit(this.offset + 8 + this.master.getChar(this.offset + 6));
            int n = 53 * this.master.getChar(this.offset);
            while (byteBuffer.hasRemaining()) {
                n = n * 53 + byteBuffer.get();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Template) {
                return object.equals(this);
            }
            return object == this;
        }

        public String toString() {
            return "#" + this.getSource() + ":" + this.getName() + "=[" + this.offset + "]";
        }
    }

    private class Template {
        private int source;
        private byte[] utf;

        Template(int n, String string) {
            try {
                this.source = n;
                this.utf = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.source != entry.master.getChar(entry.offset)) {
                return false;
            }
            if (this.utf.length != entry.master.getChar(entry.offset + 6)) {
                return false;
            }
            ByteBuffer byteBuffer = entry.master.duplicate();
            byteBuffer.position(((Entry)object).offset + 8);
            for (byte by : this.utf) {
                if (by == byteBuffer.get()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 53 * this.source;
            for (byte by : this.utf) {
                n = n * 53 + by;
            }
            return n;
        }
    }
}

