/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.Recurrence;
import tr.model.action.RecurrenceRemover;
import tr.model.project.Project;
import tr.util.Utils;
import tr.view.action.recurrence.modify.Modification;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardIterator;

public class ModifyRecurrenceWizard {
    private static final Logger LOG = Logger.getLogger("tr.view.action");
    private Data data;
    private Action action;
    private WizardDescriptor wizardDescriptor;

    public void start(Action action) {
        boolean cancelled;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        if (this.data == null) {
            return;
        }
        this.action = action;
        if (action == null) {
            return;
        }
        if (!action.isStateScheduled()) {
            return;
        }
        Recurrence recurrence = action.getRecurrence();
        if (recurrence == null) {
            return;
        }
        ModifyRecurrenceWizardIterator iterator = new ModifyRecurrenceWizardIterator(action, recurrence);
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle("Modify Recurrence");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.wizardDescriptor.putProperty("dialog", (Object)dialog);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = this.wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (cancelled) {
            return;
        }
        Modification modification = (Modification)((Object)this.wizardDescriptor.getProperty("modification"));
        switch (modification) {
            case CHANGE_PROJECT: {
                this.changeProject();
                return;
            }
            case CHANGE_ACTION: {
                this.changeAction();
                return;
            }
            case CHANGE_RECURRENCE: {
                this.changeRecurrence();
                return;
            }
            case REMOVE_RECURRENCE: {
                this.removeRecurrence();
                return;
            }
        }
    }

    private void changeProject() {
        Boolean moveAll;
        LOG.info("Begin");
        Project newProject = (Project)this.wizardDescriptor.getProperty("mod.project.newProject");
        if (newProject == null) {
            newProject = this.data.getRootActions();
        }
        if ((moveAll = (Boolean)this.wizardDescriptor.getProperty("mod.project.isMoveAll")) == null) {
            LOG.severe("Move all property was not found.");
            return;
        }
        Date moveDate = null;
        if (!moveAll.booleanValue() && (moveDate = (Date)this.wizardDescriptor.getProperty("mod.project.moveDate")) == null) {
            LOG.severe("Move date property was not found.");
            return;
        }
        Recurrence recurrence = this.action.getRecurrence();
        Project oldProject = recurrence.getProject();
        recurrence.setProject(newProject);
        LOG.info("Old Project: " + oldProject);
        LOG.info("New Project: " + newProject);
        if (moveAll.booleanValue()) {
            LOG.info("move all recurrence actions");
            recurrence.moveRecurrenceActions(oldProject);
        } else {
            LOG.info("remove recurrence from actions before " + moveDate);
            RecurrenceRemover.remove((Data)this.data, (int)recurrence.getID(), (Date)moveDate);
            LOG.info("move recurrence actions from " + moveDate);
            recurrence.moveRecurrenceActions(moveDate, oldProject);
        }
        LOG.info("End");
    }

    private void changeAction() {
        LOG.info("Begin");
        Recurrence changedRecurrence = (Recurrence)this.wizardDescriptor.getProperty("mod.action.recurrence");
        if (changedRecurrence == null) {
            LOG.severe("Recurrence property for action change was not found.");
            return;
        }
        Boolean update = (Boolean)this.wizardDescriptor.getProperty("mod.action.isUpdate");
        if (update == null) {
            LOG.severe("Update property for action change was not found.");
            return;
        }
        Boolean updateAll = (Boolean)this.wizardDescriptor.getProperty("mod.action.isUpdateAll");
        if (update.booleanValue() && updateAll == null) {
            LOG.severe("Update All property for action change was not found.");
            return;
        }
        Date updateDate = (Date)this.wizardDescriptor.getProperty("mod.action.updateDate");
        if (update.booleanValue() && !updateAll.booleanValue() && updateDate == null) {
            LOG.severe("Update Date property for action change was not found.");
            return;
        }
        Recurrence recurrence = this.action.getRecurrence();
        Vector<Recurrence.Property> changedProperties = new Vector<Recurrence.Property>();
        if (!Utils.equal((Object)recurrence.getScheduleHours(), (Object)changedRecurrence.getScheduleHours())) {
            changedProperties.add(Recurrence.Property.SCHEDULED_HOURS);
        }
        if (!Utils.equal((Object)recurrence.getScheduleMins(), (Object)changedRecurrence.getScheduleMins())) {
            changedProperties.add(Recurrence.Property.SCHEDULED_MINS);
        }
        if (!Utils.equal((Object)recurrence.getDurationHours(), (Object)changedRecurrence.getDurationHours())) {
            changedProperties.add(Recurrence.Property.DURATION_HOURS);
        }
        if (!Utils.equal((Object)recurrence.getDurationMins(), (Object)changedRecurrence.getDurationMins())) {
            changedProperties.add(Recurrence.Property.DURATION_MINS);
        }
        if (!Utils.equal((Object)recurrence.getDescription(), (Object)changedRecurrence.getDescription())) {
            changedProperties.add(Recurrence.Property.DESCRIPTION);
        }
        if (!Utils.equal((Object)recurrence.getSuccess(), (Object)changedRecurrence.getSuccess())) {
            changedProperties.add(Recurrence.Property.SUCCESS);
        }
        if (!Utils.equal((Object)recurrence.getContext(), (Object)changedRecurrence.getContext())) {
            changedProperties.add(Recurrence.Property.CONTEXT);
        }
        if (!Utils.equal((Object)recurrence.getTopic(), (Object)changedRecurrence.getTopic())) {
            changedProperties.add(Recurrence.Property.TOPIC);
        }
        if (!Utils.equal((Object)recurrence.getTime(), (Object)changedRecurrence.getTime())) {
            changedProperties.add(Recurrence.Property.TIME);
        }
        if (!Utils.equal((Object)recurrence.getEnergy(), (Object)changedRecurrence.getEnergy())) {
            changedProperties.add(Recurrence.Property.ENERGY);
        }
        if (!Utils.equal((Object)recurrence.getPriority(), (Object)changedRecurrence.getPriority())) {
            changedProperties.add(Recurrence.Property.PRIORITY);
        }
        if (!Utils.equal((Object)recurrence.getNotes(), (Object)changedRecurrence.getNotes())) {
            changedProperties.add(Recurrence.Property.NOTES);
        }
        if (changedProperties.size() == 0) {
            return;
        }
        recurrence.setScheduleHours(changedRecurrence.getScheduleHours());
        recurrence.setScheduleMins(changedRecurrence.getScheduleMins());
        recurrence.setDurationHours(changedRecurrence.getDurationHours());
        recurrence.setDurationMins(changedRecurrence.getDurationMins());
        recurrence.setDescription(changedRecurrence.getDescription());
        recurrence.setSuccess(changedRecurrence.getSuccess());
        recurrence.setContext(changedRecurrence.getContext());
        recurrence.setTopic(changedRecurrence.getTopic());
        recurrence.setTime(changedRecurrence.getTime());
        recurrence.setEnergy(changedRecurrence.getEnergy());
        recurrence.setPriority(changedRecurrence.getPriority());
        recurrence.setNotes(changedRecurrence.getNotes());
        if (update.booleanValue()) {
            if (updateAll.booleanValue()) {
                LOG.info("Update all");
                recurrence.updateRecurrenceActions(changedProperties);
            } else {
                LOG.info("Update from update date");
                recurrence.updateRecurrenceActions(changedProperties, updateDate);
            }
        }
        LOG.info("End");
    }

    private void changeRecurrence() {
        LOG.info("Begin");
        Recurrence.Basis oldBasis = (Recurrence.Basis)this.wizardDescriptor.getProperty("mod.old.basis");
        if (oldBasis == null) {
            LOG.severe("Old Basis property not found.");
            return;
        }
        Recurrence.Basis newBasis = (Recurrence.Basis)this.wizardDescriptor.getProperty("mod.new.basis");
        if (newBasis == null) {
            LOG.severe("New Basis property not found.");
            return;
        }
        Recurrence subsequentRecurrence = (Recurrence)this.wizardDescriptor.getProperty("mod.recurrence.subsequent");
        if (subsequentRecurrence == null) {
            LOG.severe("Subsequent recurrence property not found.");
            return;
        }
        Recurrence regularRecurrence = (Recurrence)this.wizardDescriptor.getProperty("mod.recurrence.regular");
        if (regularRecurrence == null) {
            LOG.severe("Regular recurrence property not found.");
            return;
        }
        Recurrence recurrence = this.action.getRecurrence();
        LOG.info("Old StartDate: " + recurrence.getStartDate());
        LOG.info("Old Basis: " + oldBasis);
        boolean intervalChanged = false;
        boolean terminationChanged = false;
        if (newBasis == Recurrence.Basis.DONE_DATE) {
            this.setRecurrenceChangeProperties(recurrence, subsequentRecurrence);
        } else {
            intervalChanged = !Utils.equal((Object)recurrence.getStartDate(), (Object)regularRecurrence.getStartDate()) || !Utils.equal((Object)recurrence.getFrequency(), (Object)regularRecurrence.getFrequency()) || !Utils.equal((Object)recurrence.getPeriod(), (Object)regularRecurrence.getPeriod());
            terminationChanged = !Utils.equal((Object)recurrence.getEndNbr(), (Object)regularRecurrence.getEndNbr()) || !Utils.equal((Object)recurrence.getEndDate(), (Object)regularRecurrence.getEndDate()) || !Utils.equal((Object)recurrence.getAdvanceNbr(), (Object)regularRecurrence.getAdvanceNbr());
            this.setRecurrenceChangeProperties(recurrence, regularRecurrence);
        }
        LOG.info("New StartDate: " + recurrence.getStartDate());
        LOG.info("New Basis: " + newBasis);
        if (newBasis != oldBasis) {
            LOG.info("Basis Changed");
            if (newBasis == Recurrence.Basis.DONE_DATE) {
                LOG.info("Removing recurrence reference from occurrences before start date");
                RecurrenceRemover.remove((Data)this.data, (int)recurrence.getID(), (Date)recurrence.getStartDate());
                LOG.info("Deleting occurrences after start date");
                recurrence.removeOccurrencesAfterStartDate();
            } else {
                LOG.info("Removing occurrences after start date");
                recurrence.removeOccurrencesAfterStartDate();
                LOG.info("Generating occurrences from start date");
                recurrence.generateFromStartDate();
            }
        } else if (newBasis == Recurrence.Basis.START_DATE) {
            if (intervalChanged) {
                LOG.info("Removing occurrences after start date");
                recurrence.removeOccurrencesAfterStartDate();
                LOG.info("Generating occurrences from start date");
                recurrence.generateFromStartDate();
            } else if (terminationChanged) {
                LOG.info("Updating termination");
                recurrence.updateTermination();
            }
        }
        LOG.info("End");
    }

    private void setRecurrenceChangeProperties(Recurrence recurrence, Recurrence values) {
        recurrence.setBasis(values.getBasis());
        recurrence.setStartDate(values.getStartDate());
        recurrence.setEndDate(values.getEndDate());
        recurrence.setEndNbr(values.getEndNbr());
        recurrence.setFrequency(values.getFrequency());
        recurrence.setPeriod(values.getPeriod());
        recurrence.setAdvanceNbr(values.getAdvanceNbr());
    }

    private void removeRecurrence() {
        LOG.info("Removing recurrence");
        int recurrenceID = this.action.getRecurrence().getID();
        this.action.setRecurrence(null);
        RecurrenceRemover.remove((Data)this.data, (int)recurrenceID);
    }
}

