/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.StatusBarUI;

public class BasicStatusBarUI
extends StatusBarUI {
    public static final String AUTO_ADD_SEPARATOR = new StringBuffer("auto-add-separator").toString();
    private JXStatusBar statusBar;

    public static ComponentUI createUI(JComponent c) {
        return new BasicStatusBarUI();
    }

    public void installUI(JComponent c) {
        LayoutManager m;
        assert (c instanceof JXStatusBar);
        this.statusBar = (JXStatusBar)c;
        Border b = this.statusBar.getBorder();
        if (b == null || b instanceof UIResource) {
            this.statusBar.setBorder(this.createBorder());
        }
        if ((m = this.statusBar.getLayout()) == null) {
            this.statusBar.setLayout(this.createLayout());
        }
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXStatusBar);
    }

    public void paint(Graphics g, JComponent c) {
        if (this.statusBar.isOpaque()) {
            Graphics2D g2 = (Graphics2D)g;
            this.paintBackground(g2, this.statusBar);
            if (this.includeSeparators()) {
                Insets sepInsets = new Insets(0, 0, 0, 0);
                this.getSeparatorInsets(sepInsets);
                for (int i = 0; i < this.statusBar.getComponentCount() - 1; ++i) {
                    Component comp = this.statusBar.getComponent(i);
                    int x = comp.getX() + comp.getWidth() + sepInsets.left;
                    int y = sepInsets.top;
                    int w = this.getSeparatorWidth() - sepInsets.left - sepInsets.right;
                    int h = c.getHeight() - sepInsets.top - sepInsets.bottom;
                    this.paintSeparator(g2, this.statusBar, x, y, w, h);
                }
            }
        }
    }

    protected void paintBackground(Graphics2D g, JXStatusBar bar) {
        if (bar.isOpaque()) {
            g.setColor(bar.getBackground());
            g.fillRect(0, 0, bar.getWidth(), bar.getHeight());
        }
    }

    protected void paintSeparator(Graphics2D g, JXStatusBar bar, int x, int y, int w, int h) {
        Color fg = UIManager.getColor("Separator.foreground");
        Color bg = UIManager.getColor("Separator.background");
        g.setColor(fg);
        g.drawLine(x += w / 2, y, x, h);
        g.setColor(bg);
        g.drawLine(x + 1, y, x + 1, h);
    }

    protected void getSeparatorInsets(Insets insets) {
        insets.top = 4;
        insets.left = 4;
        insets.bottom = 2;
        insets.right = 4;
    }

    protected int getSeparatorWidth() {
        return 10;
    }

    protected boolean includeSeparators() {
        Boolean b = (Boolean)this.statusBar.getClientProperty(AUTO_ADD_SEPARATOR);
        return b == null || b != false;
    }

    protected BorderUIResource createBorder() {
        return new BorderUIResource(BorderFactory.createEmptyBorder(4, 5, 4, 22));
    }

    protected LayoutManager createLayout() {
        return new LayoutManager2(){
            private Map<Component, JXStatusBar.Constraint> constraints = new HashMap<Component, JXStatusBar.Constraint>();

            public void addLayoutComponent(String name, Component comp) {
                this.addLayoutComponent(comp, null);
            }

            public void removeLayoutComponent(Component comp) {
                this.constraints.remove(comp);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            public Dimension maximumLayoutSize(Container target) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }

            public float getLayoutAlignmentX(Container target) {
                return 0.5f;
            }

            public float getLayoutAlignmentY(Container target) {
                return 0.5f;
            }

            public void invalidateLayout(Container target) {
            }

            public void addLayoutComponent(Component comp, Object constraint) {
                if (constraint instanceof Insets) {
                    constraint = new JXStatusBar.Constraint((Insets)constraint);
                } else if (constraint instanceof JXStatusBar.Constraint.ResizeBehavior) {
                    constraint = new JXStatusBar.Constraint((JXStatusBar.Constraint.ResizeBehavior)((Object)constraint));
                }
                this.constraints.put(comp, (JXStatusBar.Constraint)constraint);
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension prefSize = new Dimension();
                int count = 0;
                for (Component comp : this.constraints.keySet()) {
                    JXStatusBar.Constraint c = this.constraints.get(comp);
                    Dimension d = comp.getPreferredSize();
                    int prefWidth = 0;
                    if (c != null) {
                        Insets i = c.getInsets();
                        d.width += i.left + i.right;
                        d.height += i.top + i.bottom;
                        prefWidth = c.getFixedWidth();
                    }
                    prefSize.height = Math.max(prefSize.height, d.height);
                    prefSize.width += Math.max(d.width, prefWidth);
                    if (!BasicStatusBarUI.this.includeSeparators() || this.constraints.size() >= ++count) continue;
                    prefSize.width += BasicStatusBarUI.this.getSeparatorWidth();
                }
                Insets insets = parent.getInsets();
                prefSize.height += insets.top + insets.bottom;
                prefSize.width += insets.left + insets.right;
                return prefSize;
            }

            public void layoutContainer(Container parent) {
                Insets parentInsets = parent.getInsets();
                int availableWidth = parent.getWidth() - parentInsets.left - parentInsets.right;
                if (BasicStatusBarUI.this.includeSeparators()) {
                    availableWidth -= (parent.getComponentCount() - 1) * BasicStatusBarUI.this.getSeparatorWidth();
                }
                int[] preferredWidths = new int[parent.getComponentCount()];
                int sumPreferredWidths = 0;
                for (int i = 0; i < preferredWidths.length; ++i) {
                    preferredWidths[i] = this.getPreferredWidth(parent.getComponent(i));
                    sumPreferredWidths += preferredWidths[i];
                }
                if (availableWidth > sumPreferredWidths) {
                    int numFilledComponents = 0;
                    for (Component comp : parent.getComponents()) {
                        JXStatusBar.Constraint c = this.constraints.get(comp);
                        if (c == null || c.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                        ++numFilledComponents;
                    }
                    if (numFilledComponents > 0) {
                        double weight = 1.0 / (double)numFilledComponents;
                        int share = (int)((double)(availableWidth -= sumPreferredWidths) * weight);
                        int remaining = numFilledComponents;
                        for (int i = 0; i < parent.getComponentCount(); ++i) {
                            Component comp = parent.getComponent(i);
                            JXStatusBar.Constraint c = this.constraints.get(comp);
                            if (c == null || c.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                            if (remaining > 1) {
                                int n = i;
                                preferredWidths[n] = preferredWidths[n] + share;
                                availableWidth -= share;
                            } else {
                                int n = i;
                                preferredWidths[n] = preferredWidths[n] + availableWidth;
                            }
                            --remaining;
                        }
                    }
                }
                int nextX = parentInsets.left;
                int height = parent.getHeight() - parentInsets.top - parentInsets.bottom;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    JXStatusBar.Constraint c = this.constraints.get(comp);
                    Insets insets = c == null ? new Insets(0, 0, 0, 0) : c.getInsets();
                    int width = preferredWidths[i] - (insets.left + insets.right);
                    int x = nextX + insets.left;
                    int y = parentInsets.top + insets.top;
                    comp.setSize(width, height);
                    comp.setLocation(x, y);
                    nextX = x + width + insets.right;
                    if (!BasicStatusBarUI.this.includeSeparators() || i >= parent.getComponentCount() - 1) continue;
                    nextX += BasicStatusBarUI.this.getSeparatorWidth();
                }
            }

            private int getPreferredWidth(Component comp) {
                JXStatusBar.Constraint c = this.constraints.get(comp);
                if (c == null) {
                    return comp.getPreferredSize().width;
                }
                Insets insets = c.getInsets();
                assert (insets != null);
                if (c.getFixedWidth() <= 0) {
                    return comp.getPreferredSize().width + insets.left + insets.right;
                }
                return c.getFixedWidth() + insets.left + insets.right;
            }
        };
    }
}

