/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.DateSelectionListener;
import org.jdesktop.swingx.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.EventListenerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDateSelectionModel
implements DateSelectionModel {
    private EventListenerMap listenerMap = new EventListenerMap();
    private DateSelectionModel.SelectionMode selectionMode = DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    private SortedSet<Date> selectedDates = new TreeSet<Date>();
    private SortedSet<Date> unselectableDates = new TreeSet<Date>();
    private Calendar cal = Calendar.getInstance();
    private int firstDayOfWeek = 1;
    private Date upperBound;
    private Date lowerBound;

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.clearSelection();
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @Override
    public void addSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                this.clearSelectionImpl();
                this.selectedDates.add(startDate);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                this.addSelectionImpl(startDate, endDate);
                break;
            }
        }
        this.fireValueChanged(DateSelectionEvent.EventType.DATES_ADDED);
    }

    @Override
    public void setSelectionInterval(Date startDate, Date endDate) {
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                this.clearSelectionImpl();
                this.selectedDates.add(startDate);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
        }
        this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
    }

    @Override
    public void removeSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        long startDateMs = startDate.getTime();
        long endDateMs = endDate.getTime();
        ArrayList<Date> datesToRemove = new ArrayList<Date>();
        for (Date selectedDate : this.selectedDates) {
            long selectedDateMs = selectedDate.getTime();
            if (selectedDateMs < startDateMs || selectedDateMs > endDateMs) continue;
            datesToRemove.add(selectedDate);
        }
        if (!datesToRemove.isEmpty()) {
            this.selectedDates.removeAll(datesToRemove);
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
        }
    }

    @Override
    public void clearSelection() {
        this.clearSelectionImpl();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    private void clearSelectionImpl() {
        this.selectedDates.clear();
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public boolean isSelected(Date date) {
        return this.selectedDates.contains(date);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.size() == 0;
    }

    @Override
    public void addDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.add(DateSelectionListener.class, l);
    }

    @Override
    public void removeDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.remove(DateSelectionListener.class, l);
    }

    @Override
    public SortedSet<Date> getUnselectableDates() {
        return new TreeSet<Date>(this.unselectableDates);
    }

    @Override
    public void setUnselectableDates(SortedSet<Date> unselectableDates) {
        this.unselectableDates = unselectableDates;
        for (Date unselectableDate : this.unselectableDates) {
            this.removeSelectionInterval(unselectableDate, unselectableDate);
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UNSELECTED_DATES_CHANGED);
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        return this.upperBound != null && this.upperBound.getTime() < date.getTime() || this.lowerBound != null && this.lowerBound.getTime() > date.getTime() || this.unselectableDates != null && this.unselectableDates.contains(date);
    }

    @Override
    public Date getUpperBound() {
        return this.upperBound;
    }

    @Override
    public void setUpperBound(Date upperBound) {
        if (upperBound != null && !upperBound.equals(this.upperBound) || upperBound == null && upperBound != this.upperBound) {
            this.upperBound = upperBound;
            if (!this.selectedDates.isEmpty() && this.selectedDates.last().after(this.upperBound) && this.upperBound != null) {
                long justAboveUpperBoundMs = this.upperBound.getTime() + 1L;
                if (!this.selectedDates.isEmpty() && this.selectedDates.last().before(this.upperBound)) {
                    this.removeSelectionInterval(this.upperBound, new Date(justAboveUpperBoundMs));
                }
            }
            this.fireValueChanged(DateSelectionEvent.EventType.UPPER_BOUND_CHANGED);
        }
    }

    @Override
    public Date getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public void setLowerBound(Date lowerBound) {
        if (lowerBound != null && !lowerBound.equals(this.lowerBound) || lowerBound == null && lowerBound != this.lowerBound) {
            this.lowerBound = lowerBound;
            if (this.lowerBound != null) {
                long justBelowLowerBoundMs = this.lowerBound.getTime() - 1L;
                if (!this.selectedDates.isEmpty() && this.selectedDates.first().before(this.lowerBound)) {
                    this.removeSelectionInterval(this.selectedDates.first(), new Date(justBelowLowerBoundMs));
                }
            }
            this.fireValueChanged(DateSelectionEvent.EventType.LOWER_BOUND_CHANGED);
        }
    }

    public List<DateSelectionListener> getDateSelectionListeners() {
        return this.listenerMap.getListeners(DateSelectionListener.class);
    }

    protected void fireValueChanged(DateSelectionEvent.EventType eventType) {
        List<DateSelectionListener> listeners = this.getDateSelectionListeners();
        DateSelectionEvent e = null;
        for (DateSelectionListener listener : listeners) {
            if (e == null) {
                e = new DateSelectionEvent(this, eventType);
            }
            listener.valueChanged(e);
        }
    }

    private void addSelectionImpl(Date startDate, Date endDate) {
        this.cal.setTime(startDate);
        Date date = this.cal.getTime();
        while (date.before(endDate) || date.equals(endDate)) {
            this.selectedDates.add(date);
            this.cal.add(5, 1);
            date = this.cal.getTime();
        }
    }
}

