/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XMLDataObjectInfoParser
extends DefaultHandler
implements FileChangeListener,
LexicalHandler,
LookupListener {
    private static final StopSaxException STOP = new StopSaxException();
    private static XMLReader sharedParserImpl = null;
    private static final String NULL = "";
    private Reference<XMLDataObject> xml;
    private String parsedId;
    private Lookup lookup;
    private Lookup.Result result;
    private ThreadLocal<Class<?>> QUERY = new ThreadLocal();

    XMLDataObjectInfoParser(XMLDataObject xMLDataObject) {
        this.xml = new WeakReference<XMLDataObject>(xMLDataObject);
    }

    public String getPublicId() {
        String string;
        String string2 = this.waitFinished();
        return string2 == (string = NULL) ? null : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupCookie(final Class<?> clazz) {
        if (this.QUERY.get() == clazz) {
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Cyclic deps on queried class: " + clazz + " for " + this.getXml());
            }
            return new InstanceCookie(){

                public Class<?> instanceClass() {
                    return clazz;
                }

                public Object instanceCreate() throws IOException {
                    throw new IOException("Cyclic reference, sorry: " + clazz);
                }

                public String instanceName() {
                    return clazz.getName();
                }
            };
        }
        Class<?> clazz2 = this.QUERY.get();
        try {
            Lookup lookup;
            Object object;
            String string;
            block18: {
                this.QUERY.set(clazz);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Will do query for class: " + clazz + " for " + this.getXml());
                }
                do {
                    string = this.waitFinished();
                    object = this;
                    synchronized (object) {
                        lookup = this.lookup != null ? this.lookup : null;
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Lookup is " + lookup + " for id: " + string);
                    }
                    if (lookup == null) {
                        lookup = this.updateLookup(this.getXml(), null, string);
                        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                            XMLDataObject.ERR.fine("Updating lookup: " + lookup);
                        }
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Wait lookup is over: " + lookup + this.getXml());
                    }
                    if (lookup != null) break block18;
                } while (this.parsedId != null);
                lookup = Lookup.EMPTY;
            }
            if ((string = this.result) != null) {
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Querying the result: " + string);
                }
                string.allItems();
            } else if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("No result for lookup: " + this.lookup);
            }
            object = lookup.lookup(clazz);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Returning value: " + object + " for " + this.getXml());
            }
            Object object2 = object;
            Object var8_8 = null;
            this.QUERY.set(clazz2);
            return object2;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.QUERY.set(clazz2);
            throw throwable;
        }
    }

    public String waitFinished() {
        return this.waitFinished(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String waitFinished(String var1_1) {
        if (XMLDataObjectInfoParser.sharedParserImpl == null) {
            XMLDataObject.ERR.fine("No sharedParserImpl, exiting");
            return "";
        }
        var2_2 = XMLDataObjectInfoParser.sharedParserImpl;
        var3_3 = this.getXml();
        if (var3_3 == null) {
            return "";
        }
        var4_4 = var3_3.getPrimaryFile();
        var5_5 = null;
        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
            XMLDataObject.ERR.fine("Going to read parsedId for " + var3_3);
        }
        var7_6 = this;
        synchronized (var7_6) {
            var6_7 = this.parsedId;
            ** if (var6_7 == null) goto lbl19
        }
lbl-1000:
        // 1 sources

        {
            if (XMLDataObject.ERR.isLoggable(Level.FINE) == false) return var6_7;
            XMLDataObject.ERR.fine("Has already been parsed: " + this.parsedId + " for " + var3_3);
            return var6_7;
        }
lbl19:
        // 1 sources

        var7_6 = null;
        var8_8 = null;
        try {
            var7_6 = var4_4.getURL();
        }
        catch (IOException var9_9) {
            this.warning(var9_9, "I/O exception while retrieving xml FileObject URL.");
            return "";
        }
        var9_10 = this;
        synchronized (var9_10) {
            block71: {
                block59: {
                    block69: {
                        block70: {
                            block54: {
                                block60: {
                                    block53: {
                                        try {
                                            if (!var4_4.isValid()) {
                                                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                                                    XMLDataObject.ERR.fine("Invalid file object: " + var4_4);
                                                }
                                                var10_11 = "";
                                                var17_18 = null;
                                                break block53;
                                            }
                                            this.parsedId = "";
                                            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                                                XMLDataObject.ERR.fine("parsedId set to NULL for " + var3_3);
                                            }
                                            try {
                                                var8_8 = var4_4.getInputStream();
                                                break block54;
                                            }
                                            catch (IOException var10_12) {
                                                this.warning(var10_12, "I/O exception while openning xml.");
                                                var11_26 = "";
                                                var17_19 = null;
                                                try {
                                                    if (var8_8 == null) return var11_26;
                                                    var8_8.close();
                                                }
                                                catch (IOException var18_23) {
                                                    XMLDataObject.ERR.log(Level.WARNING, null, var18_23);
                                                }
                                                return var11_26;
                                            }
                                        }
                                        catch (Throwable var16_43) {
                                            var17_21 = null;
                                            ** try [egrp 11[TRYBLOCK] [22 : 781->794)] { 
lbl60:
                                            // 1 sources

                                            if (var8_8 == null) throw var16_43;
                                            var8_8.close();
                                            throw var16_43;
lbl63:
                                            // 1 sources

                                            catch (IOException var18_25) {
                                                XMLDataObject.ERR.log(Level.WARNING, null, var18_25);
                                            }
                                            throw var16_43;
                                        }
                                    }
                                    ** try [egrp 11[TRYBLOCK] [22 : 781->794)] { 
lbl68:
                                    // 1 sources

                                    if (var8_8 == null) return var10_11;
                                    var8_8.close();
                                    break block60;
lbl71:
                                    // 1 sources

                                    catch (IOException var18_22) {
                                        XMLDataObject.ERR.log(Level.WARNING, null, var18_22);
                                    }
                                }
                                return var10_11;
                            }
                            try {
                                block56: {
                                    try {
                                        var10_13 = XMLDataObjectInfoParser.sharedParserImpl;
                                        synchronized (var10_13) {
                                            this.configureParser(var2_2, false, this);
                                            var2_2.setContentHandler(this);
                                            var2_2.setErrorHandler(this);
                                            var11_27 = new InputSource(var7_6.toExternalForm());
                                            var11_27.setByteStream(var8_8);
                                            var2_2.parse(var11_27);
                                            if (!XMLDataObject.ERR.isLoggable(Level.FINE)) break block56;
                                        }
                                        XMLDataObject.ERR.fine("Parse finished for " + var3_3);
                                    }
                                    catch (StopSaxException var10_14) {
                                        var5_5 = this.parsedId;
                                        XMLDataObject.ERR.fine("Parsing successfully stopped: " + this.parsedId + " for " + var3_3);
                                        var14_30 = null;
                                        if (Boolean.getBoolean("netbeans.profile.memory")) {
                                            var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                                            var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                                            try {
                                                var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                                            }
                                            catch (SAXException var15_36 /* !! */ ) {
                                                // empty catch block
                                            }
                                            try {
                                                var2_2.parse((InputSource)null);
                                            }
                                            catch (Exception var15_36 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        var2_2 = null;
                                        break block59;
                                    }
                                    catch (SAXException var10_15) {
                                        block61: {
                                            block62: {
                                                if (XMLDataObjectInfoParser.STOP.getMessage().equals(var10_15.getMessage())) {
                                                    var5_5 = this.parsedId;
                                                    XMLDataObject.ERR.fine("Parsing stopped with STOP message: " + this.parsedId + " for " + var3_3);
                                                } else {
                                                    var11_28 = "Thread:" + Thread.currentThread().getName();
                                                    XMLDataObject.ERR.warning("DocListener should not throw SAXException but STOP one.\n" + var11_28);
                                                    XMLDataObject.ERR.log(Level.WARNING, null, var10_15);
                                                    var12_41 = var10_15.getException();
                                                    if (var12_41 != null) {
                                                        XMLDataObject.ERR.log(Level.WARNING, null, var12_41);
                                                    }
                                                }
                                                var14_31 = null;
                                                if (!Boolean.getBoolean("netbeans.profile.memory")) break block61;
                                                var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                                                var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                                                ** try [egrp 8[TRYBLOCK] [16 : 730->744)] { 
lbl128:
                                                // 1 sources

                                                var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                                                break block62;
lbl130:
                                                // 1 sources

                                                catch (SAXException var15_37 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            ** try [egrp 9[TRYBLOCK] [17 : 746->759)] { 
lbl134:
                                            // 1 sources

                                            var2_2.parse((InputSource)null);
                                            break block61;
lbl136:
                                            // 1 sources

                                            catch (Exception var15_37 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        var2_2 = null;
                                        break block59;
                                    }
                                    catch (FileNotFoundException var10_16) {
                                        block63: {
                                            block64: {
                                                XMLDataObject.ERR.log(Level.WARNING, null, var10_16);
                                                var14_32 = null;
                                                if (!Boolean.getBoolean("netbeans.profile.memory")) break block63;
                                                var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                                                var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                                                ** try [egrp 8[TRYBLOCK] [16 : 730->744)] { 
lbl149:
                                                // 1 sources

                                                var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                                                break block64;
lbl151:
                                                // 1 sources

                                                catch (SAXException var15_38 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            ** try [egrp 9[TRYBLOCK] [17 : 746->759)] { 
lbl155:
                                            // 1 sources

                                            var2_2.parse((InputSource)null);
                                            break block63;
lbl157:
                                            // 1 sources

                                            catch (Exception var15_38 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        var2_2 = null;
                                        break block59;
                                    }
                                    catch (IOException var10_17) {
                                        block65: {
                                            block66: {
                                                XMLDataObject.ERR.log(Level.WARNING, null, var10_17);
                                                var14_33 = null;
                                                if (!Boolean.getBoolean("netbeans.profile.memory")) break block65;
                                                var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                                                var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                                                ** try [egrp 8[TRYBLOCK] [16 : 730->744)] { 
lbl170:
                                                // 1 sources

                                                var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                                                break block66;
lbl172:
                                                // 1 sources

                                                catch (SAXException var15_39 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            ** try [egrp 9[TRYBLOCK] [17 : 746->759)] { 
lbl176:
                                            // 1 sources

                                            var2_2.parse((InputSource)null);
                                            break block65;
lbl178:
                                            // 1 sources

                                            catch (Exception var15_39 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        var2_2 = null;
                                        break block59;
                                    }
                                }
                                var14_29 = null;
                            }
                            catch (Throwable var13_42) {
                                block67: {
                                    block68: {
                                        var14_34 = null;
                                        if (!Boolean.getBoolean("netbeans.profile.memory")) break block67;
                                        var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                                        var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                                        ** try [egrp 8[TRYBLOCK] [16 : 730->744)] { 
lbl193:
                                        // 1 sources

                                        var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                                        break block68;
lbl195:
                                        // 1 sources

                                        catch (SAXException var15_40 /* !! */ ) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 9[TRYBLOCK] [17 : 746->759)] { 
lbl199:
                                    // 1 sources

                                    var2_2.parse((InputSource)null);
                                    break block67;
lbl201:
                                    // 1 sources

                                    catch (Exception var15_40 /* !! */ ) {
                                        // empty catch block
                                    }
                                }
                                var2_2 = null;
                                throw var13_42;
                            }
                            if (!Boolean.getBoolean("netbeans.profile.memory")) break block69;
                            var2_2.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                            var2_2.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                            ** try [egrp 8[TRYBLOCK] [16 : 730->744)] { 
lbl210:
                            // 1 sources

                            var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                            break block70;
lbl212:
                            // 1 sources

                            catch (SAXException var15_35 /* !! */ ) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 9[TRYBLOCK] [17 : 746->759)] { 
lbl216:
                        // 1 sources

                        var2_2.parse((InputSource)null);
                        break block69;
lbl218:
                        // 1 sources

                        catch (Exception var15_35 /* !! */ ) {
                            // empty catch block
                        }
                    }
                    var2_2 = null;
                }
                var17_20 = null;
                ** try [egrp 11[TRYBLOCK] [22 : 781->794)] { 
lbl225:
                // 1 sources

                if (var8_8 != null) {
                    var8_8.close();
                }
                break block71;
lbl229:
                // 1 sources

                catch (IOException var18_24) {
                    XMLDataObject.ERR.log(Level.WARNING, null, var18_24);
                }
            }
            ** if (var1_1 == null || !var5_5.equals((Object)var1_1)) goto lbl236
        }
lbl-1000:
        // 1 sources

        {
            if (XMLDataObject.ERR.isLoggable(Level.FINE) == false) return var5_5;
            XMLDataObject.ERR.fine("No update to ID: " + var1_1 + " for " + var3_3);
            return var5_5;
        }
lbl236:
        // 1 sources

        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
            XMLDataObject.ERR.fine("New id: " + var5_5 + " for " + var3_3);
        }
        if (var5_5 == null) return var5_5;
        this.updateLookup(var3_3, var6_7, var5_5);
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup updateLookup(XMLDataObject xMLDataObject, String string, String string2) {
        if (xMLDataObject == null) {
            return this.lookup;
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
        synchronized (xMLDataObjectInfoParser) {
            if (string != null && string.equals(string2) && this.lookup != null) {
                XMLDataObject.ERR.fine("No need to update lookup: " + string2 + " for " + xMLDataObject);
                return this.lookup;
            }
        }
        XMLDataObject.Info info = XMLDataObject.getRegisteredInfo(string2);
        if (info != null) {
            xMLDataObjectInfoParser = XMLDataObject.createInfoLookup(xMLDataObject, info);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from info: " + xMLDataObjectInfoParser + " for " + xMLDataObject);
            }
        } else {
            xMLDataObjectInfoParser = Environment.findForOne(xMLDataObject);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from env: " + xMLDataObjectInfoParser + " for " + xMLDataObject);
            }
            if (xMLDataObjectInfoParser == null) {
                xMLDataObjectInfoParser = Lookup.EMPTY;
            }
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser2 = this;
        synchronized (xMLDataObjectInfoParser2) {
            Lookup.Result result = this.result;
            this.lookup = xMLDataObjectInfoParser;
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Shared lookup updated: " + this.lookup + " for " + xMLDataObject);
            }
            this.result = this.lookup.lookupResult(Node.Cookie.class);
            this.result.addLookupListener((LookupListener)this);
            if (result != null) {
                result.removeLookupListener((LookupListener)this);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing property change for " + xMLDataObject);
                }
                xMLDataObject.firePropertyChange("cookie", null, null);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing done for " + xMLDataObject);
                }
            }
            return xMLDataObjectInfoParser;
        }
    }

    private void configureParser(XMLReader xMLReader, boolean bl, LexicalHandler lexicalHandler) {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
        }
        catch (SAXException sAXException) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support validation feature.");
        }
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        }
        catch (SAXException sAXException) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support lexical-handler feature.");
        }
    }

    public void warning(Throwable throwable) {
        this.warning(throwable, null);
    }

    public void warning(Throwable throwable, String string) {
        XMLDataObject.ERR.log(Level.WARNING, string, throwable);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.parsedId = string2 == null ? NULL : string2;
        XMLDataObject.ERR.fine("Parsed to " + this.parsedId);
        this.stop();
    }

    @Override
    public void endDTD() throws SAXException {
        this.stop();
    }

    @Override
    public void startEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startEntity {0}", string);
    }

    @Override
    public void endEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endEntity {0}", string);
    }

    @Override
    public void startCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startCDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endCDATA");
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "comment len: {0}", n2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.stop();
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.stop();
    }

    @Override
    public void endDocument() throws SAXException {
        this.stop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stop();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "characters len: {0}", n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endElement: {0}", string3);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endPrefix: {0}", string);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "ignorableWhitespace: {0}", n2);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "notationDecl: {0}", string);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "processingInstruction: {0}", string);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "resolveEntity: {0}", string);
        return super.resolveEntity(string, string2);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "skippedEntity: {0}", string);
    }

    @Override
    public void startDocument() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startDocument");
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startElement: {0}", string3);
        this.stop();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startPrefixMapping: {0}", string);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "unparsedEntityDecl: {0}", string);
    }

    private void stop() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "stop");
        throw STOP;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    private void fileCreated(FileObject fileObject) {
    }

    public void fileChanged(FileEvent fileEvent) {
        XMLDataObject xMLDataObject = this.getXml();
        if (xMLDataObject == null) {
            return;
        }
        if (xMLDataObject.getPrimaryFile().equals(fileEvent.getFile())) {
            xMLDataObject.clearDocument();
            String string = this.parsedId;
            this.parsedId = null;
            XMLDataObject.ERR.fine("cleared parsedId");
            this.waitFinished(string);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void resultChanged(LookupEvent lookupEvent) {
        XMLDataObject xMLDataObject = this.getXml();
        if (xMLDataObject == null) {
            return;
        }
        xMLDataObject.firePropertyChange("cookie", null, null);
        Node node = xMLDataObject.getNodeDelegateOrNull();
        if (node instanceof XMLDataObject.XMLNode) {
            ((XMLDataObject.XMLNode)node).update();
        }
    }

    private XMLDataObject getXml() {
        return this.xml.get();
    }

    static {
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException sAXException) {
            Exceptions.attachLocalizedMessage((Throwable)sAXException, (String)"System does not contain JAXP 1.1 compliant parser!");
            Logger.getLogger(XMLDataObject.class.getName()).log(Level.WARNING, null, sAXException);
        }
        try {
            Properties properties = System.getProperties();
            if (properties.getProperty("org.xml.sax.driver") == null) {
                properties.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = new InputSource(new StringReader(XMLDataObjectInfoParser.NULL));
            inputSource.setSystemId("StringReader");
            return inputSource;
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }
}

