/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.dates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.prefs.dates.DatesOptionsPanelController;
import tr.prefs.dates.DatesPrefs;

final class DatesOptionsPanel
extends JPanel {
    private final DatesOptionsPanelController controller;
    private JComboBox dayCombo;
    private JLabel dayLabel;
    private JComboBox orderCombo;
    private JLabel orderLabel;
    private static Vector<ComboItem> days;
    private static Vector<ComboItem> orders;

    DatesOptionsPanel(DatesOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.dayLabel = new JLabel();
        this.dayCombo = new JComboBox();
        this.orderLabel = new JLabel();
        this.orderCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setMinimumSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((JLabel)this.dayLabel, (String)NbBundle.getMessage(DatesOptionsPanel.class, (String)"Dates.FirstDayOfWeek"));
        this.dayLabel.setMaximumSize(new Dimension(134, 23));
        this.dayLabel.setMinimumSize(new Dimension(134, 23));
        this.dayLabel.setPreferredSize(new Dimension(134, 23));
        this.dayCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.dayCombo.setMinimumSize(new Dimension(41, 23));
        this.dayCombo.setPreferredSize(new Dimension(41, 23));
        this.dayCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatesOptionsPanel.this.windowSelected(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.orderLabel, (String)NbBundle.getMessage(DatesOptionsPanel.class, (String)"Dates.Order"));
        this.orderLabel.setMaximumSize(new Dimension(134, 23));
        this.orderLabel.setMinimumSize(new Dimension(134, 23));
        this.orderLabel.setPreferredSize(new Dimension(134, 23));
        this.orderCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.orderCombo.setMinimumSize(new Dimension(41, 23));
        this.orderCombo.setPreferredSize(new Dimension(41, 23));
        this.orderCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatesOptionsPanel.this.positionSelected(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dayLabel, -2, -1, -2).add((Component)this.orderLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.orderCombo, 0, 222, Short.MAX_VALUE).add((Component)this.dayCombo, 0, 222, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dayLabel, -2, -1, -2).add((Component)this.dayCombo, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.orderLabel, -2, -1, -2).add((Component)this.orderCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void positionSelected(ActionEvent evt) {
        this.controller.changed();
    }

    private void windowSelected(ActionEvent evt) {
        this.controller.changed();
    }

    void load() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DatesOptionsPanel.this.doLoad();
                }
            });
        }
    }

    private void doLoad() {
        this.initDayItems();
        this.dayCombo.setModel(new DefaultComboBoxModel<ComboItem>(days));
        this.dayCombo.setMaximumRowCount(days.size());
        this.dayCombo.setSelectedItem(this.getDayItem(DatesPrefs.getFirstDayOfWeek()));
        this.initOrderItems();
        this.orderCombo.setModel(new DefaultComboBoxModel<ComboItem>(orders));
        this.orderCombo.setMaximumRowCount(orders.size());
        this.orderCombo.setSelectedItem(this.getOrderItem(DatesPrefs.getDateOrder()));
    }

    private void initDayItems() {
        days = new Vector();
        days.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"Sunday"), 1));
        days.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"Monday"), 2));
    }

    private void initOrderItems() {
        orders = new Vector();
        orders.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"MMDDYY"), 0));
        orders.add(new ComboItem(NbBundle.getMessage(this.getClass(), (String)"DDMMYY"), 1));
    }

    void store() {
        ComboItem orderItem;
        ComboItem dayItem = (ComboItem)this.dayCombo.getSelectedItem();
        if (dayItem != null) {
            DatesPrefs.setFirstDayOfWeek(dayItem.value);
        }
        if ((orderItem = (ComboItem)this.orderCombo.getSelectedItem()) != null) {
            DatesPrefs.setDateOrder(orderItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private ComboItem getDayItem(int value) {
        for (ComboItem item : days) {
            if (item.value != value) continue;
            return item;
        }
        return days.get(0);
    }

    private ComboItem getOrderItem(int value) {
        for (ComboItem item : orders) {
            if (item.value != value) continue;
            return item;
        }
        return orders.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComboItem
    implements Comparable<ComboItem> {
        public final String label;
        public final int value;

        public ComboItem(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(ComboItem item) {
            return item.label.compareToIgnoreCase(this.label);
        }
    }
}

