/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileObject
implements Serializable {
    static final long serialVersionUID = 85305031923497718L;

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        if (this.isFolder()) {
            throw new IOException(NbBundle.getBundle(FileObject.class).getString("EXC_FolderCopy"));
        }
        FileObject fileObject2 = FileUtil.copyFileImpl(this, fileObject, string, string2);
        return fileObject2;
    }

    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        if (this.getParent().equals(fileObject)) {
            this.rename(fileLock, string, string2);
            return this;
        }
        FileObject fileObject2 = this.copy(fileObject, string, string2);
        this.delete(fileLock);
        return fileObject2;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        try {
            return string2 + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + (this.isRoot() ? "root of " + this.getFileSystem() : this.getPath()) + ']';
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return string2 + '@' + Integer.toHexString(System.identityHashCode(this)) + "[???]";
        }
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        this.constructName(stringBuilder, '/');
        return stringBuilder.toString();
    }

    @Deprecated
    public String getPackageNameExt(char c, char c2) {
        assert (FileUtil.assertDeprecatedMethod());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.getNameExt();
        }
        this.getParent().constructName(stringBuilder, c);
        String string = this.getExt();
        if (string == null || string.equals("")) {
            stringBuilder.append(c).append(this.getNameExt());
        } else {
            stringBuilder.append(c).append(this.getName()).append(c2).append(this.getExt());
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String getPackageName(char c) {
        assert (FileUtil.assertDeprecatedMethod());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.isFolder() ? this.getNameExt() : this.getName();
        }
        this.getParent().constructName(stringBuilder, c);
        stringBuilder.append(c).append(this.getName());
        return stringBuilder.toString();
    }

    public String getNameExt() {
        String string = this.getName();
        String string2 = this.getExt();
        return string2 == null || string2.length() == 0 ? string : string + '.' + string2;
    }

    private void constructName(StringBuilder stringBuilder, char c) {
        FileObject fileObject = this.getParent();
        if (fileObject != null && !fileObject.isRoot()) {
            fileObject.constructName(stringBuilder, c);
            stringBuilder.append(c);
        }
        stringBuilder.append(this.getNameExt());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String string) {
        FileObject fileObject = this.getParent();
        return fileObject != null && fileObject.getFileObject(this.getName(), string) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        FileLock fileLock = this.lock();
        try {
            this.delete(fileLock);
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration<String> getAttributes();

    public final boolean hasExt(String string) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(string);
        }
        return this.getExt().equals(string);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String string) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        this.dispatchEvent(FCLSupport.Op.DATA_CREATED, enumeration, fileEvent);
    }

    protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        this.dispatchEvent(FCLSupport.Op.FOLDER_CREATED, enumeration, fileEvent);
    }

    protected void fireFileChangedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        this.dispatchEvent(FCLSupport.Op.FILE_CHANGED, enumeration, fileEvent);
    }

    protected void fireFileDeletedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        this.dispatchEvent(FCLSupport.Op.FILE_DELETED, enumeration, fileEvent);
    }

    protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> enumeration, FileAttributeEvent fileAttributeEvent) {
        this.dispatchEvent(FCLSupport.Op.ATTR_CHANGED, enumeration, fileAttributeEvent);
    }

    protected void fireFileRenamedEvent(Enumeration<FileChangeListener> enumeration, FileRenameEvent fileRenameEvent) {
        this.dispatchEvent(FCLSupport.Op.FILE_RENAMED, enumeration, fileRenameEvent);
    }

    private final void dispatchEvent(FCLSupport.Op op, Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        try {
            FileSystem fileSystem = this.getFileSystem();
            fileSystem.dispatchEvent(new ED(op, enumeration, fileEvent));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    final void dispatchEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        try {
            this.getFileSystem().dispatchEvent(new ED(enumeration, fileEvent));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        return FileUtil.getMIMETypeOrDefault(this);
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public final OutputStream getOutputStream() throws FileAlreadyLockedException, IOException {
        final FileLock fileLock = this.lock();
        try {
            OutputStream outputStream = this.getOutputStream(fileLock);
            return new FilterOutputStream(outputStream){

                public void close() throws IOException {
                    try {
                        super.close();
                        fileLock.releaseLock();
                    }
                    catch (IOException iOException) {
                        if (fileLock.isValid()) {
                            fileLock.releaseLock();
                        }
                        throw iOException;
                    }
                }
            };
        }
        catch (IOException iOException) {
            if (fileLock.isValid()) {
                fileLock.releaseLock();
            }
            throw iOException;
        }
    }

    public abstract FileLock lock() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        FileLock fileLock = null;
        try {
            fileLock = this.lock();
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileLock == null;
    }

    @Deprecated
    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration<? extends FileObject> getChildren(final boolean bl) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WithChildren
        implements Enumerations.Processor<FileObject, FileObject> {
            WithChildren() {
            }

            public FileObject process(FileObject fileObject, Collection<FileObject> collection) {
                if (bl && fileObject.isFolder()) {
                    collection.addAll(Arrays.asList(fileObject.getChildren()));
                }
                return fileObject;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new WithChildren());
    }

    public Enumeration<? extends FileObject> getFolders(boolean bl) {
        return Enumerations.filter(this.getChildren(bl), (Enumerations.Processor)new OnlyFolders(true));
    }

    public Enumeration<? extends FileObject> getData(boolean bl) {
        return Enumerations.filter(this.getChildren(bl), (Enumerations.Processor)new OnlyFolders(false));
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public FileObject getFileObject(String string) {
        String string2;
        FileObject fileObject;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (fileObject = this; fileObject != null && stringTokenizer.hasMoreTokens(); fileObject = fileObject.getFileObject(string2, null)) {
            string2 = stringTokenizer.nextToken();
        }
        return fileObject;
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String string) throws IOException {
        return this.createData(string, "");
    }

    @Deprecated
    public abstract boolean isReadOnly();

    public boolean canWrite() {
        File file = FileUtil.toFile(this);
        if (file != null) {
            return file.canWrite();
        }
        return !this.isReadOnly();
    }

    public boolean canRead() {
        File file = FileUtil.toFile(this);
        if (file != null) {
            return file.canRead();
        }
        return true;
    }

    public void refresh(boolean bl) {
    }

    public void refresh() {
        this.refresh(false);
    }

    public final URL getURL() throws FileStateInvalidException {
        return URLMapper.findURL(this, 0);
    }

    public boolean isVirtual() {
        return false;
    }

    static boolean isPriorityListener(FileChangeListener fileChangeListener) {
        return fileChangeListener instanceof PriorityFileChangeListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ED
    extends FileSystem.EventDispatcher {
        private FCLSupport.Op op;
        private Enumeration<FileChangeListener> en;
        private final List<FileChangeListener> fsList;
        private final List<FileChangeListener> repList;
        private FileEvent fe;

        public ED(FCLSupport.Op op, Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.op = op;
            this.en = enumeration;
            this.fe = fileEvent;
            FileSystem fileSystem = null;
            try {
                fileSystem = this.fe.getFile().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ExternalUtil.exception(fileStateInvalidException);
            }
            ListenerList<FileChangeListener> listenerList = fileSystem != null ? fileSystem.getFCLSupport().listeners : null;
            ListenerList<FileChangeListener> listenerList2 = fileSystem != null && fileSystem.getRepository() != null ? fileSystem.getRepository().getFCLSupport().listeners : null;
            this.fsList = listenerList != null ? new ArrayList<FileChangeListener>(listenerList.getAllListeners()) : new ArrayList();
            this.repList = listenerList2 != null ? new ArrayList<FileChangeListener>(listenerList2.getAllListeners()) : new ArrayList();
        }

        public ED(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this(null, enumeration, fileEvent);
        }

        @Override
        protected void dispatch(boolean bl) {
            Object object;
            if (this.op == null) {
                this.op = this.fe.getFile().isFolder() ? FCLSupport.Op.FOLDER_CREATED : FCLSupport.Op.DATA_CREATED;
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (this.en.hasMoreElements()) {
                object = this.en.nextElement();
                if (bl && !FileObject.isPriorityListener((FileChangeListener)object)) {
                    linkedList.add(object);
                    continue;
                }
                FCLSupport.dispatchEvent((FileChangeListener)object, this.fe, this.op);
            }
            if (bl) {
                this.en = Collections.enumeration(linkedList);
            }
            object = this.fe.getFile();
            boolean bl2 = false;
            if (object != null) {
                switch (this.op) {
                    case FILE_CHANGED: {
                        bl2 = object.equals(this.fe.getSource());
                        break;
                    }
                    default: {
                        boolean bl3 = bl2 = !object.equals(this.fe.getSource());
                        if (bl2 || !(this.fe instanceof Enumeration) || ((Enumeration)((Object)this.fe)).hasMoreElements()) break;
                        bl2 = true;
                    }
                }
            }
            if (!this.en.hasMoreElements() && bl2 && !bl) {
                FileSystem fileSystem = null;
                Repository repository = null;
                try {
                    fileSystem = this.fe.getFile().getFileSystem();
                    repository = fileSystem.getRepository();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                if (fileSystem != null && this.fsList != null) {
                    for (FileChangeListener fileChangeListener : this.fsList) {
                        fileSystem.getFCLSupport();
                        FCLSupport.dispatchEvent(fileChangeListener, this.fe, this.op);
                    }
                }
                if (repository != null && this.repList != null) {
                    for (FileChangeListener fileChangeListener : this.repList) {
                        repository.getFCLSupport();
                        FCLSupport.dispatchEvent(fileChangeListener, this.fe, this.op);
                    }
                }
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
            this.fe.setAtomicActionLink(atomicActionLink);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OnlyFolders
    implements Enumerations.Processor<FileObject, FileObject> {
        private boolean folders;

        public OnlyFolders(boolean bl) {
            this.folders = bl;
        }

        public FileObject process(FileObject fileObject, Collection<FileObject> collection) {
            FileObject fileObject2 = fileObject;
            if (this.folders) {
                return fileObject2.isFolder() ? fileObject2 : null;
            }
            return fileObject2.isData() ? fileObject2 : null;
        }
    }

    static interface PriorityFileChangeListener
    extends FileChangeListener {
    }
}

