/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.LockForFile;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.Attributes;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public abstract class BaseFileObj
extends FileObject {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNC_PREFIX = '\\';
    private static final String PATH_SEPARATOR = File.separator;
    private static final char EXT_SEP = '.';
    private FileChangeListener versioningWeakListener;
    private final FileChangeListener versioningListener = new FileChangeListenerForVersioning();
    static final long serialVersionUID = -1244650210876356809L;
    static final Attributes attribs;
    private EventListenerList eventSupport;
    private final FileNaming fileName;

    protected BaseFileObj(File file) {
        this(file, NamingFactory.fromFile(file));
    }

    protected BaseFileObj(File file, FileNaming fileNaming) {
        this.fileName = fileNaming;
        this.versioningWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, FileChangeListener.class, (EventListener)this.versioningListener, (Object)((Object)this));
        this.addFileChangeListener(this.versioningWeakListener);
    }

    public final String toString() {
        return this.getFileName().toString();
    }

    public final String getNameExt() {
        File file = this.getFileName().getFile();
        String string = BaseFileObj.getNameExt(file);
        return string;
    }

    static String getNameExt(File file) {
        String string;
        String string2 = string = file.getParentFile() == null ? file.getAbsolutePath() : file.getName();
        if (string.endsWith(PATH_SEPARATOR)) {
            boolean bl;
            boolean bl2 = bl = file.getParentFile() != null || !new FileInfo(file).isUNCFolder();
            if (bl) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean canRead() {
        File file = this.getFileName().getFile();
        return file.canRead();
    }

    public boolean canWrite() {
        File file = this.getFileName().getFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        return providedExtensions.canWrite(file);
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public final String getName() {
        return FileInfo.getName(this.getNameExt());
    }

    public final String getExt() {
        return FileInfo.getExt(this.getNameExt());
    }

    public final String getPath() {
        String string = "";
        if (Utilities.isWindows()) {
            string = this.getFactory().getRoot().getFileName().getFile().getPath().replace(File.separatorChar, '/');
        }
        return string + BaseFileObj.getRelativePath(this.getFactory().getRoot().getFileName().getFile(), this.getFileName().getFile());
    }

    private static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        assert (file3 != null) : file2.getAbsolutePath() + "not found in " + file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return FileBasedFileSystem.getInstance();
    }

    public final boolean isRoot() {
        return false;
    }

    public final FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        if (!this.checkLock(fileLock)) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath());
        }
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        FileObject fileObject2 = null;
        File file = fileObject instanceof FolderObj ? new File(((BaseFileObj)fileObject).getFileName().getFile(), FileInfo.composeName(string, string2)) : new File(FileUtil.toFile((FileObject)fileObject), FileInfo.composeName(string, string2));
        ProvidedExtensions.IOHandler iOHandler = providedExtensions.getMoveHandler(this.getFileName().getFile(), file);
        if (iOHandler != null) {
            if (fileObject instanceof FolderObj) {
                fileObject2 = this.move(fileLock, (FolderObj)fileObject, string, string2, iOHandler);
            } else {
                iOHandler.handle();
                this.refresh(true);
                fileObject.refresh(true);
                fileObject2 = fileObject.getFileObject(string, string2);
                assert (fileObject2 != null);
            }
        } else {
            fileObject2 = super.move(fileLock, fileObject, string, string2);
        }
        FileUtil.copyAttributes((FileObject)this, (FileObject)fileObject2);
        return fileObject2;
    }

    public BaseFileObj move(FileLock fileLock, FolderObj folderObj, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        iOHandler.handle();
        String string3 = FileInfo.composeName(string, string2);
        folderObj.getChildrenCache().getChild(string3, true);
        BaseFileObj baseFileObj = (BaseFileObj)FileBasedFileSystem.getFileObject(new File(folderObj.getFileName().getFile(), string3));
        assert (baseFileObj != null);
        baseFileObj.fireFileDataCreatedEvent(false);
        FolderObj folderObj2 = this.getExistingParent();
        if (folderObj2 != null) {
            folderObj2.refresh(true);
        } else {
            this.refresh(true);
        }
        return baseFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rename(FileLock fileLock, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        Object object;
        boolean bl;
        Object object2;
        if (!this.checkLock(fileLock)) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath());
        }
        File file = this.getFileName().getFile();
        File file2 = file.getParentFile();
        File file3 = BaseFileObj.getFile(file2, string, string2);
        if (file2 == null || !FileChangedManager.getInstance().exists(file2)) {
            FolderObj folderObj = this.getExistingParent();
            object2 = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), object2, file3.getName());
        }
        boolean bl2 = bl = FileChangedManager.getInstance().exists(file3) && !file3.equals(file);
        if (bl && Utilities.isMac()) {
            object2 = file3.getParentFile();
            object = file.getParentFile();
            if (object2 != null && object != null && ((File)object).equals(object2) && file3.getName().equalsIgnoreCase(file.getName())) {
                bl = false;
            }
        }
        if (bl) {
            object2 = this.getExistingParent();
            object = object2 != null ? object2.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), object, file3.getName());
        }
        object2 = this.getName();
        object = this.getExt();
        FileObjectFactory fileObjectFactory = this.getFactory();
        Map map = FileObjectFactory.AllFactories;
        synchronized (map) {
            String string3;
            FileNaming[] fileNamingArray = NamingFactory.rename(this.getFileName(), file3.getName(), iOHandler);
            if (fileNamingArray == null) {
                FolderObj folderObj = this.getExistingParent();
                string3 = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotRename", file.getName(), string3, file3.getName());
            }
            fileObjectFactory.rename();
            attribs.renameAttributes(file.getAbsolutePath().replace('\\', '/'), file3.getAbsolutePath().replace('\\', '/'));
            for (int i = 0; i < fileNamingArray.length; ++i) {
                Mutex.Privileged privileged;
                Object object3 = string3 = fileNamingArray[i].getParent() != null ? (FolderObj)fileObjectFactory.getCachedOnly(fileNamingArray[i].getParent().getFile()) : null;
                if (string3 == null) continue;
                ChildrenCache childrenCache = ((FolderObj)((Object)string3)).getChildrenCache();
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    childrenCache.removeChild(fileNamingArray[i]);
                    childrenCache.getChild(fileNamingArray[i].getName(), true);
                    continue;
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
        }
        LockForFile.relock(file, file3);
        this.fireFileRenamedEvent((String)object2, (String)object);
    }

    public final void rename(final FileLock fileLock, final String string, final String string2) throws IOException {
        FileBasedFileSystem.FSCallable<Boolean> fSCallable = new FileBasedFileSystem.FSCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                ProvidedExtensions providedExtensions = BaseFileObj.this.getProvidedExtensions();
                BaseFileObj.this.rename(fileLock, string, string2, providedExtensions.getRenameHandler(BaseFileObj.this.getFileName().getFile(), FileInfo.composeName(string, string2)));
                return true;
            }
        };
        FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    public Object getAttribute(String string) {
        if (string.equals("FileSystem.rootPath")) {
            return "";
        }
        if (string.equals("java.io.File")) {
            File file = this.getFileName().getFile();
            if (file != null && FileChangedManager.getInstance().exists(file)) {
                return file;
            }
        } else if (string.equals("ExistsParentNoPublicAPI")) {
            return this.getExistingParent() != null;
        }
        return attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
    }

    public final void setAttribute(String string, Object object) throws IOException {
        Object object2 = attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
        attribs.writeAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string, object);
        this.fireFileAttributeChangedEvent(string, object2, object);
    }

    public final Enumeration getAttributes() {
        return attribs.attributes(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'));
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().add(FileChangeListener.class, fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().remove(FileChangeListener.class, fileChangeListener);
    }

    private Enumeration getListeners() {
        if (this.eventSupport == null) {
            return Enumerations.empty();
        }
        return Enumerations.array((Object[])this.getEventSupport().getListeners(FileChangeListener.class));
    }

    public final long getSize() {
        return this.getFileName().getFile().length();
    }

    public final void setImportant(boolean bl) {
    }

    public boolean isReadOnly() {
        File file = this.getFileName().getFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        return !providedExtensions.canWrite(file) && FileChangedManager.getInstance().exists(file);
    }

    public final FileObject getParent() {
        Object object = null;
        if (!this.isRoot()) {
            FileNaming fileNaming = this.getFileName().getParent();
            if (Utilities.isWindows()) {
                File file;
                FileObjectFactory fileObjectFactory;
                object = fileNaming == null ? FileBasedFileSystem.getInstance().getRoot() : ((object = (fileObjectFactory = this.getFactory()).getCachedOnly(file = fileNaming.getFile())) == null ? fileObjectFactory.getFileObject(new FileInfo(file), FileObjectFactory.Caller.GetParent) : object);
            } else if (fileNaming != null) {
                FileObjectFactory fileObjectFactory = this.getFactory();
                File file = fileNaming.getFile();
                object = file.getParentFile() == null ? FileBasedFileSystem.getInstance().getRoot() : ((object = fileObjectFactory.getCachedOnly(file)) == null ? fileObjectFactory.getFileObject(new FileInfo(file), FileObjectFactory.Caller.GetParent) : object);
            }
        }
        return object;
    }

    static File getFile(File file, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append('.');
            stringBuffer.append(string2);
        }
        File file2 = new File(file, stringBuffer.toString());
        return file2;
    }

    public final FileObjectFactory getFactory() {
        return FileObjectFactory.getInstance(this.getFileName().getFile());
    }

    final void fireFileDataCreatedEvent(boolean bl) {
        Enumeration enumeration;
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration2 = enumeration = folderObj != null ? super.getListeners() : null;
        assert (this.isValid()) : this.toString();
        FileEventImpl fileEventImpl = null;
        if (folderObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(folderObj, this, bl);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileDataCreatedEvent(this.getListeners(), fileEventImpl2);
            folderObj.fireFileDataCreatedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl);
            this.fireFileDataCreatedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
    }

    final void fireFileFolderCreatedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (folderObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(folderObj, this, bl);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileFolderCreatedEvent(this.getListeners(), fileEventImpl2);
            folderObj.fireFileFolderCreatedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl);
            this.fireFileFolderCreatedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
    }

    public final void fireFileChangedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        BaseFileObj baseFileObj = folderObj instanceof BaseFileObj ? folderObj : null;
        Enumeration enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (baseFileObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(baseFileObj, this, bl);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileChangedEvent(this.getListeners(), fileEventImpl2);
            baseFileObj.fireFileChangedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl);
            this.fireFileChangedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
    }

    final void fireFileDeletedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        BaseFileObj baseFileObj = folderObj instanceof BaseFileObj ? folderObj : null;
        Enumeration enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        FileEventImpl fileEventImpl = null;
        if (baseFileObj != null && enumeration != null) {
            fileEventImpl = new FileEventImpl(baseFileObj, this, bl);
        }
        if (fileEventImpl != null) {
            FileEventImpl fileEventImpl2 = new FileEventImpl(this, fileEventImpl);
            this.fireFileDeletedEvent(this.getListeners(), fileEventImpl2);
            baseFileObj.fireFileDeletedEvent(enumeration, fileEventImpl);
        } else {
            FileEventImpl fileEventImpl3 = new FileEventImpl(this, this, bl);
            this.fireFileDeletedEvent(this.getListeners(), fileEventImpl3);
        }
        stopWatch.stop();
    }

    private void fireFileRenamedEvent(String string, String string2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this, string, string2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileRenamedEvent(enumeration, new FileRenameEvent((FileObject)folderObj, (FileObject)this, string, string2));
        }
        stopWatch.stop();
    }

    private void fireFileAttributeChangedEvent(String string, Object object, Object object2) {
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, string, object, object2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileAttributeChangedEvent(enumeration, new FileAttributeEvent((FileObject)folderObj, (FileObject)this, string, object, object2));
        }
    }

    public final FileNaming getFileName() {
        return this.fileName;
    }

    public final void delete(final FileLock fileLock) throws IOException {
        FileBasedFileSystem.FSCallable<Boolean> fSCallable = new FileBasedFileSystem.FSCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                ProvidedExtensions providedExtensions = BaseFileObj.this.getProvidedExtensions();
                providedExtensions.beforeDelete(BaseFileObj.this);
                try {
                    BaseFileObj.this.delete(fileLock, providedExtensions.getDeleteHandler(BaseFileObj.this.getFileName().getFile()));
                }
                catch (IOException iOException) {
                    BaseFileObj.this.getProvidedExtensions().deleteFailure(BaseFileObj.this);
                    throw iOException;
                }
                return true;
            }
        };
        FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock fileLock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Mutex.Privileged privileged;
        File file = this.getFileName().getFile();
        FolderObj folderObj = this.getExistingParent();
        ChildrenCache childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
        Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
        if (privileged != null) {
            privileged.enterWriteAccess();
        }
        try {
            boolean bl;
            if (!this.checkLock(fileLock)) {
                FSException.io("EXC_InvalidLock", fileLock, this.getPath());
            }
            boolean bl2 = bl = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
            if (!bl) {
                FolderObj folderObj2 = this.getExistingParent();
                String string = folderObj2 != null ? folderObj2.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotDelete", file.getName(), string);
            }
            attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
            if (childrenCache != null) {
                if (deleteHandler != null) {
                    childrenCache.removeChild(this.getFileName());
                } else {
                    childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                }
            }
        }
        finally {
            if (privileged != null) {
                privileged.exitWriteAccess();
            }
            this.setValid(false);
        }
        this.fireFileDeletedEvent(false);
    }

    abstract boolean checkLock(FileLock var1) throws IOException;

    public Object writeReplace() {
        return new ReplaceForSerialization(this.getFileName().getFile());
    }

    protected abstract void setValid(boolean var1);

    abstract void refreshImpl(boolean var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(boolean bl, boolean bl2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FILE);
        stopWatch.start();
        try {
            if (this.isValid()) {
                this.refreshImpl(bl, bl2);
                if (this.isData()) {
                    this.refreshExistingParent(bl, bl2);
                }
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshExistingParent(boolean bl, boolean bl2) {
        boolean bl3 = FileChangedManager.getInstance().exists(this.getFileName().getFile());
        if (!bl3) {
            FolderObj folderObj = this.getExistingParent();
            if (folderObj != null) {
                Mutex.Privileged privileged;
                ChildrenCache childrenCache = folderObj.getChildrenCache();
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    childrenCache.getChild(this.getFileName().getFile().getName(), true);
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
            this.setValid(false);
            if (bl2) {
                this.fireFileDeletedEvent(bl);
            }
        }
    }

    private synchronized EventListenerList getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new EventListenerList();
        }
        return this.eventSupport;
    }

    final ProvidedExtensions getProvidedExtensions() {
        FileBasedFileSystem.StatusImpl statusImpl = (FileBasedFileSystem.StatusImpl)FileBasedFileSystem.getInstance().getStatus();
        ProvidedExtensions providedExtensions = statusImpl.getExtensions();
        return providedExtensions;
    }

    public static FolderObj getExistingFor(File file, FileObjectFactory fileObjectFactory) {
        BaseFileObj baseFileObj = fileObjectFactory.getCachedOnly(file);
        return (FolderObj)(baseFileObj instanceof FolderObj ? baseFileObj : null);
    }

    public static FolderObj getExistingParentFor(File file, FileObjectFactory fileObjectFactory) {
        File file2 = file.getParentFile();
        return file2 == null ? null : BaseFileObj.getExistingFor(file2, fileObjectFactory);
    }

    FolderObj getExistingParent() {
        return BaseFileObj.getExistingParentFor(this.getFileName().getFile(), this.getFactory());
    }

    static {
        BridgeForAttributes bridgeForAttributes = new BridgeForAttributes();
        attribs = new Attributes(bridgeForAttributes, bridgeForAttributes, bridgeForAttributes);
    }

    private static final class BridgeForAttributes
    implements AbstractFileSystem.List,
    AbstractFileSystem.Change,
    AbstractFileSystem.Info {
        private BridgeForAttributes() {
        }

        public final Date lastModified(String string) {
            File file = new File(string);
            return new Date(file.lastModified());
        }

        public final boolean folder(String string) {
            File file = new File(string);
            return file.isDirectory();
        }

        public final boolean readOnly(String string) {
            File file = new File(string);
            return !file.canWrite();
        }

        public final String mimeType(String string) {
            return "content/unknown";
        }

        public final long size(String string) {
            File file = new File(string);
            return file.length();
        }

        public final InputStream inputStream(String string) throws FileNotFoundException {
            File file = new File(string);
            return new FileInputStream(file);
        }

        public final OutputStream outputStream(String string) throws IOException {
            File file = new File(string);
            return new FileOutputStream(file);
        }

        public final void lock(String string) throws IOException {
        }

        public final void unlock(String string) {
        }

        public final void markUnimportant(String string) {
        }

        public final String[] children(String string) {
            File file = new File(string);
            return file.list();
        }

        public final void createFolder(String string) throws IOException {
            File file = new File(string);
            if (!file.mkdirs()) {
                IOException iOException = new IOException(string);
                throw iOException;
            }
        }

        public final void createData(String string) throws IOException {
            File file = new File(string);
            if (!file.createNewFile()) {
                throw new IOException(string);
            }
        }

        public final void rename(String string, String string2) throws IOException {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.renameTo(file2)) {
                FSException.io("EXC_CannotRename", file.getName(), "", file2.getName());
            }
        }

        public final void delete(String string) throws IOException {
            boolean bl;
            File file = new File(string);
            boolean bl2 = bl = file.isFile() ? file.delete() : this.deleteFolder(file);
            if (bl) {
                FSException.io("EXC_CannotDelete", file.getName(), "");
            }
        }

        private boolean deleteFolder(File file) throws IOException {
            boolean bl = file.delete();
            if (bl) {
                return true;
            }
            if (!FileChangedManager.getInstance().exists(file)) {
                return false;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (this.deleteFolder(file2)) continue;
                    return false;
                }
            }
            return file.delete();
        }
    }

    private final class FileChangeListenerForVersioning
    extends FileChangeAdapter {
        private FileChangeListenerForVersioning() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (fileEvent.getFile() == BaseFileObj.this) {
                BaseFileObj.this.getProvidedExtensions().createSuccess(fileEvent.getFile());
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (fileEvent.getFile() == BaseFileObj.this) {
                BaseFileObj.this.getProvidedExtensions().createSuccess(fileEvent.getFile());
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile() == BaseFileObj.this) {
                BaseFileObj.this.getProvidedExtensions().deleteSuccess(fileEvent.getFile());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileEventImpl
    extends FileEvent
    implements Enumeration<FileEvent> {
        private FileEventImpl next;

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public FileEvent nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public FileEventImpl(FileObject fileObject, FileObject fileObject2, boolean bl) {
            super(fileObject, fileObject2, bl);
        }

        public FileEventImpl(FileObject fileObject, FileEventImpl fileEventImpl) {
            super(fileObject, fileEventImpl.getFile(), fileEventImpl.isExpected());
            this.next = fileEventImpl;
        }
    }
}

