'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.10/tcllib-1.10/modules/crc/crc16.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Pat Thoyts
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "crc16" n 1.1.1 crc "Cyclic Redundancy Checks"
.BS
.SH NAME
crc16 \- Perform a 16bit Cyclic Redundancy Check
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBcrc16  ?1.1.1?\fR
.sp
\fB::crc::crc16\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR
.sp
\fB::crc::crc16\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR
.sp
\fB::crc::crc-ccitt\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR
.sp
\fB::crc::crc-ccitt\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a Tcl-only implementation of the CRC
algorithms based upon information provided at
http://www.microconsultants.com/tips/crc/crc.txt
There are a number of permutations available for calculating CRC
checksums and this package can handle all of them. Defaults are set up
for the most common cases.
.SH COMMANDS
.TP
\fB::crc::crc16\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR
.TP
\fB::crc::crc16\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR
.TP
\fB::crc::crc-ccitt\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR
.TP
\fB::crc::crc-ccitt\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR
The command takes string data or a file name and returns a checksum
value calculated using the CRC algorithm. The command used sets up the
CRC polynomial, initial value and bit ordering for the desired
standard checksum calculation. The result is formatted
using the \fIformat\fR(n) specifier provided or as an unsigned integer
(%u) by default.
.PP
.SH OPTIONS
.TP
-filename \fIname\fR
Return a checksum for the file contents instead of for parameter data.
.TP
-format \fIstring\fR
Return the checksum using an alternative format template.
.TP
-seed \fIvalue\fR
Select an alternative seed value for the CRC calculation. The default
is 0 for the CRC16 calculation and 0xFFFF for the CCITT version.
This can be useful for calculating the CRC for data
structures without first converting the whole structure into a
string. The CRC of the previous member can be used as the seed for
calculating the CRC of the next member. It is also used for
accumulating a checksum from fragments of a large message (or file)
.TP
-implementation \fIprocname\fR
This hook is provided to allow users to provide their own
implementation (perhaps a C compiled extension). The
procedure specfied is called with two parameters. The first is the
data to be checksummed and the second is the seed value. An
integer is expected as the result.
.PP
.SH EXAMPLES
.PP
.nf

% crc::crc16 "Hello, World!"
64077

.fi
.PP
.nf

% crc::crc-ccitt "Hello, World!"
26586

.fi
.PP
.nf

% crc::crc16 -format 0x%X "Hello, World!"
0xFA4D

.fi
.PP
.nf

% crc::crc16 -file crc16.tcl
51675

.fi
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIcrc\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
cksum(n), crc32(n), sum(n)
.SH KEYWORDS
checksum, cksum, crc, crc16, crc32, cyclic redundancy check, data integrity, security
.SH COPYRIGHT
.nf
Copyright (c) 2002, Pat Thoyts

.fi