'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.10/tcllib-1.10/modules/crc/cksum.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Pat Thoyts
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "cksum" n 1.1.1 crc "Cyclic Redundancy Checks"
.BS
.SH NAME
cksum \- Calculate a cksum(1) compatible checksum
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBcksum  ?1.1.1?\fR
.sp
\fB::crc::cksum\fR ?\fI-format format\fR? ?\fI-chunksize size\fR? [ \fI-channel chan\fR | \fI-filename file\fR | \fIstring\fR ]
.sp
\fB::crc::CksumInit\fR
.sp
\fB::crc::CksumUpdate\fR \fItoken\fR \fIdata\fR
.sp
\fB::crc::CksumFinal\fR \fItoken\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a Tcl implementation of the cksum(1) algorithm
based upon information provided at in the GNU implementation of this
program as part of the GNU Textutils 2.0 package.
.SH COMMANDS
.TP
\fB::crc::cksum\fR ?\fI-format format\fR? ?\fI-chunksize size\fR? [ \fI-channel chan\fR | \fI-filename file\fR | \fIstring\fR ]
The command takes string data or a channel or file name and returns a
checksum value calculated using the \fBcksum(1)\fR algorithm. The
result is formatted using the \fIformat\fR(n) specifier provided or as
an unsigned integer (%u) by default.
.PP
.SH OPTIONS
.TP
-channel \fIname\fR
Return a checksum for the data read from a channel. The command will
read data from the channel until the \fBeof\fR is true. If you need
to be able to process events during this calculation see the
\fBPROGRAMMING INTERFACE\fR section
.TP
-filename \fIname\fR
This is a convenience option that opens the specified file, sets the
encoding to binary and then acts as if the \fI-channel\fR option had
been used. The file is closed on completion.
.TP
-format \fIstring\fR
Return the checksum using an alternative format template.
.PP
.SH "PROGRAMMING INTERFACE"
The cksum package implements the checksum using a context variable to
which additional data can be added at any time. This is expecially
useful in an event based environment such as a Tk application or a web
server package. Data to be checksummed may be handled incrementally
during a \fBfileevent\fR handler in discrete chunks. This can improve
the interactive nature of a GUI application and can help to avoid
excessive memory consumption.
.TP
\fB::crc::CksumInit\fR
Begins a new cksum context. Returns a token ID that must be used for the
remaining functions. An optional seed may be specified if required.
.TP
\fB::crc::CksumUpdate\fR \fItoken\fR \fIdata\fR
Add data to the checksum identified by token. Calling
\fICksumUpdate $token "abcd"\fR is equivalent to calling
\fICksumUpdate $token "ab"\fR followed by
\fICksumUpdate $token "cb"\fR. See \fBEXAMPLES\fR.
.TP
\fB::crc::CksumFinal\fR \fItoken\fR
Returns the checksum value and releases any resources held by this
token. Once this command completes the token will be invalid. The
result is a 32 bit integer value.
.PP
.SH EXAMPLES
.PP
.nf

% crc::cksum "Hello, World!"
2609532967

.fi
.PP
.nf

% crc::cksum -format 0x%X "Hello, World!"
0x9B8A5027

.fi
.PP
.nf

% crc::cksum -file cksum.tcl
1828321145

.fi
.PP
.nf

% set tok [crc::CksumInit]
% crc::CksumUpdate $tok "Hello, "
% crc::CksumUpdate $tok "World!"
% crc::CksumFinal $tok
2609532967

.fi
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIcrc\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
crc32(n), sum(n)
.SH KEYWORDS
checksum, cksum, crc, crc32, cyclic redundancy check, data integrity, security
.SH COPYRIGHT
.nf
Copyright (c) 2002, Pat Thoyts

.fi