/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakEventListenerList;

public class Settings {
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static InitializerSorter currentInitializerSorter;
    private static final ArrayList filterList;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static final Map NULL_MAP;
    private static boolean firingEnabled;
    private static HashMap emptyMap;

    private Settings() {
    }

    public static synchronized void addInitializer(Initializer i) {
        Settings.addInitializer(i, 1);
        Settings.reset();
    }

    public static synchronized void addInitializer(Initializer i, int level) {
        int size;
        for (int j = size = initializerLists.size(); j <= level; ++j) {
            initializerLists.add(new ArrayList());
        }
        ((List)initializerLists.get(level)).add(i);
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized void removeInitializer(String name) {
        Iterator itit = initializerLists.iterator();
        while (itit.hasNext()) {
            Iterator it = ((List)itit.next()).iterator();
            while (it.hasNext()) {
                if (!name.equals(((Initializer)it.next()).getName())) continue;
                it.remove();
            }
        }
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized InitializerSorter getInitializerSorter() {
        return currentInitializerSorter;
    }

    public static synchronized void setInitializerSorter(InitializerSorter initializerSorter) {
        currentInitializerSorter = initializerSorter;
    }

    public static synchronized void addFilter(Filter f) {
        filterList.add(f);
    }

    public static synchronized void removeFilter(Filter f) {
        Iterator it = filterList.iterator();
        while (it.hasNext()) {
            if (it.next() != f) continue;
            it.remove();
        }
    }

    public static Object getValue(Class kitClass, String settingName) {
        return Settings.getValue(kitClass, settingName, true);
    }

    public static synchronized Object getValue(Class kitClass, String settingName, boolean evaluateEvaluators) {
        Object value = null;
        Class kc = kitClass;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(kc, false)) != null) {
                value = map.get(settingName);
                if (evaluateEvaluators && value instanceof Evaluator) {
                    value = ((Evaluator)value).getValue(kitClass, settingName);
                }
                if (value != null) break;
            }
            if (kc == null) break;
            kc = kc.getSuperclass();
        }
        int cnt = filterList.size();
        for (int i = 0; i < cnt; ++i) {
            value = ((Filter)filterList.get(i)).filterValue(kitClass, settingName, value);
        }
        return value;
    }

    public static KitAndValue[] getValueHierarchy(Class kitClass, String settingName) {
        return Settings.getValueHierarchy(kitClass, settingName, true);
    }

    public static synchronized KitAndValue[] getValueHierarchy(Class kitClass, String settingName, boolean evaluateEvaluators) {
        ArrayList<KitAndValue> kavList = new ArrayList<KitAndValue>();
        Class kc = kitClass;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(kc, false)) != null) {
                Object value = map.get(settingName);
                if (evaluateEvaluators && value instanceof Evaluator) {
                    value = ((Evaluator)value).getValue(kitClass, settingName);
                }
                if (value != null) {
                    kavList.add(new KitAndValue(kc, value));
                }
            }
            if (kc == null) break;
            kc = kc.getSuperclass();
        }
        KitAndValue[] kavArray = kavList.toArray(new KitAndValue[kavList.size()]);
        int cnt = filterList.size();
        for (int i = 0; i < cnt; ++i) {
            kavArray = ((Filter)filterList.get(i)).filterValueHierarchy(kitClass, settingName, kavArray);
        }
        return kavArray;
    }

    public static synchronized void setValue(Class kitClass, String settingName, Object newValue) {
        Map map = Settings.getKitMap(kitClass, true);
        Object oldValue = map.get(settingName);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null) {
            map.put(settingName, newValue);
        } else {
            map.remove(settingName);
        }
        Settings.fireSettingsChange(kitClass, settingName, oldValue, newValue);
    }

    public static synchronized void touchValue(Class kitClass, String settingName) {
        Settings.fireSettingsChange(kitClass, settingName, null, null);
    }

    public static synchronized void propagateValue(Class kitClass, String settingName, Object newValue) {
        Map map = Settings.getKitMap(kitClass, true);
        if (newValue != null) {
            map.put(settingName, newValue);
        } else {
            map.remove(settingName);
        }
        Iterator it = kit2Maps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Class kc = (Class)me.getKey();
            if (kitClass == kc || kitClass != null && !kitClass.isAssignableFrom(kc)) continue;
            ((Map)me.getValue()).remove(settingName);
        }
        Settings.fireSettingsChange(null, settingName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(Runnable r) {
        boolean turnedOff = firingEnabled;
        firingEnabled = false;
        try {
            r.run();
        }
        finally {
            if (turnedOff) {
                firingEnabled = true;
                Settings.fireSettingsChange(null, null, null, null);
            }
        }
    }

    public static synchronized void reset() {
        kit2Maps.clear();
        Settings.fireSettingsChange(null, null, null, null);
    }

    public static synchronized String initializersToString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < initializerLists.size(); ++i) {
            switch (i) {
                case 0: {
                    sb.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    sb.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    sb.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    sb.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    sb.append("USER_LEVEL");
                    break;
                }
                default: {
                    sb.append("level " + i);
                }
            }
            sb.append(":\n");
            sb.append(EditorDebug.debugList((List)initializerLists.get(i)));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener l) {
        listenerList.add(SettingsChangeListener.class, l);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener l) {
        listenerList.remove(SettingsChangeListener.class, l);
    }

    private static void fireSettingsChange(Class kitClass, String settingName, Object oldValue, Object newValue) {
        if (firingEnabled) {
            SettingsChangeListener[] listeners = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent evt = new SettingsChangeEvent(Settings.class, kitClass, settingName, oldValue, newValue);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].settingsChange(evt);
            }
        }
    }

    private static Map getKitMap(Class kitClass, boolean forceCreation) {
        Map kitMap = (HashMap)kit2Maps.get(kitClass);
        if (kitMap == null) {
            if (emptyMap == null) {
                emptyMap = new HashMap();
            }
            Iterator itit = initializerLists.iterator();
            while (itit.hasNext()) {
                Iterator it = ((List)itit.next()).iterator();
                while (it.hasNext()) {
                    Initializer i = (Initializer)it.next();
                    try {
                        i.updateSettingsMap(kitClass, emptyMap);
                    }
                    catch (Throwable t) {
                        Utilities.annotateLoggable(t);
                    }
                }
            }
            if (emptyMap.size() > 0) {
                kitMap = emptyMap;
                emptyMap = null;
            }
            if (kitMap == null) {
                kitMap = NULL_MAP;
            }
            kit2Maps.put(kitClass, kitMap);
        }
        if (kitMap == NULL_MAP) {
            if (!forceCreation) {
                return null;
            }
            kitMap = new HashMap();
            kit2Maps.put(kitClass, kitMap);
        }
        return kitMap;
    }

    static {
        filterList = new ArrayList();
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        NULL_MAP = new HashMap(1);
        firingEnabled = true;
        emptyMap = null;
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter delegate) {
            this.delegate = delegate;
        }

        public void sort(List initializersList) {
            if (this.delegate != null) {
                this.delegate.sort(initializersList);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class kitClass, Object value) {
            this.kitClass = kitClass;
            this.value = value;
        }
    }
}

