/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.netbeans.lib.gjast.ASParser;
import org.netbeans.lib.gjast.test.DumpASTree;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.JParser;

public final class DumpXMLTree {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("java DumpXMLTree <file> [<file> ...]");
        }
        int i = 0;
        while (i < args.length) {
            DumpXMLTree.dump(args[i++]);
        }
    }

    private DumpXMLTree() {
    }

    public static void dump(String filename) {
        try {
            FileReader fileIn = new FileReader(filename);
            char[] src = DumpASTree.readInChars(fileIn);
            CharArrayReader in = new CharArrayReader(src);
            DumpASTree.MiniContext ctx = new DumpASTree.MiniContext(src, "1.5");
            ASParser parser = new ASParser(ctx, in, filename);
            ctx.setParser(parser);
            parser.parse(false);
            DumpXMLTree.dump(filename, parser);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void dump(String filename, ASParser newParser) {
        try {
            File dir = new File(DumpASTree.dumpDir);
            dir.mkdir();
            DumpXMLTree.dumpASTree(newParser, filename + ".xml");
        }
        catch (Exception e) {
            System.err.println("failed writing XML: ");
            e.printStackTrace();
        }
    }

    public static void dumpASTree(JParser jp, String filename) throws IOException {
        filename = new File(filename).getName();
        ASTree tree = jp.getASTree();
        File dir = new File(DumpASTree.dumpDir);
        File f = new File(dir, filename);
        FileOutputStream fos = new FileOutputStream(f);
        PrintStream out = new PrintStream(new BufferedOutputStream(fos, 4096));
        DumpXMLTree.printXMLHeader(out);
        DumpXMLTree.printASTree(tree, out, 0);
        out.flush();
        fos.close();
    }

    private static void printXMLHeader(PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE COMPILATION_UNIT SYSTEM \"astreesdtd.dtd\">");
    }

    private static void printASTree(ASTree tree, PrintStream out, int indent) {
        try {
            DumpXMLTree.printIndent(out, indent);
            if (tree == null) {
                out.println("<null/>");
            } else {
                String treeType = DumpXMLTree.asTreeType(tree);
                out.print("<" + treeType);
                ASTree[] subtrees = tree.getSubTrees();
                if (subtrees != null) {
                    out.println(">");
                    for (int i = 0; i < subtrees.length; ++i) {
                        ASTree ast = subtrees[i];
                        DumpXMLTree.printASTree(subtrees[i], out, indent + 1);
                    }
                    DumpXMLTree.printIndent(out, indent);
                    out.println("</" + treeType + ">");
                } else {
                    out.println("/>");
                }
            }
        }
        catch (Throwable t) {
            StackTraceElement[] stack;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            out.println("ASTree failure for " + DumpXMLTree.asTreeType(tree) + ": " + t);
            String msg = t.getMessage();
            if (msg != null) {
                DumpXMLTree.printIndent(out, indent);
                out.println(msg);
            }
            int max = (stack = t.getStackTrace()).length < 4 ? stack.length : 4;
            for (int i = 0; i < 4 && !stack[i].getMethodName().equals("printASTree"); ++i) {
                out.println(stack[i].toString());
            }
        }
    }

    private static void printIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
    }

    private static String asTreeType(ASTree tree) {
        if (tree.getType() == 44) {
            return "MODIFIERS";
        }
        return DumpASTree.asTreeType(tree, " value=\"", "\"");
    }
}

