/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeScanner
extends Tree.Visitor {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$tree$TreeScanner;

    public void scan(Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    public void scan(List<? extends Tree> trees) {
        if (trees != null) {
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                this.scan((Tree)l.head);
                l = l.tail;
            }
        }
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        this.scan(tree.pid);
        this.scan(tree.defs);
    }

    @Override
    public void visitImport(Tree.Import tree) {
        this.scan(tree.qualid);
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        this.scan(tree.mods);
        this.scan(tree.typarams);
        this.scan(tree.extending);
        this.scan(tree.implementing);
        this.scan(tree.defs);
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        this.scan(tree.mods);
        this.scan(tree.restype);
        this.scan(tree.typarams);
        this.scan(tree.params);
        this.scan(tree.thrown);
        this.scan(tree.body);
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        this.scan(tree.mods);
        this.scan(tree.vartype);
        this.scan(tree.init);
    }

    @Override
    public void visitSkip(Tree.Skip tree) {
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        this.scan(tree.stats);
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        this.scan(tree.body);
        this.scan(tree.cond);
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        this.scan(tree.cond);
        this.scan(tree.body);
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        this.scan(tree.init);
        this.scan(tree.cond);
        this.scan(tree.step);
        this.scan(tree.body);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        this.scan(tree.var);
        this.scan(tree.expr);
        this.scan(tree.body);
    }

    @Override
    public void visitLabelled(Tree.Labelled tree) {
        this.scan(tree.body);
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        this.scan(tree.selector);
        this.scan(tree.cases);
    }

    @Override
    public void visitCase(Tree.Case tree) {
        this.scan(tree.pat);
        this.scan(tree.stats);
    }

    @Override
    public void visitSynchronized(Tree.Synchronized tree) {
        this.scan(tree.lock);
        this.scan(tree.body);
    }

    @Override
    public void visitTry(Tree.Try tree) {
        this.scan(tree.body);
        this.scan(tree.catchers);
        this.scan(tree.finalizer);
    }

    @Override
    public void visitCatch(Tree.Catch tree) {
        this.scan(tree.param);
        this.scan(tree.body);
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        this.scan(tree.cond);
        this.scan(tree.truepart);
        this.scan(tree.falsepart);
    }

    @Override
    public void visitIf(Tree.If tree) {
        this.scan(tree.cond);
        this.scan(tree.thenpart);
        this.scan(tree.elsepart);
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitBreak(Tree.Break tree) {
    }

    @Override
    public void visitContinue(Tree.Continue tree) {
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        this.scan(tree.cond);
        this.scan(tree.detail);
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        this.scan(tree.meth);
        this.scan(tree.args);
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        this.scan(tree.encl);
        this.scan(tree.clazz);
        this.scan(tree.args);
        this.scan(tree.def);
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        this.scan(tree.elemtype);
        this.scan(tree.dims);
        this.scan(tree.elems);
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        this.scan(tree.arg);
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        this.scan(tree.clazz);
        this.scan(tree.expr);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        this.scan(tree.expr);
        this.scan(tree.clazz);
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        this.scan(tree.indexed);
        this.scan(tree.index);
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        this.scan(tree.selected);
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
    }

    @Override
    public void visitLiteral(Tree.Literal tree) {
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent tree) {
    }

    @Override
    public void visitTypeArray(Tree.TypeArray tree) {
        this.scan(tree.elemtype);
    }

    @Override
    public void visitTypeApply(Tree.TypeApply tree) {
        this.scan(tree.clazz);
        this.scan(tree.arguments);
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter tree) {
        this.scan(tree.bounds);
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument tree) {
        if (tree.inner != null) {
            this.scan(tree.inner);
        }
    }

    @Override
    public void visitModifiers(Tree.Modifiers tree) {
        this.scan(tree.annotations);
    }

    @Override
    public void visitAnnotation(Tree.Annotation tree) {
        this.scan(tree.annotationType);
        this.scan(tree.args);
    }

    @Override
    public void visitErroneous(Tree.Erroneous tree) {
    }

    @Override
    public void visitLetExpr(Tree.LetExpr tree) {
        this.scan(tree.defs);
        this.scan(tree.expr);
    }

    @Override
    public void visitTree(Tree tree) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$tree$TreeScanner == null ? (class$com$sun$tools$javac$tree$TreeScanner = TreeScanner.class$("com.sun.tools.javac.tree.TreeScanner")) : class$com$sun$tools$javac$tree$TreeScanner).desiredAssertionStatus();
    }
}

