/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private final SourceGroup g;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$spi$java$project$support$ui$TreeRootNode;

    public TreeRootNode(SourceGroup g) {
        this(DataFolder.findFolder((FileObject)g.getRootFolder()), g);
    }

    private TreeRootNode(DataFolder folder, SourceGroup g) {
        this((Node)new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER)), g);
    }

    private TreeRootNode(Node originalNode, SourceGroup g) {
        super(originalNode, (Children)new PackageFilterChildren(originalNode), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup(), Lookups.singleton((Object)new PathFinder(g))}));
        this.g = g;
        g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = this.g.getIcon(opened);
        if (icon == null) {
            Image image = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            return Utilities.mergeImages((Image)image, (Image)PackageRootNode.PACKAGE_BADGE, (int)7, (int)7);
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return PackageRootNode.icon2image(icon);
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private static final class PackageFilterNode
    extends FilterNode {
        public PackageFilterNode(Node origNode) {
            super(origNode, (Children)new PackageFilterChildren(origNode));
        }

        public void setName(String name) {
            if (Utilities.isJavaIdentifier((String)name)) {
                super.setName(name);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$TreeRootNode == null ? (class$org$netbeans$spi$java$project$support$ui$TreeRootNode = TreeRootNode.class$("org.netbeans.spi.java.project.support.ui.TreeRootNode")) : class$org$netbeans$spi$java$project$support$ui$TreeRootNode), (String)"MSG_InvalidPackageName"), 1));
            }
        }
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node originalNode) {
            super(originalNode);
        }

        protected Node copyNode(Node originalNode) {
            DataObject dobj = (DataObject)originalNode.getLookup().lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TreeRootNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return dobj instanceof DataFolder ? new PackageFilterNode(originalNode) : super.copyNode(originalNode);
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        private final EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? TreeRootNode.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TreeRootNode.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TreeRootNode.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup g) {
            this.g = g;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)fo);
                ArrayList<String> path = new ArrayList<String>();
                StringTokenizer strtok = new StringTokenizer(relPath, "/");
                while (strtok.hasMoreTokens()) {
                    path.add(strtok.nextToken());
                }
                path.set(path.size() - 1, fo.getName());
                try {
                    return NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                }
                catch (NodeNotFoundException e) {
                    try {
                        path.set(path.size() - 1, fo.getNameExt());
                        return NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                    }
                    catch (NodeNotFoundException e2) {
                        return null;
                    }
                }
            }
            if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }
    }
}

