/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.openide.util.Utilities;

public class TabbedPanel
extends JPanel {
    public static int EXPAND_ONE = 1;
    public static int EXPAND_SOME = 2;
    public static int EXPAND_ALL = 3;
    private static Color bColor = new Color(Math.max((int)((double)SystemColor.control.getRed() * 0.9), 0), Math.max((int)((double)SystemColor.control.getGreen() * 0.9), 0), Math.max((int)((double)SystemColor.control.getBlue() * 0.9), 0));
    private TabbedPanelModel model;
    private int selectedIndex = -1;
    private Set selectedIndexes = new HashSet();
    private int expansionPolicy;
    private boolean fill;
    private JComponent selectedComponent;
    private JComponent[] titles;
    private Vector listeners = new Vector();
    private Listener listener = new Listener();

    public TabbedPanel(TabbedPanelModel model, int expansionPolicy, boolean fill) {
        this.model = model;
        this.expansionPolicy = expansionPolicy;
        this.fill = fill;
        this.addKeyListener(this.listener);
        this.refreshPanels();
        this.setBorder(new LineBorder(new Color(127, 157, 185)));
    }

    public int getExpansionPolicy() {
        return this.expansionPolicy;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean isExpanded(int index) {
        if (index == this.selectedIndex) {
            return true;
        }
        return this.selectedIndexes.contains(new Integer(index));
    }

    public void setSelectedIndex(int index) {
        int ii;
        int n = ii = index >= 0 ? index : this.selectedIndex;
        if (this.expansionPolicy == EXPAND_ALL) {
            Integer i = new Integer(index);
            if (!this.selectedIndexes.remove(i)) {
                this.selectedIndexes.add(i);
            }
        } else {
            this.selectedIndex = index;
        }
        this.refreshPanels();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ii >= 0) {
                    TabbedPanel.this.titles[ii].requestFocus();
                }
            }
        });
    }

    public JComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public String getSelectedCategory() {
        int i = this.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (String)this.model.getCategories().get(i);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Vector l = (Vector)this.listeners.clone();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            ((ActionListener)it.next()).actionPerformed(event);
        }
    }

    public void refreshPanels() {
        this.removeAll();
        this.selectedComponent = null;
        if (this.expansionPolicy == EXPAND_ONE && this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        FormLayout layout = new FormLayout("p:g", "");
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        List categories = this.model.getCategories();
        int k = categories.size();
        int j = 1;
        this.titles = new JComponent[k];
        for (int i = 0; i < k; ++i) {
            JComponent l = this.createTitleComponent((String)categories.get(i), i);
            layout.appendRow(new RowSpec("p"));
            this.add((Component)l, cc.xy(1, j++, "l,c"));
            this.titles[i] = l;
            if ((this.expansionPolicy != EXPAND_ALL || !this.selectedIndexes.contains(new Integer(i))) && i != this.selectedIndex) continue;
            this.selectedComponent = this.model.getPanel((String)categories.get(i));
            layout.appendRow(new RowSpec(this.fill ? "f:p:g" : "f:p"));
            this.add((Component)this.selectedComponent, cc.xy(1, j++));
        }
        this.revalidate();
        this.repaint();
        this.fireActionPerformed(new ActionEvent(this, 0, "selectedIndex"));
    }

    protected JComponent createTitleComponent(String name, int index) {
        JLabel l = new JLabel(name, new ImageIcon(Utilities.loadImage((String)(index == this.selectedIndex ? "org/netbeans/modules/options/resources/expanded.gif" : "org/netbeans/modules/options/resources/collapsed.gif"))), 2);
        l.setFont(l.getFont().deriveFont(1));
        l.setBackground(bColor);
        l.setOpaque(true);
        l.putClientProperty("index", new Integer(index));
        l.addMouseListener(this.listener);
        l.setBorder(new EmptyBorder(1, 1, 1, 1));
        l.setCursor(Cursor.getPredefinedCursor(12));
        return l;
    }

    private class Listener
    implements ActionListener,
    KeyListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            int i = (Integer)b.getClientProperty("index");
            if (i == TabbedPanel.this.selectedIndex) {
                TabbedPanel.this.setSelectedIndex(-1);
            } else {
                TabbedPanel.this.setSelectedIndex(i);
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!(e.getSource() instanceof JLabel)) {
                return;
            }
            JLabel l = (JLabel)e.getSource();
            int i = (Integer)l.getClientProperty("index");
            if (i == TabbedPanel.this.selectedIndex) {
                if (TabbedPanel.this.expansionPolicy != EXPAND_ONE) {
                    TabbedPanel.this.setSelectedIndex(-1);
                }
            } else {
                TabbedPanel.this.setSelectedIndex(i);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (!(e.getSource() instanceof JLabel)) {
                return;
            }
            JLabel l = (JLabel)e.getSource();
            l.setBackground(SystemColor.control);
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            if (!(e.getSource() instanceof JLabel)) {
                return;
            }
            JLabel l = (JLabel)e.getSource();
            l.setBackground(bColor);
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
        }
    }
}

