/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.ui.LoweredBorder;
import org.netbeans.modules.options.ui.VariableBorder;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.ProxyLookup;

public class OptionsPanel
extends JPanel {
    private JPanel pCategories;
    private JPanel pOptions;
    private JLabel lTitle;
    private List optionCategories;
    private int currentCategory = -1;
    private Button[] buttons;
    private Map categoryToPanel = new HashMap();
    private Map categoryToController = new HashMap();
    private Set updatedCategories = new HashSet();
    private Color selected = new Color(193, 210, 238);
    private Color selectedB = new Color(149, 106, 197);
    private Color highlighted = new Color(224, 232, 246);
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener coltrollerListener = new ControllerListener();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private final Color selectedMac = new Color(221, 221, 221);
    private final Color selectedBMac = new Color(183, 183, 183);
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);

    private static String loc(String key) {
        return NbBundle.getMessage((Class)OptionsPanel.class, (String)key);
    }

    public OptionsPanel() {
        int i;
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("OptionsDialog");
        if (fo != null) {
            Lookup lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fo)).getLookup();
            this.optionCategories = new ArrayList(lookup.lookup(new Lookup.Template(OptionsCategory.class)).allInstances());
        }
        this.pOptions = new JPanel();
        this.pOptions.setLayout(new BorderLayout());
        int maxW = 0;
        int maxH = 0;
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        int k = this.optionCategories.size();
        for (i = 0; i < k; ++i) {
            OptionsCategory category = (OptionsCategory)this.optionCategories.get(i);
            OptionsPanelController controller = category.create();
            lookups.add(controller.getLookup());
            this.categoryToController.put(category, controller);
            controller.addPropertyChangeListener(this.coltrollerListener);
        }
        ProxyLookup masterLookup = new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
        k = this.optionCategories.size();
        for (i = 0; i < k; ++i) {
            OptionsCategory category = (OptionsCategory)this.optionCategories.get(i);
            OptionsPanelController controller = (OptionsPanelController)this.categoryToController.get(category);
            JComponent component = controller.getComponent((Lookup)masterLookup);
            this.categoryToPanel.put(category, component);
            maxW = Math.max(maxW, component.getPreferredSize().width);
            maxH = Math.max(maxH, component.getPreferredSize().height);
        }
        this.pOptions.setPreferredSize(new Dimension(maxW, maxH));
        JPanel pTitle = new JPanel(new BorderLayout());
        this.lTitle = new JLabel();
        if (Utilities.isWindows()) {
            this.lTitle.setBackground(SystemColor.activeCaption);
            this.lTitle.setForeground(SystemColor.activeCaptionText);
        } else {
            this.lTitle.setBackground(Color.white);
            this.lTitle.setForeground(Color.black);
        }
        Font f = this.lTitle.getFont();
        this.lTitle.setFont(new Font(f.getName(), 1, 16));
        this.lTitle.setIconTextGap(8);
        this.lTitle.setOpaque(true);
        if (Utilities.isWindows()) {
            pTitle.setBorder(new CompoundBorder(new LoweredBorder(), new LineBorder(SystemColor.activeCaption, 1)));
        } else {
            pTitle.setBorder(new CompoundBorder(new LineBorder(this.iconViewBorder, 1), new LineBorder(Color.white, 2)));
        }
        pTitle.add("Center", this.lTitle);
        this.pCategories = new JPanel(new BorderLayout());
        JPanel pCategories2 = new JPanel(new GridBagLayout());
        this.pCategories.add("North", pCategories2);
        if (this.isMac) {
            this.pCategories.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        } else {
            this.pCategories.setBorder(new LineBorder(this.iconViewBorder));
        }
        this.pCategories.setBackground(Color.white);
        pCategories2.setBackground(Color.white);
        pCategories2.setBorder(null);
        k = this.optionCategories.size();
        this.buttons = new Button[k];
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(this.isMac ? KeyStroke.getKeyStroke(37, 0) : KeyStroke.getKeyStroke(38, 0), "UP");
        this.getActionMap().put("UP", new UpAction());
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "SPACE");
        this.getActionMap().put("SPACE", new SelectCurrentAction());
        inputMap.put(this.isMac ? KeyStroke.getKeyStroke(39, 0) : KeyStroke.getKeyStroke(40, 0), "DOWN");
        this.getActionMap().put("DOWN", new DownAction());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        if (this.isMac) {
            gbc.fill = 3;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
        } else {
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
        }
        for (i = 0; i < k; ++i) {
            Button b;
            OptionsCategory category = (OptionsCategory)this.optionCategories.get(i);
            this.buttons[i] = b = new Button(category, i);
            int mnemonic = b.getDisplayedMnemonic();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(mnemonic, 8);
            inputMap.put(keyStroke, b);
            this.getActionMap().put(b, new SelectAction(i));
            if (this.isMac) {
                gbc.gridx = i;
                gbc.gridy = 0;
            } else {
                gbc.gridx = 0;
                gbc.gridy = i;
            }
            pCategories2.add((Component)b, gbc);
        }
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        if (this.isMac) {
            ++gbc.gridx;
            gbc.gridy = 0;
        } else {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        pCategories2.add((Component)new JLabel(""), gbc);
        FormLayout layout = this.isMac ? new FormLayout("p:g", "p, 5dlu, p:g") : new FormLayout("p, 5dlu, p:g", "p, 5dlu, p:g");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        if (this.isMac) {
            this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 20, 5, 20)));
        } else {
            builder.setDefaultDialogBorder();
        }
        CellConstraints cc = new CellConstraints();
        if (this.isMac) {
            builder.add((Component)this.pCategories, cc.xy(1, 1));
            builder.add((Component)this.pOptions, cc.xy(1, 3, "f,f"));
        } else {
            builder.add((Component)this.pCategories, cc.xywh(1, 1, 1, 3));
            builder.add((Component)pTitle, cc.xy(3, 1));
            builder.add((Component)this.pOptions, cc.xy(3, 3, "f,f"));
        }
        if (k < 1) {
            return;
        }
        OptionsCategory category = (OptionsCategory)this.optionCategories.get(0);
        OptionsPanelController controller = (OptionsPanelController)this.categoryToController.get(category);
        try {
            controller.update();
            this.updatedCategories.add(category);
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(t);
        }
        this.setCurrentIndex(0);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator it = OptionsPanel.this.optionCategories.iterator();
                it.next();
                int i = 1;
                while (it.hasNext()) {
                    try {
                        OptionsCategory category = (OptionsCategory)it.next();
                        ((OptionsPanelController)OptionsPanel.this.categoryToController.get(category)).update();
                        OptionsPanel.this.updatedCategories.add(category);
                        if (OptionsPanel.this.getCurrentIndex() == i) {
                            OptionsPanel.this.setCurrentIndex(i);
                        }
                        ++i;
                    }
                    catch (Throwable t) {
                        ErrorManager.getDefault().notify(t);
                    }
                }
            }
        });
    }

    int getCurrentIndex() {
        return this.currentCategory;
    }

    void setCurrentIndex(final int i) {
        if (this.currentCategory != -1) {
            this.buttons[this.currentCategory].setNormal();
        }
        if (i != -1) {
            this.buttons[i].setSelected();
        }
        this.currentCategory = i;
        OptionsCategory category = (OptionsCategory)this.optionCategories.get(i);
        this.pOptions.removeAll();
        if (this.updatedCategories.contains(category)) {
            JComponent component = (JComponent)this.categoryToPanel.get(category);
            this.pOptions.add("Center", component);
        } else {
            JLabel label = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
            label.setHorizontalAlignment(0);
            this.pOptions.add("Center", label);
        }
        Icon icon = category.getIcon();
        if (icon != null) {
            this.lTitle.setIcon(icon);
        }
        this.lTitle.setText(category.getTitle());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OptionsPanel.this.invalidate();
                OptionsPanel.this.validate();
                OptionsPanel.this.repaint();
                if (i != -1) {
                    OptionsPanel.this.buttons[i].requestFocus();
                }
            }
        });
        this.firePropertyChange("buranhelpCtx", null, null);
    }

    HelpCtx getHelpCtx() {
        OptionsCategory category = (OptionsCategory)this.optionCategories.get(this.getCurrentIndex());
        OptionsPanelController controller = (OptionsPanelController)this.categoryToController.get(category);
        return controller.getHelpCtx();
    }

    void update() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            try {
                ((OptionsPanelController)it.next()).update();
            }
            catch (Throwable t) {
                ErrorManager.getDefault().notify(t);
            }
        }
    }

    void save() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            ((OptionsPanelController)it.next()).applyChanges();
        }
    }

    void cancel() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            ((OptionsPanelController)it.next()).cancel();
        }
    }

    boolean dataValid() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (((OptionsPanelController)it.next()).isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!((OptionsPanelController)it.next()).isChanged()) continue;
            return true;
        }
        return false;
    }

    class Button
    extends JLabel
    implements MouseListener {
        private int index;

        Button(OptionsCategory category, int index) {
            super(category.getIcon());
            this.index = index;
            Mnemonics.setLocalizedText((JLabel)this, (String)category.getCategoryName());
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(true);
            this.setForeground(Color.black);
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            if (index == OptionsPanel.this.currentCategory) {
                this.setSelected();
            } else {
                this.setNormal();
            }
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (Button.this.index != OptionsPanel.this.currentCategory) {
                        Button.this.setHighlighted();
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (Button.this.index != OptionsPanel.this.currentCategory) {
                        Button.this.setNormal();
                    }
                }
            });
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(Color.white);
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedBMac, null, OptionsPanel.this.selectedBMac), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
                this.setBackground(OptionsPanel.this.selectedMac);
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.selected);
            }
        }

        void setHighlighted() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedBMac, null, OptionsPanel.this.selectedBMac), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
                this.setBackground(OptionsPanel.this.selectedMac);
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
        }

        public void mouseClicked(MouseEvent e) {
            OptionsPanel.this.setCurrentIndex(this.index);
        }

        public void mousePressed(MouseEvent e) {
            if (!OptionsPanel.this.isMac) {
                this.setSelected();
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (this.index != OptionsPanel.this.currentCategory && !OptionsPanel.this.isMac) {
                this.setHighlighted();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.index != OptionsPanel.this.currentCategory && !OptionsPanel.this.isMac) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OptionsPanel.this.firePropertyChange("buran" + evt.getPropertyName(), null, null);
        }
    }

    private class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = OptionsPanel.this.getCurrentIndex();
            if (i < OptionsPanel.this.optionCategories.size() - 1) {
                OptionsPanel.this.setCurrentIndex(i + 1);
            } else {
                OptionsPanel.this.setCurrentIndex(0);
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = OptionsPanel.this.getCurrentIndex();
            if (i > 0) {
                OptionsPanel.this.setCurrentIndex(i - 1);
            } else {
                OptionsPanel.this.setCurrentIndex(OptionsPanel.this.optionCategories.size() - 1);
            }
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Component c = FocusManager.getCurrentManager().getFocusOwner();
            if (c instanceof Button) {
                OptionsPanel.this.setCurrentIndex(((Button)c).index);
                ((Button)c).setSelected();
            }
        }
    }

    private class SelectAction
    extends AbstractAction {
        private int index;

        SelectAction(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.setCurrentIndex(this.index);
        }
    }
}

