/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.wizard.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class WizardTypePanel
extends BasicWizardIterator.Panel {
    private DataModel data;
    private boolean firstTime = true;
    private boolean lastStaticValue = true;
    private JRadioButton custom;
    private JRadioButton dynamic;
    private JLabel filler;
    private JRadioButton newFile;
    private JTextField numberOfSteps;
    private JLabel numberOfStepsTxt;
    private ButtonGroup registrationType;
    private JLabel registrationTypeTxt;
    private JRadioButton statik;
    private ButtonGroup wizardSteps;
    private JLabel wizardStepsTxt;

    public WizardTypePanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", WizardTypePanel.getMessage("LBL_WizardWizardTitle"));
        this.numberOfSteps.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                WizardTypePanel.this.checkValidity();
            }
        });
    }

    protected String getPanelName() {
        return WizardTypePanel.getMessage("LBL_WizardType_Title");
    }

    protected void storeToDataModel() {
        this.data.setBranching(this.dynamic.isSelected());
        this.data.setFileTemplateType(this.newFile.isSelected());
        this.data.setNumberOfSteps(this.getNumberOfSteps());
    }

    private int getNumberOfSteps() {
        return Integer.parseInt(this.numberOfSteps.getText().trim());
    }

    protected void readFromDataModel() {
        if (this.firstTime) {
            this.firstTime = false;
            this.markInvalid();
        } else {
            this.checkValidity();
        }
    }

    private void checkValidity() {
        if (!this.isNumberOfStepsValid()) {
            this.setError(WizardTypePanel.getMessage("MSG_IncorrectNumberOfSteps"));
        } else {
            this.markValid();
        }
    }

    private boolean isNumberOfStepsValid() {
        try {
            return this.getNumberOfSteps() > 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(WizardTypePanel.class);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_WizardTypePanel"));
        this.custom.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Custom"));
        this.newFile.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_NewFile"));
        this.statik.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Static"));
        this.dynamic.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Dynamic"));
        this.numberOfStepsTxt.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_LBL_NumberOfSteps"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)WizardTypePanel.class, (String)key);
    }

    private void initComponents() {
        this.registrationType = new ButtonGroup();
        this.wizardSteps = new ButtonGroup();
        this.registrationTypeTxt = new JLabel();
        this.custom = new JRadioButton();
        this.newFile = new JRadioButton();
        this.wizardStepsTxt = new JLabel();
        this.statik = new JRadioButton();
        this.dynamic = new JRadioButton();
        this.numberOfStepsTxt = new JLabel();
        this.numberOfSteps = new JTextField();
        this.filler = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.registrationTypeTxt, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"LBL_RegistrationType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.registrationTypeTxt, gridBagConstraints);
        this.registrationType.add(this.custom);
        this.custom.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.custom, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"CTL_Custom"));
        this.custom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.custom.setMargin(new Insets(0, 0, 0, 0));
        this.custom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add((Component)this.custom, gridBagConstraints);
        this.registrationType.add(this.newFile);
        Mnemonics.setLocalizedText((AbstractButton)this.newFile, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"CTL_NewFile"));
        this.newFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newFile.setMargin(new Insets(0, 0, 0, 0));
        this.newFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add((Component)this.newFile, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.wizardStepsTxt, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"LBL_WizardSteps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.wizardStepsTxt, gridBagConstraints);
        this.wizardSteps.add(this.statik);
        this.statik.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.statik, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"CTL_Static"));
        this.statik.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.statik.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add((Component)this.statik, gridBagConstraints);
        this.wizardSteps.add(this.dynamic);
        Mnemonics.setLocalizedText((AbstractButton)this.dynamic, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"CTL_Dynamic"));
        this.dynamic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dynamic.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 24, 0);
        this.add((Component)this.dynamic, gridBagConstraints);
        this.numberOfStepsTxt.setLabelFor(this.numberOfSteps);
        Mnemonics.setLocalizedText((JLabel)this.numberOfStepsTxt, (String)NbBundle.getMessage((Class)WizardTypePanel.class, (String)"LBL_NumberOfSteps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.numberOfStepsTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.numberOfSteps, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
    }

    private void typeChanged(ActionEvent evt) {
        boolean isCustom = this.custom.isSelected();
        this.statik.setEnabled(isCustom);
        this.dynamic.setEnabled(isCustom);
        if (isCustom) {
            this.statik.setSelected(this.lastStaticValue);
        } else {
            this.lastStaticValue = this.statik.isSelected();
            this.dynamic.setSelected(true);
        }
    }
}

