/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class PickNameAction
extends CookieAction {
    static final /* synthetic */ boolean $assertionsDisabled;

    private static FileObject findFile(Node[] activatedNodes) {
        return ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
    }

    private static NbModuleProject findProject(FileObject f) {
        URL location = (URL)f.getAttribute("WritableXMLFileSystem.location");
        if (location == null) {
            return null;
        }
        NbModuleProject p = (NbModuleProject)FileOwnerQuery.getOwner((URI)URI.create(location.toExternalForm()));
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError(location);
        }
        return p;
    }

    private static String findBundlePath(NbModuleProject p, FileObject f) {
        FileObject src = p.getSourceDirectory();
        ManifestManager mm = ManifestManager.getInstance(p.getManifest(), false);
        String bundlePath = mm.getLocalizingBundle();
        if (bundlePath != null && bundlePath.endsWith(".properties") && src.getFileObject(bundlePath) != null) {
            return bundlePath;
        }
        return null;
    }

    protected void performAction(Node[] activatedNodes) {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage((Class)PickNameAction.class, (String)"PickNameAction_dialog_label"), NbBundle.getMessage((Class)PickNameAction.class, (String)"PickNameAction_dialog_title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        FileObject f = PickNameAction.findFile(activatedNodes);
        NbModuleProject p = PickNameAction.findProject(f);
        String bundlePath = PickNameAction.findBundlePath(p, f);
        try {
            FileObject properties = p.getSourceDirectory().getFileObject(bundlePath);
            EditableProperties ep = Util.loadProperties(properties);
            ep.setProperty(f.getPath(), name);
            Util.storeProperties(properties, ep);
            f.setAttribute("SystemFileSystem.localizingBundle", (Object)bundlePath.substring(0, bundlePath.length() - ".properties".length()).replace('/', '.'));
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        FileObject f = PickNameAction.findFile(activatedNodes);
        if (f == null) {
            return false;
        }
        NbModuleProject p = PickNameAction.findProject(f);
        if (p == null) {
            return false;
        }
        return PickNameAction.findBundlePath(p, f) != null;
    }

    public String getName() {
        return NbBundle.getMessage((Class)PickIconAction.class, (String)"LBL_pick_name");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    static {
        $assertionsDisabled = !PickNameAction.class.desiredAssertionStatus();
    }
}

