/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjar.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbNodesFactory;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class EjbContainerChildren
extends Children.Keys
implements PropertyChangeListener {
    private final EjbJar model;
    private final ClassPath srcPath;
    private final FileObject ddFile;
    private final EjbNodesFactory nodeFactory;

    public EjbContainerChildren(EjbJar model, ClassPath srcPath, FileObject ddFile, EjbNodesFactory nodeFactory) {
        this.model = model;
        ClassPath bootClassPath = ClassPath.getClassPath((FileObject)srcPath.getRoots()[0], (String)"classpath/boot");
        this.srcPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{srcPath, bootClassPath});
        this.ddFile = ddFile;
        this.nodeFactory = nodeFactory;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        EnterpriseBeans beans = this.model.getEnterpriseBeans();
        ArrayList keys = Collections.EMPTY_LIST;
        if (beans != null) {
            Session[] sessionBeans = beans.getSession();
            Entity[] entityBeans = beans.getEntity();
            MessageDriven[] messageBeans = beans.getMessageDriven();
            Comparator ejbComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return this.getEjbDisplayName((Ejb)o1).compareTo(this.getEjbDisplayName((Ejb)o2));
                }

                private String getEjbDisplayName(Ejb ejb) {
                    String name = ejb.getDefaultDisplayName();
                    if (name == null) {
                        name = ejb.getEjbName();
                    }
                    if (name == null) {
                        name = "";
                    }
                    return name;
                }
            };
            Arrays.sort(sessionBeans, ejbComparator);
            Arrays.sort(entityBeans, ejbComparator);
            Arrays.sort(messageBeans, ejbComparator);
            keys = new ArrayList(sessionBeans.length + entityBeans.length + messageBeans.length);
            this.addKeyValues(keys, Arrays.asList(sessionBeans));
            this.addKeyValues(keys, Arrays.asList(messageBeans));
            this.addKeyValues(keys, Arrays.asList(entityBeans));
        }
        this.setKeys(keys);
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        Node[] node = null;
        if (key instanceof Session) {
            Session s = (Session)key;
            boolean isWebService = false;
            try {
                isWebService = s.getServiceEndpoint() != null;
            }
            catch (VersionNotSupportedException vnse) {
                // empty catch block
            }
            if (!isWebService && this.nodeFactory != null) {
                node = new Node[]{this.nodeFactory.createSessionNode(s, this.model, this.srcPath)};
            }
        }
        if (key instanceof Entity && this.nodeFactory != null) {
            node = new Node[]{this.nodeFactory.createEntityNode((Entity)key, this.model, this.srcPath, this.ddFile)};
        }
        if (key instanceof MessageDriven && this.nodeFactory != null) {
            node = new Node[]{this.nodeFactory.createMessageNode((MessageDriven)key, this.model, this.srcPath)};
        }
        return node == null ? new Node[]{} : node;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EjbContainerChildren.this.updateKeys();
            }
        });
    }

    private void addKeyValues(List keyContainer, List beans) {
        keyContainer.addAll(beans);
    }
}

