/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class FixActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private Listener listener;

    public FixActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(this.listener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.listener);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.setEnabled(ActionsManager.ACTION_FIX, this.shouldBeEnabled());
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.listener);
        MainProjectManager.getDefault().removePropertyChangeListener(this.listener);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_FIX);
    }

    public void doAction(Object action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FixActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException iex) {
            }
            catch (InvocationTargetException itex) {
                ErrorManager.getDefault().notify((Throwable)itex);
            }
        } else {
            this.invokeAction();
        }
    }

    private void invokeAction() {
        ((ActionProvider)this.getCurrentProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.fix", this.getLookup());
    }

    private Project getCurrentProject() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return MainProjectManager.getDefault().getMainProject();
        }
        DataObject dao = (DataObject)nodes[0].getCookie(DataObject.class);
        if (dao == null) {
            return MainProjectManager.getDefault().getMainProject();
        }
        return FileOwnerQuery.getOwner((FileObject)dao.getPrimaryFile());
    }

    private boolean shouldBeEnabled() {
        int i;
        if (!this.debugger.canFixClasses()) {
            return false;
        }
        Project p = this.getCurrentProject();
        if (p == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug.fix".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug.fix", this.getLookup());
    }

    private Lookup getLookup() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        int k = nodes.length;
        ArrayList<Node.Cookie> l = new ArrayList<Node.Cookie>();
        for (int i = 0; i < k; ++i) {
            Node.Cookie o = nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? FixActionProvider.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (o == null) continue;
            l.add(o);
        }
        return Lookups.fixed((Object[])l.toArray(new DataObject[l.size()]));
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        public void propertyChange(PropertyChangeEvent e) {
            boolean en = FixActionProvider.this.shouldBeEnabled();
            FixActionProvider.this.setEnabled(ActionsManager.ACTION_FIX, en);
            if (FixActionProvider.this.debugger.getState() == 4) {
                FixActionProvider.this.destroy();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
        }

        public void engineRemoved(DebuggerEngine engine) {
        }
    }
}

