/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.ErrorManager;

public final class FormPropertyEditorManager {
    private static HashMap editorsCache = new HashMap(30);
    private static HashMap expliciteEditors = new HashMap(10);

    public static synchronized PropertyEditor findEditor(FormProperty property) {
        PropertyEditor[] editors;
        FormModel form;
        Class propType = property.getValueType();
        Class[] edClasses = FormPropertyEditorManager.findEditorClasses(propType, form = property.getPropertyContext().getFormModel());
        if (edClasses.length > 0 && (editors = FormPropertyEditorManager.createEditorInstances(new Class[]{edClasses[0]}, propType)).length > 0) {
            return editors[0];
        }
        return null;
    }

    public static synchronized PropertyEditor[] getAllEditors(FormProperty property) {
        Class propType = property.getValueType();
        FormModel form = property.getPropertyContext().getFormModel();
        return FormPropertyEditorManager.createEditorInstances(FormPropertyEditorManager.findEditorClasses(propType, form), propType);
    }

    public static synchronized void registerEditor(Class propertyType, Class editorClass) {
        Class[] newEditors;
        Class[] currentEditors = (Class[])expliciteEditors.get(FormPropertyEditorManager.getTypeName(propertyType));
        if (currentEditors == null) {
            newEditors = new Class[]{editorClass};
        } else {
            for (int i = 0; i < currentEditors.length; ++i) {
                if (!currentEditors[i].equals(editorClass)) continue;
                return;
            }
            newEditors = new Class[currentEditors.length + 1];
            System.arraycopy(currentEditors, 0, newEditors, 0, currentEditors.length);
            newEditors[newEditors.length - 1] = editorClass;
        }
        expliciteEditors.put(FormPropertyEditorManager.getTypeName(propertyType), newEditors);
    }

    static synchronized void clearEditorsCache() {
        editorsCache.clear();
    }

    private static String getTypeName(Class type) {
        String typeName = type.getName();
        if (type.isPrimitive()) {
            if (Byte.TYPE.equals(type)) {
                typeName = "byte";
            } else if (Short.TYPE.equals(type)) {
                typeName = "short";
            } else if (Integer.TYPE.equals(type)) {
                typeName = "integer";
            } else if (Long.TYPE.equals(type)) {
                typeName = "long";
            } else if (Boolean.TYPE.equals(type)) {
                typeName = "boolean";
            } else if (Float.TYPE.equals(type)) {
                typeName = "float";
            } else if (Double.TYPE.equals(type)) {
                typeName = "double";
            } else if (Character.TYPE.equals(type)) {
                typeName = "char";
            }
        }
        return typeName;
    }

    private static Class[] findEditorClasses(Class type, FormModel form) {
        Class edClass;
        int i;
        PropertyEditor stdPropEd;
        Class[] edClasses = (Class[])editorsCache.get(type);
        if (edClasses != null) {
            return edClasses;
        }
        FormLoaderSettings formSettings = FormLoaderSettings.getInstance();
        ArrayList<Class> editorsList = new ArrayList<Class>(5);
        PropertyEditor propertyEditor = stdPropEd = type == Object.class ? null : PropertyEditorManager.findEditor(type);
        if (stdPropEd != null) {
            editorsList.add(stdPropEd.getClass());
        } else {
            String editorName = type.getName();
            if (!editorName.startsWith("[")) {
                int dot = editorName.lastIndexOf(46);
                if (dot > 0) {
                    editorName = editorName.substring(dot + 1);
                }
                String[] searchPath = formSettings.getEditorSearchPath();
                for (i = 0; i < searchPath.length; ++i) {
                    String name = searchPath[i] + "." + editorName + "Editor";
                    try {
                        edClass = FormUtils.loadClass(name, form);
                        editorsList.add(edClass);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    catch (LinkageError e) {
                        // empty catch block
                    }
                }
            }
        }
        String typeName = FormPropertyEditorManager.getTypeName(type);
        String[][] registered = formSettings.getRegisteredEditors();
        for (int i2 = 0; i2 < registered.length; ++i2) {
            String[] typereg = registered[i2];
            if (typereg == null || typereg.length <= 0 || !typereg[0].equals(typeName)) continue;
            for (int j = 1; j < typereg.length; ++j) {
                try {
                    edClass = FormUtils.loadClass(typereg[j], form);
                    if (editorsList.contains(edClass)) continue;
                    editorsList.add(edClass);
                    continue;
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        Class[] explicite = (Class[])expliciteEditors.get(typeName);
        if (explicite != null) {
            for (i = 0; i < explicite.length; ++i) {
                Class edClass2 = explicite[i];
                if (editorsList.contains(edClass2)) continue;
                editorsList.add(edClass2);
            }
        }
        if (Component.class.isAssignableFrom(type)) {
            editorsList.add(ComponentChooserEditor.class);
        }
        editorsList.add(RADConnectionPropertyEditor.class);
        edClasses = new Class[editorsList.size()];
        editorsList.toArray(edClasses);
        editorsCache.put(type, edClasses);
        return edClasses;
    }

    private static PropertyEditor[] createEditorInstances(Class[] edClasses, Class propertyType) {
        ArrayList<FormAwareEditor> instancesList = new ArrayList<FormAwareEditor>(edClasses.length);
        for (int i = 0; i < edClasses.length; ++i) {
            Class edType = edClasses[i];
            if (RADConnectionPropertyEditor.class.isAssignableFrom(edType)) {
                instancesList.add(new RADConnectionPropertyEditor(propertyType));
                continue;
            }
            if (ComponentChooserEditor.class.isAssignableFrom(edType)) {
                instancesList.add(new ComponentChooserEditor(new Class[]{propertyType}));
                continue;
            }
            if (!PropertyEditor.class.isAssignableFrom(edType)) continue;
            try {
                instancesList.add((FormAwareEditor)edType.newInstance());
                continue;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        PropertyEditor[] editors = new PropertyEditor[instancesList.size()];
        instancesList.toArray(editors);
        return editors;
    }
}

