/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.impl.SchemaComponentFactoryImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaElements;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SyncUnitReviewVisitor;
import org.netbeans.modules.xml.schema.model.impl.xdm.SyncUpdateVisitor;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelImpl
extends AbstractDocumentModel<SchemaComponent>
implements SchemaModel {
    private SchemaImpl schema;
    private SchemaComponentFactory csef = new SchemaComponentFactoryImpl(this);

    public SchemaModelImpl(ModelSource modelSource) {
        super(modelSource);
    }

    @Override
    public SchemaImpl getSchema() {
        return (SchemaImpl)this.getRootComponent();
    }

    @Override
    public SchemaComponentFactory getFactory() {
        return this.csef;
    }

    public SchemaComponent createRootComponent(Element root) {
        SchemaImpl newSchema = (SchemaImpl)this.csef.create(root, null);
        if (newSchema == null) {
            throw new IllegalArgumentException("Invalid DOM element " + root.getLocalName());
        }
        this.schema = newSchema;
        return this.getSchema();
    }

    public SchemaComponent getRootComponent() {
        return this.schema;
    }

    public Set<Schema> findSchemas(String namespace) {
        HashSet<Schema> resultSchemas = new HashSet<Schema>();
        return this._findSchemas(namespace, resultSchemas);
    }

    Set<Schema> _findSchemas(String namespace, Set<Schema> result) {
        SchemaImpl schema = this.getSchema();
        if (schema == null) {
            return result;
        }
        String targetNamespace = schema.getTargetNamespace();
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            SchemaModel primitiveModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            result.add(primitiveModel.getSchema());
        } else if (targetNamespace == null && namespace == null || targetNamespace != null && namespace == null || namespace.equals(schema.getTargetNamespace())) {
            result.add(schema);
            this.checkIncludeSchemas(namespace, result);
            this.checkRedefineSchemas(namespace, result);
        } else if (targetNamespace == null && namespace != null) {
            result.add(schema);
            this.checkIncludeSchemas(namespace, result);
            this.checkRedefineSchemas(namespace, result);
            this.checkImportedSchemas(namespace, result);
        } else {
            this.checkImportedSchemas(namespace, result);
        }
        return result;
    }

    private void checkIncludeSchemas(String namespace, Set<Schema> result) {
        Collection<Include> includes = this.getSchema().getIncludes();
        for (Include include : includes) {
            try {
                SchemaModel model = include.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED || result.contains(model.getSchema())) continue;
                result.addAll(((SchemaModelImpl)model)._findSchemas(namespace, result));
            }
            catch (CatalogModelException ex) {}
        }
    }

    private void checkRedefineSchemas(String namespace, Set<Schema> result) {
        Collection<Redefine> redefines = this.getSchema().getRedefines();
        for (Redefine redefine : redefines) {
            try {
                SchemaModel model = redefine.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED || result.contains(model.getSchema())) continue;
                result.addAll(((SchemaModelImpl)model)._findSchemas(namespace, result));
            }
            catch (CatalogModelException ex) {}
        }
    }

    private void checkImportedSchemas(String namespace, Set<Schema> result) {
        Collection<Import> imports = this.getSchema().getImports();
        for (Import imp : imports) {
            try {
                SchemaModel model = imp.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED) continue;
                String targetNS = model.getSchema().getTargetNamespace();
                if ((namespace != null || targetNS != null) && (namespace == null || !namespace.equals(targetNS))) continue;
                result.add(model.getSchema());
            }
            catch (CatalogModelException ex) {}
        }
    }

    @Override
    public String getEffectiveNamespace(SchemaComponent component) {
        SchemaModel componentModel = component.getModel();
        SchemaImpl schema = this.getSchema();
        Schema componentSchema = componentModel.getSchema();
        String tns = schema.getTargetNamespace();
        String componentTNS = componentSchema.getTargetNamespace();
        if (this == componentModel) {
            return tns;
        }
        if (componentTNS == null && tns != null) {
            Collection<Import> imports = schema.getImports();
            for (Import imp : imports) {
                String importedTNS;
                SchemaModel m = null;
                try {
                    m = imp.resolveReferencedModel();
                }
                catch (CatalogModelException ex) {
                    // empty catch block
                }
                if (componentModel.equals(m)) {
                    return null;
                }
                if (m == null || m.getState() == Model.State.NOT_WELL_FORMED || (importedTNS = m.getSchema().getTargetNamespace()) == null) continue;
                Collection visibleSchemas = this.findSchemas(importedTNS);
                for (Schema visible : visibleSchemas) {
                    if (!componentModel.equals(visible.getModel())) continue;
                    return null;
                }
            }
            return tns;
        }
        return componentTNS;
    }

    public SchemaComponent createComponent(SchemaComponent parent, Element element) {
        return (SchemaComponent)this.csef.create(element, parent);
    }

    protected ComponentUpdater<SchemaComponent> getComponentUpdater() {
        return new SyncUpdateVisitor<SchemaComponent>();
    }

    public Set<QName> getQNames() {
        return SchemaElements.allQNames();
    }

    public SyncUnit prepareSyncUnit(ChangeInfo changes, SyncUnit unit) {
        if ((unit = super.prepareSyncUnit(changes, unit)) != null) {
            return new SyncUnitReviewVisitor().review(unit);
        }
        return null;
    }

    public DocumentModelAccess getAccess() {
        if (this.access == null) {
            super.getAccess().setAutoSync(true);
        }
        return super.getAccess();
    }
}

