/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    private static final long serialVersionUID = 3L;
    private static final String WORD_SEPARATORS = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected boolean caseSensitive;
    protected boolean wholeWords;
    protected transient String ciMatchString;
    protected String matchString;
    protected String reString;
    protected transient Pattern pattern;
    private transient Matcher matcher;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!this.caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
        if (this.reString != null) {
            this.setRe(this.reString);
        }
    }

    protected boolean match(String text) {
        if (this.matchString != null) {
            if (!this.caseSensitive) {
                text = text.toUpperCase();
            }
            return this.matchString(text, 0) >= 0;
        }
        return this.matchRE(text);
    }

    protected boolean matchRE(String line) {
        this.matcher = this.pattern.matcher(line);
        return this.matcher.find();
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected int matchString(String text, int fromIndex) {
        int index = text.indexOf(this.caseSensitive ? this.matchString : this.ciMatchString, fromIndex);
        if (this.wholeWords && index >= 0) {
            if (index > 0 && WORD_SEPARATORS.indexOf(text.charAt(index - 1)) < 0) {
                index = -1;
            } else {
                int matchLen = this.matchString.length();
                if (index + matchLen < text.length() && WORD_SEPARATORS.indexOf(text.charAt(index + matchLen)) < 0) {
                    index = -1;
                }
            }
        }
        return index;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String substring) {
        if (substring == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (substring.length() == 0) {
            substring = null;
        } else if (!this.caseSensitive) {
            this.ciMatchString = substring.toUpperCase();
        }
        this.matchString = substring;
        this.pattern = null;
        this.reString = null;
        this.setValid(substring != null);
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public void setRe(String re) {
        this.setReImpl(re);
    }

    private void setReImpl(String exp) {
        if (exp == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (exp.length() == 0) {
            exp = null;
        } else {
            try {
                this.pattern = Pattern.compile(exp);
            }
            catch (PatternSyntaxException ex) {
                this.setValid(false);
                throw new IllegalArgumentException();
            }
        }
        this.reString = exp;
        this.matchString = null;
        this.setValid(exp != null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (caseSensitive == this.caseSensitive) {
            return;
        }
        this.caseSensitive = caseSensitive;
        if (this.matchString != null) {
            this.ciMatchString = caseSensitive ? null : this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        if (wholeWords == this.wholeWords) {
            return;
        }
        this.wholeWords = wholeWords;
    }
}

