/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions.settings;

import java.beans.IntrospectionException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ManagerSettings
implements Node.Handle {
    private static final long serialVersionUID = 1L;
    public static final String AFTER_OPEN_SCAN_DELAY = "showScanDelay";
    public static final String AFTER_EDIT_SCAN_DELAY = "editScanDelay";
    public static final String AFTER_SAVE_SCAN_DELAY = "saveScanDelay";
    private int showScanDelay = 500;
    private int editScanDelay = 1000;
    private int saveScanDelay = 1000;
    private static final int DEFAULT_SHOW_SCAN_DELAY = 500;
    private static final int DEFAULT_EDIT_SCAN_DELAY = 1000;
    private static final int DEFAULT_SAVE_SCAN_DELAY = 1000;
    private static final boolean DEFAULT_SCAN_ON_SHOW = true;
    private static final boolean DEFAULT_SCAN_ON_EDIT = true;
    private static final boolean DEFAULT_SCAN_ON_SAVE = false;
    private boolean registryRead = false;
    private Set disabled = null;
    private Set noconfirm = null;
    private Set expandedTypes = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ManagerSettings() {
    }

    public static ManagerSettings getDefault() {
        ManagerSettings cfg = (ManagerSettings)Lookup.getDefault().lookup(ManagerSettings.class);
        if (!$assertionsDisabled && cfg == null) {
            throw new AssertionError((Object)"#45809 default lookup has failed to locate ...suggestions.settings.ManagerSettings!");
        }
        return cfg;
    }

    public static ManagerSettings layerEntryPoint() {
        return new ManagerSettings();
    }

    public void store() {
        this.writeTypeRegistry();
    }

    public int getShowScanDelay() {
        return this.showScanDelay;
    }

    public void setShowScanDelay(int showScanDelay) {
        if (showScanDelay < 0) {
            showScanDelay = 500;
        }
        this.showScanDelay = showScanDelay;
    }

    public int getEditScanDelay() {
        return this.editScanDelay;
    }

    public void setEditScanDelay(int editScanDelay) {
        if (editScanDelay < 0) {
            editScanDelay = 1000;
        }
        this.editScanDelay = editScanDelay;
    }

    public int getSaveScanDelay() {
        return this.saveScanDelay;
    }

    public void setSaveScanDelay(int saveScanDelay) {
        if (saveScanDelay < 0) {
            saveScanDelay = 500;
        }
        this.saveScanDelay = saveScanDelay;
    }

    public boolean isScanOnShow() {
        return this.getShowScanDelay() != 0;
    }

    public boolean isScanOnEdit() {
        return this.getEditScanDelay() != 0;
    }

    public boolean isScanOnSave() {
        return this.getSaveScanDelay() != 0;
    }

    private File getRegistryFile(boolean create) {
        String loc = System.getProperty("netbeans.user") + File.separatorChar + "system" + File.separatorChar + "TaskList" + File.separatorChar + "suggestiontype-registry.xml";
        File file = new File(loc);
        if (create && !file.exists()) {
            File parent = file.getParentFile();
            parent.mkdirs();
        }
        return file;
    }

    private boolean readTypeRegistry() {
        if (this.registryRead) {
            return true;
        }
        this.registryRead = true;
        File file = this.getRegistryFile(false);
        if (file.exists()) {
            try {
                BufferedReader fileReader = new BufferedReader(new FileReader(file));
                try {
                    XMLReader reader = XMLUtil.createXMLReader((boolean)false);
                    TypeXMLHandler handler = new TypeXMLHandler();
                    reader.setContentHandler(handler);
                    reader.setErrorHandler(handler);
                    reader.setEntityResolver(handler);
                    reader.parse(new InputSource(fileReader));
                    this.disabled = handler.getDisabled();
                    this.noconfirm = handler.getNoConfirm();
                    this.expandedTypes = handler.getExpanded();
                    this.showScanDelay = handler.getShowScanDelay();
                    this.editScanDelay = handler.getEditScanDelay();
                    this.saveScanDelay = handler.getSaveScanDelay();
                    return true;
                }
                catch (SAXException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    ((Reader)fileReader).close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return false;
    }

    public synchronized boolean isEnabled(String id) {
        if (this.disabled == null) {
            this.readTypeRegistry();
            if (this.disabled == null) {
                this.disabled = new HashSet(40);
            }
        }
        return !this.disabled.contains(id);
    }

    boolean writeTypeRegistry() {
        File file = this.getRegistryFile(true);
        try {
            SuggestionType type;
            Iterator it;
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<!DOCTYPE suggestionregistry PUBLIC '-//NetBeans//DTD suggestion registry 1.0//EN' 'http://www.netbeans.org/dtds/suggestion-registry-1_0.dtd'>\n");
            writer.write("<typeregistry>\n");
            if (this.disabled != null && (it = this.disabled.iterator()).hasNext()) {
                writer.write("  <disabled>\n");
                while (it.hasNext()) {
                    String typeName = (String)it.next();
                    writer.write("    <type id=\"");
                    writer.write(typeName);
                    writer.write("\"/>\n");
                }
                writer.write("  </disabled>\n");
            }
            if (this.noconfirm != null && (it = this.noconfirm.iterator()).hasNext()) {
                writer.write("  <noconfirm>\n");
                while (it.hasNext()) {
                    type = (SuggestionType)it.next();
                    writer.write("    <type id=\"");
                    writer.write(type.getName());
                    writer.write("\"/>\n");
                }
                writer.write("  </noconfirm>\n");
            }
            if (this.expandedTypes != null && (it = this.expandedTypes.iterator()).hasNext()) {
                writer.write("  <expanded>\n");
                while (it.hasNext()) {
                    type = (SuggestionType)it.next();
                    writer.write("    <type id=\"");
                    writer.write(type.getName());
                    writer.write("\"/>\n");
                }
                writer.write("  </expanded>\n");
            }
            if (!this.isScanOnShow() || this.showScanDelay != 500) {
                writer.write("  <scan-preference event=\"show\" enabled=\"");
                writer.write(this.isScanOnShow() ? "on" : "off");
                writer.write("\" delay=\"");
                writer.write(Integer.toString(this.showScanDelay));
                writer.write("\"/>\n");
            }
            if (!this.isScanOnEdit() || this.editScanDelay != 1000) {
                writer.write("  <scan-preference event=\"edit\" enabled=\"");
                writer.write(this.isScanOnEdit() ? "on" : "off");
                writer.write("\" delay=\"");
                writer.write(Integer.toString(this.editScanDelay));
                writer.write("\"/>\n");
            }
            if (this.isScanOnSave() || this.saveScanDelay != 1000) {
                writer.write("  <scan-preference event=\"save\" enabled=\"");
                writer.write(this.isScanOnSave() ? "on" : "off");
                writer.write("\" delay=\"");
                writer.write(Integer.toString(this.saveScanDelay));
                writer.write("\"/>\n");
            }
            writer.write("</typeregistry>\n");
            ((Writer)writer).close();
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return false;
        }
    }

    public synchronized void setEnabled(String id, boolean enabled) {
        if (this.disabled == null) {
            this.disabled = new HashSet(40);
        }
        if (enabled) {
            this.disabled.remove(id);
        } else {
            this.disabled.add(id);
        }
    }

    public synchronized boolean isConfirm(SuggestionType type) {
        if (this.noconfirm == null) {
            this.readTypeRegistry();
            if (this.noconfirm == null) {
                this.noconfirm = new HashSet(40);
            }
        }
        return !this.noconfirm.contains(type);
    }

    public synchronized void setConfirm(SuggestionType type, boolean confirm) {
        if (this.noconfirm == null) {
            this.noconfirm = new HashSet(40);
        }
        if (confirm) {
            this.noconfirm.remove(type);
        } else {
            this.noconfirm.add(type);
        }
    }

    public boolean isExpandedType(SuggestionType type) {
        this.readTypeRegistry();
        if (this.expandedTypes == null) {
            return type.getName() == "nb-java-errors";
        }
        return this.expandedTypes.contains(type);
    }

    public void setExpandedType(SuggestionType type, boolean expanded) {
        this.readTypeRegistry();
        if (this.expandedTypes == null) {
            this.expandedTypes = new HashSet(2 * SuggestionTypes.getDefault().getCount());
            SuggestionType jc = SuggestionTypes.getDefault().getType("nb-java-errors");
            if (jc != null) {
                this.expandedTypes.add(jc);
            }
        }
        if (expanded) {
            this.expandedTypes.add(type);
        } else {
            this.expandedTypes.remove(type);
        }
    }

    public Node getNode() throws IOException {
        try {
            BeanNode node = new BeanNode((Object)ManagerSettings.getDefault());
            return node;
        }
        catch (IntrospectionException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    static {
        $assertionsDisabled = !ManagerSettings.class.desiredAssertionStatus();
    }

    private static class TypeXMLHandler
    extends DefaultHandler {
        private boolean parsingDisabled = false;
        private boolean parsingNoConfirm = false;
        private boolean parsingExpanded = false;
        private Set disabled = null;
        private Set noconfirm = null;
        private Set expanded = null;
        private int showScanDelay = 500;
        private int editScanDelay = 1000;
        private int saveScanDelay = 1000;
        private boolean scanOnShow = true;
        private boolean scanOnEdit = true;
        private boolean scanOnSave = false;

        TypeXMLHandler() {
        }

        public Set getDisabled() {
            return this.disabled;
        }

        public Set getNoConfirm() {
            return this.noconfirm;
        }

        public Set getExpanded() {
            return this.expanded;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            if (name.equals("type")) {
                if (this.parsingDisabled) {
                    String type = attrs.getValue("id");
                    if (this.disabled == null) {
                        this.disabled = new HashSet(50);
                    }
                    this.disabled.add(type);
                } else if (this.parsingNoConfirm) {
                    String id = attrs.getValue("id");
                    if (this.noconfirm == null) {
                        this.noconfirm = new HashSet(50);
                    }
                    SuggestionType type = SuggestionTypes.getDefault().getType(id);
                    this.noconfirm.add(type);
                } else if (this.parsingExpanded) {
                    String id = attrs.getValue("id");
                    if (this.expanded == null) {
                        this.expanded = new HashSet(50);
                    }
                    SuggestionType type = SuggestionTypes.getDefault().getType(id);
                    this.expanded.add(type);
                } else {
                    ErrorManager.getDefault().log(16, "SuggestionType Registry Parsing Error: " + name + ", " + attrs);
                }
            } else if (name.equals("disabled")) {
                this.parsingDisabled = true;
            } else if (name.equals("noconfirm")) {
                this.parsingNoConfirm = true;
            } else if (name.equals("expanded")) {
                this.parsingExpanded = true;
            } else if (name.equals("scan-preference")) {
                String event = attrs.getValue("event");
                String enabled = attrs.getValue("enabled");
                String delay = attrs.getValue("delay");
                if (event == null || enabled == null || delay == null) {
                    ErrorManager.getDefault().log(16, "Got scan-preference event=" + event + ", enabled=" + enabled + ", " + delay);
                    return;
                }
                boolean on = "on".equals(enabled);
                int interval = -1;
                try {
                    interval = Integer.parseInt(delay);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if ("show".equals(event)) {
                    this.scanOnShow = on;
                    this.showScanDelay = interval;
                } else if ("save".equals(event)) {
                    this.scanOnSave = on;
                    this.saveScanDelay = interval;
                } else if ("edit".equals(event)) {
                    this.scanOnEdit = on;
                    this.editScanDelay = interval;
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("disabled")) {
                this.parsingDisabled = false;
            } else if (name.equals("noconfirm")) {
                this.parsingNoConfirm = false;
            } else if (name.equals("expanded")) {
                this.parsingExpanded = false;
            }
        }

        public int getShowScanDelay() {
            return this.showScanDelay;
        }

        public int getEditScanDelay() {
            return this.editScanDelay;
        }

        public int getSaveScanDelay() {
            return this.saveScanDelay;
        }

        public boolean isScanOnShow() {
            return this.scanOnShow;
        }

        public boolean isScanOnEdit() {
            return this.scanOnEdit;
        }

        public boolean isScanOnSave() {
            return this.scanOnSave;
        }

        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

