/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.core.SuggestionNodeProperty;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.editors.LocationPropertyEditor;
import org.netbeans.modules.tasklist.core.editors.PriorityPropertyEditor;
import org.netbeans.modules.tasklist.core.editors.StringPropertyEditor;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.netbeans.modules.tasklist.suggestions.EditTypesAction;
import org.netbeans.modules.tasklist.suggestions.FixAction;
import org.netbeans.modules.tasklist.suggestions.ShowSuggestionAction;
import org.netbeans.modules.tasklist.suggestions.SuggestionChildren;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionImplProperties;
import org.openide.actions.PropertiesAction;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class SuggestionNode
extends TaskNode {
    private TaskListView view;

    public SuggestionNode(SuggestionImpl item) {
        this(item, Children.LEAF);
    }

    protected SuggestionNode(SuggestionImpl item, Children children) {
        super((Task)item, children);
    }

    public Action getPreferredAction() {
        if (this.item.getAction() == null) {
            return SystemAction.get((Class)ShowSuggestionAction.class);
        }
        return SystemAction.get((Class)FixAction.class);
    }

    public Node cloneNode() {
        SuggestionNode clon = new SuggestionNode((SuggestionImpl)this.item);
        if (!clon.isLeaf()) {
            clon.setChildren((Children)this.getTaskChildren().clone());
        }
        return clon;
    }

    protected TaskChildren createChildren() {
        return new SuggestionChildren((SuggestionImpl)this.item);
    }

    protected void updateIcon() {
        this.setIconBase("org/netbeans/modules/tasklist/suggestions/suggTask");
    }

    protected SystemAction[] createActions() {
        ArrayList<Object> actions = new ArrayList<Object>(20);
        if (this.item.getAction() != null) {
            actions.add(SystemAction.get((Class)FixAction.class));
        }
        actions.add(SystemAction.get((Class)ShowSuggestionAction.class));
        List typeActions = ((SuggestionImpl)this.item).getSType().getActions();
        if (typeActions != null && typeActions.size() > 0) {
            actions.add(null);
            Iterator it = typeActions.iterator();
            while (it.hasNext()) {
                actions.add(it.next());
            }
        }
        if (!"nb-tasklist-scannedtask".equals(this.item.getType())) {
            actions.add(null);
            actions.add(SystemAction.get((Class)PropertiesAction.class));
        }
        return actions.toArray(new SystemAction[actions.size()]);
    }

    public Action[] getActions(boolean empty) {
        if (empty) {
            return new SystemAction[]{SystemAction.get((Class)FilterAction.class), SystemAction.get((Class)EditTypesAction.class)};
        }
        return super.getActions(false);
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_SUMMARY));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_DETAILS));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_PRIORITY, PriorityPropertyEditor.class));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_FILENAME, StringPropertyEditor.class));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_LINE_NUMBER, StringPropertyEditor.class));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_CATEGORY));
        ss.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_LOCATION, LocationPropertyEditor.class));
        return s;
    }

    static String getCategoryLabel() {
        return NbBundle.getMessage((Class)SuggestionNode.class, (String)"Category");
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable t, List s) {
    }

    public Node.Cookie getCookie(Class cl) {
        Node.Cookie c = super.getCookie(cl);
        if (c != null) {
            return c;
        }
        if (cl.isAssignableFrom(Suggestion.class)) {
            return (SuggestionImpl)this.item;
        }
        Line l = this.item.getLine();
        if (l != null) {
            DataObject dao = DataEditorSupport.findDataObject((Line)l);
            if (dao != null) {
                return dao.getCookie(cl);
            }
            return null;
        }
        return null;
    }
}

