/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.decl.ANYType;
import org.netbeans.tax.decl.ChildrenType;
import org.netbeans.tax.decl.NameType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.UserCancelException;

public class GenerateDOMScannerSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String DOM_PACKAGE = "org.w3c.dom.";
    private static final String DOM_DOCUMENT = "org.w3c.dom.Document";
    private static final String DOM_ELEMENT = "org.w3c.dom.Element";
    private static final String DOM_NAMED_NODE_MAP = "org.w3c.dom.NamedNodeMap";
    private static final String VARIABLE_DOCUMENT = "document";
    private static final String VARIABLE_ELEMENT = "element";
    private static final String VARIABLE_ATTRS = "attrs";
    private static final String METHOD_SCAN_DOCUMENT = "visitDocument";
    private static final String METHOD_SCAN_ELEMENT = "visitElement";
    private static final Type Type_STRING = Type.createFromClass((Class)String.class);
    private DataObject DO;
    private TreeDTDRoot dtd;

    public GenerateDOMScannerSupport(DTDDataObject DO) {
        this((DataObject)DO, null);
    }

    public GenerateDOMScannerSupport(DataObject DO, TreeDTDRoot dtd) {
        if (DO == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = DO;
        this.dtd = dtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        try {
            if (this.getDTD() == null) {
                return;
            }
            FileObject primFile = this.DO.getPrimaryFile();
            String rawName = primFile.getName();
            String name = rawName.substring(0, 1).toUpperCase() + rawName.substring(1) + Util.THIS.getString("NAME_SUFFIX_Scanner");
            FileObject folder = primFile.getParent();
            String packageName = Util.findJavaPackage(folder);
            FileObject generFile = new SelectFileDialog(folder, name, JAVA_EXT).getFileObject();
            name = generFile.getName();
            FileLock lock = null;
            PrintStream printer = null;
            try {
                GuiUtil.setStatusText((String)Util.THIS.getString("MSG_DOM_1"));
                lock = generFile.lock();
                printer = new PrintStream(generFile.getOutputStream(lock));
                printer.println(this.prepareDOMScanner(name, packageName, primFile));
            }
            finally {
                GuiUtil.setStatusText((String)"");
                if (printer != null) {
                    printer.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            GuiUtil.performDefaultAction((FileObject)generFile);
        }
        catch (UserCancelException e) {
        }
        catch (SourceException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (TreeException e) {
            GuiUtil.notifyError((String)Util.THIS.getString("MSG_DOM_ERR_1"));
        }
        catch (IOException e) {
            GuiUtil.notifyError((String)Util.THIS.getString("MSG_DOM_ERR_2"));
        }
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie cake = (TreeEditorCookie)((DTDDataObject)this.DO).getCookie(TreeEditorCookie.class);
            if (cake == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot result = cake.openDocumentRoot();
            this.dtd = (TreeDTDRoot)result;
        }
        return this.dtd;
    }

    private String prepareDOMScanner(String name, String packageName, FileObject primFile) throws IOException, SourceException, TreeException {
        this.getDTD();
        String header = GenerateSupportUtils.getJavaFileHeader(name, primFile);
        String packageLine = packageName != null && packageName.length() != 0 ? "package " + packageName + ";\n" : "";
        ClassElement clazz = this.prepareDOMScannerClass(name);
        StringBuffer buf = new StringBuffer();
        buf.append(header).append("\n").append(packageLine).append(clazz.toString());
        return buf.toString();
    }

    private ClassElement prepareDOMScannerClass(String name) throws SourceException {
        ClassElement clazz = new ClassElement();
        JavaDoc.Class javadoc = clazz.getJavaDoc();
        javadoc.setRawText("\n This is a scanner of DOM tree.\n\n Example:\n <pre>\n     javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();\n     javax.xml.parsers.DocumentBuilder builder = builderFactory.newDocumentBuilder();\n     org.w3c.dom.Document document = builder.parse (new org.xml.sax.InputSource (???));\n     <font color=\"blue\">" + name + " scanner = new " + name + " (document);</font>\n" + "     <font color=\"blue\">scanner." + METHOD_SCAN_DOCUMENT + "();</font>\n" + " </pre>\n" + "\n" + " @see org.w3c.dom.Document\n" + " @see org.w3c.dom.Element\n" + " @see org.w3c.dom.NamedNodeMap\n");
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        this.dtd2java(clazz, this.findRootTagName());
        return clazz;
    }

    private void dtd2java(ClassElement clazz, String tempRootName) throws SourceException {
        Type docType = Type.parse((String)DOM_DOCUMENT);
        Type elemType = Type.parse((String)DOM_ELEMENT);
        FieldElement field = new FieldElement();
        field.setType(docType);
        field.setName(Identifier.create((String)VARIABLE_DOCUMENT));
        JavaDoc.Field javadoc = field.getJavaDoc();
        javadoc.setRawText("org.w3c.dom.Document document");
        clazz.addField(field);
        ConstructorElement constructor = new ConstructorElement();
        constructor.setModifiers(1);
        constructor.setName(clazz.getName());
        constructor.setParameters(new MethodParameter[]{new MethodParameter(VARIABLE_DOCUMENT, docType, false)});
        StringBuffer sb = new StringBuffer("\n");
        sb.append("this.").append(VARIABLE_DOCUMENT).append(" = ").append(VARIABLE_DOCUMENT).append(";\n");
        constructor.setBody(sb.toString());
        javadoc = constructor.getJavaDoc();
        javadoc.setRawText("Create new " + clazz.getName() + " with org.w3c.dom.Document.");
        clazz.addConstructor(constructor);
        MethodElement method = new MethodElement();
        method.setModifiers(1);
        method.setReturn(Type.VOID);
        method.setName(Identifier.create((String)METHOD_SCAN_DOCUMENT));
        sb = new StringBuffer("\n");
        sb.append(DOM_ELEMENT).append(" ").append(VARIABLE_ELEMENT).append(" = ").append(VARIABLE_DOCUMENT).append(".getDocumentElement();\n");
        Iterator it = this.dtd.getElementDeclarations().iterator();
        while (it.hasNext()) {
            String tagName = ((TreeElementDecl)it.next()).getName();
            sb.append("if ((").append(VARIABLE_ELEMENT).append(" != null) && ").append(VARIABLE_ELEMENT).append(".getTagName().equals (\"").append(tagName).append("\")) {\n");
            sb.append(METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(tagName)).append(" (").append(VARIABLE_ELEMENT).append(");\n}\n");
        }
        method.setBody(sb.toString());
        javadoc = method.getJavaDoc();
        javadoc.setRawText("Scan through org.w3c.dom.Document document.");
        clazz.addMethod(method);
        it = this.dtd.getElementDeclarations().iterator();
        while (it.hasNext()) {
            TreeElementDecl next = (TreeElementDecl)it.next();
            String tagName = next.getName();
            method = new MethodElement();
            method.setReturn(Type.VOID);
            method.setName(Identifier.create((String)GenerateSupportUtils.getJavaName("visitElement_" + tagName)));
            method.setParameters(new MethodParameter[]{new MethodParameter(VARIABLE_ELEMENT, elemType, false)});
            sb = new StringBuffer();
            sb.append(" // <").append(tagName).append(">\n// element.getValue();\n");
            Iterator it2 = this.dtd.getAttributeDeclarations(tagName).iterator();
            if (it2.hasNext()) {
                sb.append(DOM_NAMED_NODE_MAP).append(" ").append(VARIABLE_ATTRS).append(" = ").append(VARIABLE_ELEMENT).append(".getAttributes();\n");
                sb.append("for (int i = 0; i < ").append(VARIABLE_ATTRS).append(".getLength(); i++) {\n");
                sb.append("org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);\n");
                while (it2.hasNext()) {
                    TreeAttlistDeclAttributeDef attr = (TreeAttlistDeclAttributeDef)it2.next();
                    sb.append("if (attr.getName().equals (\"").append(attr.getName()).append("\")) { // <").append(tagName).append(" ").append(attr.getName()).append("=\"???\">\n");
                    sb.append("// attr.getValue();\n}\n");
                }
                sb.append("}\n");
            }
            sb.append(this.generateElementScanner(next));
            method.setBody(sb.toString());
            javadoc = method.getJavaDoc();
            javadoc.setRawText("Scan through org.w3c.dom.Element named " + tagName + ".");
            clazz.addMethod(method);
        }
    }

    private String generateElementScanner(TreeElementDecl element) {
        Iterator it;
        HashSet<String> elements = new HashSet<String>();
        TreeElementDecl.ContentType type = element.getContentType();
        if (type instanceof ANYType) {
            it = this.dtd.getElementDeclarations().iterator();
            while (it.hasNext()) {
                String tagName = ((TreeElementDecl)it.next()).getName();
                elements.add(tagName);
            }
        } else {
            this.addElements(type, elements);
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append("org.w3c.dom.NodeList nodes = element.getChildNodes();\n");
        sb2.append("for (int i = 0; i < nodes.getLength(); i++) {\n");
        sb2.append("org.w3c.dom.Node node = nodes.item (i);\n");
        sb2.append("switch (node.getNodeType()) {\n");
        sb2.append("case org.w3c.dom.Node.CDATA_SECTION_NODE:\n");
        sb2.append("// ((org.w3c.dom.CDATASection)node).getData();\nbreak;\n");
        sb2.append("case org.w3c.dom.Node.ELEMENT_NODE:\n");
        sb2.append("org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;\n");
        it = this.dtd.getElementDeclarations().iterator();
        while (it.hasNext()) {
            String tagName = ((TreeElementDecl)it.next()).getName();
            if (!elements.contains(tagName)) continue;
            sb2.append("if (nodeElement.getTagName().equals (\"").append(tagName).append("\")) {\n");
            sb2.append(METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(tagName)).append(" (nodeElement);\n}\n");
        }
        sb2.append("break;\n");
        sb2.append("case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:\n");
        sb2.append("// ((org.w3c.dom.ProcessingInstruction)node).getTarget();\n");
        sb2.append("// ((org.w3c.dom.ProcessingInstruction)node).getData();\n");
        sb2.append("break;\n");
        if (type.allowText()) {
            sb2.append("case org.w3c.dom.Node.TEXT_NODE:\n");
            sb2.append("// ((org.w3c.dom.Text)node).getData();\n");
            sb2.append("break;\n");
        }
        sb2.append("}\n}\n");
        return sb2.toString();
    }

    private void addElements(TreeElementDecl.ContentType type, Set elements) {
        if (type instanceof ChildrenType) {
            Iterator it = ((ChildrenType)type).getTypes().iterator();
            while (it.hasNext()) {
                TreeElementDecl.ContentType next = (TreeElementDecl.ContentType)it.next();
                if (next instanceof ChildrenType) {
                    this.addElements(next, elements);
                    continue;
                }
                if (!(next instanceof NameType)) continue;
                elements.add(((NameType)next).getName());
            }
        }
    }

    private String findRootTagName() {
        return null;
    }
}

