/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.ComponentAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public class DeployTask
extends ComponentAdmin {
    private static final String DEPLOY_COMMAND = "deploy";
    private static final String DEPLOY_DIR_COMMAND = "deploydir";
    LocalStringsManager lsm = new LocalStringsManager();

    public void setAvailabilityenabled(boolean availabilityenabled) {
        ((DeployComponent)this.component).setAvailabilityenabled(availabilityenabled);
    }

    public void setCreatetables(boolean createtables) {
        ((DeployComponent)this.component).setCreatetables(createtables);
    }

    public void setDropandcreatetables(boolean dropandcreatetables) {
        ((DeployComponent)this.component).setDropandcreatetables(dropandcreatetables);
    }

    public void setEnabled(boolean enabled) {
        ((DeployComponent)this.component).setEnabled(enabled);
    }

    public void setForce(boolean force) {
        ((DeployComponent)this.component).setForce(force);
    }

    public void setGeneratermistubs(boolean generatermistubs) {
        ((DeployComponent)this.component).setGeneratermistubs(generatermistubs);
    }

    public void setPrecompileJsp(boolean precompile) {
        ((DeployComponent)this.component).setPrecompileJsp(precompile);
    }

    public void setUniquetablenames(boolean uniquetablenames) {
        ((DeployComponent)this.component).setUniquetablenames(uniquetablenames);
    }

    public void setUpload(boolean upload) {
        ((DeployServer)this.server).setUpload(upload);
    }

    public void setVerify(boolean verify) {
        ((DeployComponent)this.component).setVerify(verify);
    }

    public void setDeploymentplan(File deploymentplan) {
        ((DeployComponent)this.component).setDeploymentplan(deploymentplan);
    }

    public void setRetrieveStubs(File stubsDir) {
        ((DeployComponent)this.component).setRetrieveStubs(stubsDir);
    }

    public void setContextroot(String contextroot) {
        ((DeployComponent)this.component).setContextroot(contextroot);
    }

    public void setDbvendorname(String dbvendorname) {
        ((DeployComponent)this.component).setDbvendorname(dbvendorname);
    }

    public void setVirtualServers(String virtualServers) {
        ((DeployServer)this.server).setVirtualServers(virtualServers);
    }

    public AppServerAdmin.Server createServer() {
        this.log("createServer using DeployServer object", 4);
        DeployServer aNestedServer = new DeployServer(this.server);
        this.servers.add(aNestedServer);
        return aNestedServer;
    }

    protected AppServerAdmin.Server getNewServer() {
        return new DeployServer(this.server);
    }

    protected ComponentAdmin.Component getNewComponent() {
        return new DeployComponent(this.component);
    }

    private void CheckForMutuallyExclusiveAttribute(DeployComponent deployComp) throws BuildException {
        if (deployComp.createtablesIsSet && deployComp.dropandcreatetablesIsSet) {
            String msg = this.lsm.getString("MutuallyExclusivelyAttribute", new Object[]{"createtables", "dropandcreatetables"});
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected void checkComponentConfig(AppServerAdmin.Server aServer, ComponentAdmin.Component comp) throws BuildException {
        this.log("Checking component and server config in DeployTask", 4);
        DeployServer deployServer = (DeployServer)aServer;
        DeployComponent deployComp = (DeployComponent)comp;
        File theFile = comp.getFile();
        if (theFile == null) {
            throw new BuildException(this.lsm.getString("ComponentFileMustBeSpecified", new Object[]{this.getTaskName()}), this.getLocation());
        }
        super.checkComponentConfig(aServer, comp);
        if (theFile.isDirectory() && deployServer.getUpload()) {
            String hostname = aServer.getHost();
            if (hostname == null) {
                hostname = "localhost";
            }
            throw new BuildException(this.lsm.getString("UploadMayNotBeSetToTrue", new Object[]{theFile.getAbsolutePath()}), this.getLocation());
        }
        File theDir = deployComp.getRetrieveStubs();
        if (theDir != null) {
            if (!theDir.exists()) {
                throw new BuildException(this.lsm.getString("RetrieveStubsDirectoryDoesNotExist", new Object[]{theDir}), this.getLocation());
            }
            if (!theDir.isDirectory()) {
                throw new BuildException(this.lsm.getString("RetrievesStbusDoesNotReferToADirectory", new Object[]{theDir}), this.getLocation());
            }
        }
    }

    protected String getCommandString(AppServerAdmin.Server aServer, ComponentAdmin.Component comp) throws BuildException {
        String lTarget;
        DeployServer deployServer = (DeployServer)aServer;
        DeployComponent deployComp = (DeployComponent)comp;
        this.CheckForMutuallyExclusiveAttribute(deployComp);
        boolean isFile = comp.getFile().isFile();
        StringBuffer cmdString = new StringBuffer(isFile ? DEPLOY_COMMAND : DEPLOY_DIR_COMMAND);
        cmdString.append(aServer.getCommandParameters(true));
        if (comp.getType() != null) {
            this.log(this.lsm.getString("DeprecatedTypeAttribute"), 1);
        }
        cmdString.append(" --force=").append(deployComp.isForce());
        cmdString.append(" --enabled=").append(deployComp.isEnabled());
        cmdString.append(" --name ").append(comp.getName());
        cmdString.append(" --verify=").append(deployComp.isVerify());
        cmdString.append(" --precompilejsp=").append(deployComp.isPrecompileJsp());
        if (isFile) {
            cmdString.append(" --upload=").append(deployServer.getUpload());
        }
        if (deployServer.getVirtualServers() != null) {
            cmdString.append(" --virtualservers ");
            cmdString.append(deployServer.getVirtualServers());
        }
        if (deployComp.getRetrieveStubs() != null) {
            cmdString.append(" --retrieve ");
            cmdString.append("\"" + deployComp.getRetrieveStubs() + "\"");
        }
        if (deployComp.getDeploymentplan() != null) {
            cmdString.append(" --deploymentplan ");
            cmdString.append("\"" + deployComp.getDeploymentplan() + "\"");
        }
        if (deployComp.contextRootIsSet()) {
            cmdString.append(" --contextroot ").append(deployComp.getContextroot());
        }
        if (deployComp.getDbvendorname() != null) {
            cmdString.append(" --dbvendorname ").append(deployComp.getDbvendorname());
        }
        if (deployComp.createtablesIsSet) {
            cmdString.append(" --createtables=").append(deployComp.getCreatetables());
            deployComp.createtablesIsSet = false;
        }
        if (deployComp.dropandcreatetablesIsSet) {
            cmdString.append(" --dropandcreatetables=").append(deployComp.getDropandcreatetables());
            deployComp.dropandcreatetablesIsSet = false;
        }
        if (deployComp.uniquetablenamesIsSet) {
            cmdString.append(" --uniquetablenames=").append(deployComp.getUniquetablenames());
            deployComp.uniquetablenamesIsSet = false;
        }
        if (deployComp.availabilityenabledIsSet) {
            cmdString.append(" --availabilityenabled=").append(deployComp.getAvailabilityenabled());
            deployComp.availabilityenabledIsSet = false;
        }
        if (deployComp.generatermistubsIsSet) {
            cmdString.append(" --generatermistubs=").append(deployComp.getGeneratermistubs());
            deployComp.generatermistubsIsSet = false;
        }
        if ((lTarget = deployComp.getTarget()) != null && lTarget.length() > 0) {
            cmdString.append(" --target ").append(lTarget);
        }
        cmdString.append(" ").append("\"" + comp.getFile().getPath() + "\"");
        return cmdString.toString();
    }

    public class DeployComponent
    extends ComponentAdmin.Component {
        private boolean force;
        private boolean precompile;
        private File stubsDir;
        private String contextroot;
        private boolean verify;
        private boolean enabled;
        private File deploymentplan;
        private boolean availabilityenabled;
        private boolean generatermistubs;
        private String dbvendorname;
        private boolean createtables;
        private boolean dropandcreatetables;
        private boolean uniquetablenames;
        private boolean forceIsSet;
        private boolean enabledIsSet;
        private boolean precompileIsSet;
        private boolean verifyIsSet;
        public boolean createtablesIsSet;
        public boolean dropandcreatetablesIsSet;
        public boolean uniquetablenamesIsSet;
        public boolean availabilityenabledIsSet;
        public boolean generatermistubsIsSet;
        private static final boolean DEFAULT_FORCE = true;
        private static final boolean DEFAULT_PRECOMPILE = false;
        private static final boolean DEFAULT_VERIFY = false;
        private static final boolean DEFAULT_ENABLED = true;

        protected boolean contextRootIsSet() {
            return this.contextroot != null;
        }

        protected boolean getAvailabilityenabled() {
            return this.availabilityenabled;
        }

        protected boolean getCreatetables() {
            return this.createtables;
        }

        protected boolean getDropandcreatetables() {
            return this.dropandcreatetables;
        }

        protected boolean getGeneratermistubs() {
            return this.generatermistubs;
        }

        protected boolean getUniquetablenames() {
            return this.uniquetablenames;
        }

        protected boolean isEnabled() {
            if (!this.enabledIsSet) {
                return this.parent == null ? true : ((DeployComponent)this.parent).isEnabled();
            }
            return this.enabled;
        }

        protected boolean isForce() {
            if (!this.forceIsSet) {
                return this.parent == null ? true : ((DeployComponent)this.parent).isForce();
            }
            return this.force;
        }

        protected boolean isPrecompileJsp() {
            if (!this.precompileIsSet) {
                return this.parent == null ? false : ((DeployComponent)this.parent).isPrecompileJsp();
            }
            return this.precompile;
        }

        protected boolean isVerify() {
            if (!this.verifyIsSet) {
                return this.parent == null ? false : ((DeployComponent)this.parent).isVerify();
            }
            return this.verify;
        }

        public void setAvailabilityenabled(boolean availabilityenabled) {
            this.availabilityenabled = availabilityenabled;
            this.availabilityenabledIsSet = true;
        }

        public void setCreatetables(boolean createtables) {
            this.createtables = createtables;
            this.createtablesIsSet = true;
        }

        public void setDropandcreatetables(boolean dropandcreatetables) {
            this.dropandcreatetables = dropandcreatetables;
            this.dropandcreatetablesIsSet = true;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        public void setForce(boolean force) {
            this.force = force;
            this.forceIsSet = true;
        }

        public void setGeneratermistubs(boolean generatermistubs) {
            this.generatermistubs = generatermistubs;
            this.generatermistubsIsSet = true;
        }

        public void setPrecompileJsp(boolean precompile) {
            this.precompile = precompile;
            this.precompileIsSet = true;
        }

        public void setUniquetablenames(boolean uniquetablenames) {
            this.uniquetablenames = uniquetablenames;
            this.uniquetablenamesIsSet = true;
        }

        public void setVerify(boolean verify) {
            this.verify = verify;
            this.verifyIsSet = true;
        }

        protected File getDeploymentplan() {
            if (this.deploymentplan == null) {
                return this.parent == null ? null : ((DeployComponent)this.parent).getDeploymentplan();
            }
            return this.deploymentplan;
        }

        protected File getRetrieveStubs() {
            if (this.stubsDir == null) {
                return this.parent == null ? null : ((DeployComponent)this.parent).getRetrieveStubs();
            }
            return this.stubsDir;
        }

        public void setDeploymentplan(File deploymentplan) {
            this.deploymentplan = deploymentplan;
        }

        public void setRetrieveStubs(File stubsDir) {
            this.stubsDir = stubsDir;
        }

        protected String getContextroot() {
            return this.contextroot != null ? this.contextroot : this.getName();
        }

        protected String getDbvendorname() {
            return this.dbvendorname != null ? this.dbvendorname : null;
        }

        public void setContextroot(String contextroot) {
            this.contextroot = contextroot;
        }

        public void setDbvendorname(String dbvendorname) {
            this.dbvendorname = dbvendorname;
        }

        public DeployComponent(ComponentAdmin.Component theParent) {
            super(theParent);
            this.forceIsSet = false;
            this.enabledIsSet = false;
            this.precompileIsSet = false;
            this.verifyIsSet = false;
            this.createtablesIsSet = false;
            this.dropandcreatetablesIsSet = false;
            this.uniquetablenamesIsSet = false;
            this.availabilityenabledIsSet = false;
            this.generatermistubsIsSet = false;
        }
    }

    public class DeployServer
    extends AppServerAdmin.Server {
        private boolean upload;
        private String virtualServers;
        private boolean uploadIsSet;
        private static final boolean DEFAULT_UPLOAD = true;

        protected boolean getUpload() {
            DeployServer theParent = (DeployServer)this.getParent();
            if (!this.uploadIsSet) {
                return theParent == null ? true : theParent.getUpload();
            }
            return this.upload;
        }

        public void setUpload(boolean upload) {
            this.upload = upload;
            this.uploadIsSet = true;
        }

        public String getVirtualServers() {
            return this.virtualServers;
        }

        public void setVirtualServers(String virtualServers) {
            this.virtualServers = virtualServers;
        }

        public DeployServer() {
            this(null);
        }

        public DeployServer(AppServerAdmin.Server theParent) {
            super(theParent);
            this.virtualServers = null;
            this.uploadIsSet = false;
        }
    }
}

