/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import org.netbeans.modules.welcome.content.ProxyDialog;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

class HttpProxySettings {
    private static HttpProxySettings theInstance;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    public static final String PROXY_SETTINGS = "ProxySettings";
    private static String[] proxyChangeEvents;
    private static SharedClassObject settingsInstance;
    private static Method mGetProxyType;
    private static Method mSetProxyType;
    private static Method mGetProxyHost;
    private static Method mSetProxyHost;
    private static Method mGetProxyPort;
    private static Method mSetProxyPort;
    private static boolean reflectionAlreadyTried;
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";

    private HttpProxySettings() {
        HttpProxySettings.initProxyMethodsMaybe();
    }

    public static HttpProxySettings getDefault() {
        if (null == theInstance) {
            theInstance = new HttpProxySettings();
        }
        return theInstance;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public void showConfigurationDialog() {
        if (ProxyDialog.showDialog()) {
            this.propertySupport.firePropertyChange(PROXY_SETTINGS, null, this);
        }
    }

    private static boolean useReflection() {
        HttpProxySettings.initProxyMethodsMaybe();
        return mSetProxyPort != null;
    }

    private static synchronized void initProxyMethodsMaybe() {
        if (reflectionAlreadyTried) {
            return;
        }
        reflectionAlreadyTried = true;
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = l.loadClass("org.netbeans.core.IDESettings");
            settingsInstance = SharedClassObject.findObject(clazz, (boolean)true);
            mGetProxyType = clazz.getMethod("getProxyType", null);
            mSetProxyType = clazz.getMethod("setProxyType", Integer.TYPE);
            mGetProxyHost = clazz.getMethod("getUserProxyHost", null);
            mSetProxyHost = clazz.getMethod("setUserProxyHost", String.class);
            mGetProxyPort = clazz.getMethod("getUserProxyPort", null);
            mSetProxyPort = clazz.getMethod("setUserProxyPort", String.class);
            settingsInstance.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    for (int i = 0; i < proxyChangeEvents.length; ++i) {
                        if (!proxyChangeEvents[i].equals(evt.getPropertyName())) continue;
                        HttpProxySettings.getDefault().propertySupport.firePropertyChange(HttpProxySettings.PROXY_SETTINGS, null, HttpProxySettings.getDefault());
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    static int getProxyType() {
        if (HttpProxySettings.useReflection()) {
            try {
                return (Integer)mGetProxyType.invoke((Object)settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return 1;
            }
        }
        return 1;
    }

    static String getUserProxyHost() {
        if (HttpProxySettings.useReflection()) {
            try {
                return (String)mGetProxyHost.invoke((Object)settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return System.getProperty(PROXY_HOST);
    }

    static String getUserProxyPort() {
        if (HttpProxySettings.useReflection()) {
            try {
                return (String)mGetProxyPort.invoke((Object)settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return System.getProperty(PROXY_PORT);
    }

    static void setProxyConfiguration(int proxyType, String host, String port) {
        if (HttpProxySettings.useReflection()) {
            try {
                mSetProxyType.invoke((Object)settingsInstance, new Integer(proxyType));
                mSetProxyHost.invoke((Object)settingsInstance, host);
                mSetProxyPort.invoke((Object)settingsInstance, port);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        } else if (proxyType == 0) {
            System.setProperty(PROXY_HOST, "");
            System.setProperty(PROXY_PORT, "");
        } else {
            System.setProperty(PROXY_HOST, host);
            System.setProperty(PROXY_PORT, port);
        }
    }

    static {
        proxyChangeEvents = new String[]{"useProxy", "proxyType", "userProxyHost", "userProxyPort", "userNonProxy"};
        reflectionAlreadyTried = false;
    }
}

