/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Frame;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaManager;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DatabaseTablesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EntityClassesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RelatedCMPWizard
extends WizardDescriptor.ArrayIterator
implements TemplateWizard.Iterator {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_HELPER = "wizard-helper";
    private static final String PROP_CMP = "wizard-is-cmp";
    private static final String TYPE_CMP = "cmp";
    private static final String TYPE_JPA = "jpa";
    private static final Lookup.Result PERSISTENCE_PROVIDERS = Lookup.getDefault().lookup(new Lookup.Template(PersistenceGeneratorProvider.class));
    private final String type;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private int stepsStartPos;
    private WizardDescriptor wizardDescriptor;
    private PersistenceGenerator generator;
    private RelatedCMPHelper helper;
    private ProgressPanel progressPanel;

    public static RelatedCMPWizard createForJPA() {
        return new RelatedCMPWizard(TYPE_JPA);
    }

    public static RelatedCMPWizard createForCMP() {
        return new RelatedCMPWizard(TYPE_CMP);
    }

    public RelatedCMPWizard(String type) {
        this.type = type;
    }

    private static PersistenceGenerator createPersistenceGenerator(String type) {
        assert (type != null);
        Collection providers = PERSISTENCE_PROVIDERS.allInstances();
        for (PersistenceGeneratorProvider provider : providers) {
            if (!type.equals(provider.getGeneratorType())) continue;
            return provider.createGenerator();
        }
        throw new AssertionError((Object)("Could not find a persistence generator of type " + type));
    }

    private boolean isCMP() {
        return TYPE_CMP.equals(this.type);
    }

    protected WizardDescriptor.Panel[] initializePanels() {
        this.panels = new WizardDescriptor.Panel[]{new DatabaseTablesPanel.WizardPanel(), new EntityClassesPanel.WizardPanel()};
        return this.panels;
    }

    public WizardDescriptor.Panel current() {
        JComponent component;
        WizardDescriptor.Panel panel = super.current();
        if (this.steps == null) {
            this.mergeSteps(new String[]{NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_DatabaseTables"), NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() ? "LBL_EntityBeansLocation" : "LBL_EntityClasses"))});
        }
        if ((component = (JComponent)panel.getComponent()).getClientProperty(WIZARD_PANEL_CONTENT_DATA) == null) {
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
        }
        if (component.getClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX) == null) {
            if (panel == this.panels[0]) {
                component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(0));
                component.setName(this.steps[this.steps.length - 2]);
            } else {
                component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(1));
                component.setName(this.steps[this.steps.length - 1]);
            }
        }
        return panel;
    }

    static RelatedCMPHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (RelatedCMPHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    static boolean isCMP(WizardDescriptor wizardDescriptor) {
        return (Boolean)wizardDescriptor.getProperty(PROP_CMP);
    }

    public final void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.generator = RelatedCMPWizard.createPersistenceGenerator(this.type);
        FileObject configFilesFolder = null;
        if (this.isCMP()) {
            EjbJar[] ejbJars = EjbJar.getEjbJars((Project)project);
            if (ejbJars.length == 1) {
                configFilesFolder = ejbJars[0].getMetaInf();
            }
        } else {
            configFilesFolder = PersistenceLocation.getLocation((Project)project);
        }
        this.helper = new RelatedCMPHelper(project, configFilesFolder, this.generator);
        wiz.putProperty(PROP_HELPER, (Object)this.helper);
        wiz.putProperty(PROP_CMP, (Object)new Boolean(this.isCMP()));
        String wizardBundleKey = this.isCMP() ? "Templates/J2EE/RelatedCMP" : "Templates/Persistence/RelatedCMP";
        wiz.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(RelatedCMPWizard.class, (String)wizardBundleKey));
        this.generator.init((WizardDescriptor)wiz);
    }

    public void mergeSteps(String[] thisSteps) {
        String[] beforeSteps;
        Object prop = this.wizardDescriptor.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            this.stepsStartPos = beforeSteps.length;
            if (this.stepsStartPos > 0 && "...".equals(beforeSteps[this.stepsStartPos - 1])) {
                --this.stepsStartPos;
            }
        } else {
            beforeSteps = null;
            this.stepsStartPos = 0;
        }
        this.steps = new String[this.stepsStartPos + thisSteps.length];
        System.arraycopy(beforeSteps, 0, this.steps, 0, this.stepsStartPos);
        System.arraycopy(thisSteps, 0, this.steps, this.stepsStartPos, thisSteps.length);
    }

    public final void uninitialize(TemplateWizard wiz) {
        this.generator.uninit();
    }

    public Set instantiate(final TemplateWizard wiz) throws IOException {
        Frame c = WindowManager.getDefault().getMainWindow();
        if (this.helper.getPersistenceUnit() != null) {
            ProviderUtil.addPersistenceUnit(this.helper.getPersistenceUnit(), Templates.getProject((WizardDescriptor)wiz));
        }
        final String title = NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() ? "TXT_EjbGeneration" : "TXT_EntityClassesGeneration"));
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)title);
        this.progressPanel = new ProgressPanel();
        final JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        final Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RelatedCMPWizard.this.createBeans(wiz, handle);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                finally {
                    RelatedCMPWizard.this.generator.uninit();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;

            public void run() {
                if (!this.first) {
                    RequestProcessor.getDefault().post(r);
                    RelatedCMPWizard.this.progressPanel.open(progressComponent, title);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        return Collections.singleton(SourceGroupSupport.getFolderForPackage(this.helper.getLocation(), this.helper.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBeans(TemplateWizard wiz, ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Project project = Templates.getProject((WizardDescriptor)wiz);
            handle.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            this.progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            FileObject dbschemaFile = this.helper.getDBSchemaFile();
            if (dbschemaFile == null) {
                FileObject configFilesFolder = RelatedCMPWizard.getHelper((WizardDescriptor)wiz).getConfigFilesFolder();
                if (configFilesFolder == null && !this.isCMP()) {
                    configFilesFolder = PersistenceLocation.createLocation((Project)project);
                }
                assert (configFilesFolder != null) : "Should have set configFilesFolder, e.g. by retrieving it from a PersistenceLocationProvider or EjbJar or by asking the user";
                String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
                dbschemaFile = DBSchemaManager.updateDBSchemas(this.helper.getSchemaElement(), this.helper.getDBSchemaFileList(), configFilesFolder, projectName);
            }
            String extracting = NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() ? "TXT_ExtractingBeansAndRelationships" : "TXT_ExtractingEntityClassesAndRelationships"));
            handle.progress(extracting);
            this.progressPanel.setText(extracting);
            this.helper.buildBeans();
            FileObject pkg = SourceGroupSupport.getFolderForPackage(this.helper.getLocation(), this.helper.getPackageName());
            this.generator.generateBeans(this.progressPanel, this.helper, dbschemaFile, handle, false);
        }
        catch (Throwable throwable) {
            handle.finish();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RelatedCMPWizard.this.progressPanel.close();
                }
            });
            throw throwable;
        }
        handle.finish();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }
}

