/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.action;

import java.io.IOException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.webservices.action.WebServiceClassesCookie;
import org.netbeans.modules.websvc.core.webservices.action.WebServiceClassesCookieImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class WebServiceCookieFactory {
    private WebServiceCookieFactory() {
    }

    public static WebServiceClassesCookie getWebServiceClassesCookie(JavaClass ce) {
        if (ce == null) {
            return null;
        }
        Resource r = ce.getResource();
        FileObject f = JavaModel.getFileObject((Resource)r);
        if (f != null) {
            return new WebServiceClassesCookieImpl(WebServiceCookieFactory.findWSDescriptionFromClass(ce, f), f);
        }
        return null;
    }

    public static WebserviceDescription findWSDescriptionFromClass(JavaClass ce, FileObject implClassFO) {
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)implClassFO);
        if (wsSupport != null) {
            DDProvider wsDDProvider = DDProvider.getDefault();
            Webservices webServices = null;
            try {
                webServices = wsDDProvider.getDDRoot(wsSupport.getWebservicesDD());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (webServices != null) {
                WebserviceDescription[] wsDescriptions = webServices.getWebserviceDescription();
                for (int i = 0; i < wsDescriptions.length; ++i) {
                    String implBean;
                    WebserviceDescription wsDescription = wsDescriptions[i];
                    PortComponent portComponent = wsDescription.getPortComponent(0);
                    String wsSEI = portComponent.getServiceEndpointInterface();
                    if (wsSEI != null && wsSEI.equals(ce.getName())) {
                        return wsDescription;
                    }
                    ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
                    String link = serviceImplBean.getServletLink();
                    if (link == null) {
                        link = serviceImplBean.getEjbLink();
                    }
                    if ((implBean = wsSupport.getImplementationBean(link)) == null) {
                        ErrorManager.getDefault().log(1, "WSCFactory: Implementation bean reference could not be found.");
                        continue;
                    }
                    if (!implBean.equals(ce.getName())) continue;
                    return wsDescription;
                }
            }
        }
        return null;
    }
}

