/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsClassesCookie;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JaxWsClassesCookieImpl
implements JaxWsClassesCookie {
    Service service;
    FileObject implClassFO;

    public JaxWsClassesCookieImpl(Service service, FileObject implClassFO) {
        this.service = service;
        this.implClassFO = implClassFO;
    }

    private JavaClass getImplBeanClass() {
        String implBean = this.service.getImplementationClass();
        if (implBean != null) {
            return JMIUtils.findClass((String)implBean, (FileObject)this.implClassFO);
        }
        return null;
    }

    private String getImplicitValue(Type t) {
        String ret = "return ";
        if (t instanceof PrimitiveType) {
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
                return "false";
            }
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.CHAR)) {
                return "''";
            }
            return "0";
        }
        if (t instanceof JavaClass) {
            return "null";
        }
        if (t instanceof Array) {
            return "new " + t.getName() + " { }";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Method m) {
        JavaClass implClass = null;
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            m.setJavadocText(NbBundle.getMessage(JaxWsClassesCookieImpl.class, (String)"TXT_WSOperation"));
            implClass = this.getImplBeanClass();
            String body = NbBundle.getMessage(JaxWsClassesCookieImpl.class, (String)"TXT_VoidOperation");
            Type returnType = m.getType();
            boolean voidType = true;
            if (!(returnType instanceof PrimitiveType) || !((PrimitiveType)returnType).getKind().equals(PrimitiveTypeKindEnum.VOID)) {
                voidType = false;
                String retString = this.getImplicitValue(m.getType());
                if (retString != null) {
                    body = body + "return " + retString + ";";
                }
            }
            if (implClass != null) {
                implClass.getContents().add(m);
                JMIUtils.fixImports((JavaClass)implClass);
                m.setBodyText(body);
                m.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)implClass, (String)"javax.jws.WebMethod", new ArrayList()));
                if (voidType && m.getExceptionNames().size() == 0) {
                    m.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)implClass, (String)"javax.jws.Oneway", new ArrayList()));
                }
                List parameters = m.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    Parameter param = (Parameter)parameters.get(i);
                    String paramName = param.getName();
                    ArrayList<AttributeValue> attrValues = new ArrayList<AttributeValue>();
                    attrValues.add(JMIGenerationUtil.createAttributeValue((Element)implClass, (String)"name", (String)paramName));
                    param.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)implClass, (String)"javax.jws.WebParam", attrValues));
                }
                rollback = false;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        JMIUtils.openInEditor((Element)m);
    }
}

