/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;

public class AquaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Insets taInsets = new Insets(0, 0, 2, 80);
    private Color lineMiddleColor = null;
    private Color lineHlColor = null;
    private static final int BUTTON_SIZE = 19;
    private final Border cborder = new RadioButtonPseudoBorder();
    static boolean aqua14204offByOneError = System.getProperty("java.version") != null && System.getProperty("java.version").indexOf("1.4.2_04") > -1;
    private static final int ICON_WIDTH = 11;
    private static final int ICON_HEIGHT = 8;
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];
    private static BufferedImage img = null;
    static /* synthetic */ Class class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon;
    static /* synthetic */ Class class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon;

    public AquaEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public void install() {
        super.install();
        this.scroll().setMinimumXposition(10);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new AquaEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new OSXTabLayout();
    }

    public Insets getTabAreaInsets() {
        return this.taInsets;
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaEditorTabDisplayerUI((TabDisplayer)c);
    }

    protected boolean isAntialiased() {
        return true;
    }

    protected Font createFont() {
        return UIManager.getFont("Label.font");
    }

    protected int createRepaintPolicy() {
        return 95;
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        boolean stillShowing;
        boolean wasShowing = this.selectionModel.getSelectedIndex() >= this.getFirstVisibleTab() && this.selectionModel.getSelectedIndex() <= this.getLastVisibleTab();
        super.processMouseWheelEvent(e);
        boolean bl = stillShowing = this.selectionModel.getSelectedIndex() >= this.getFirstVisibleTab() && this.selectionModel.getSelectedIndex() <= this.getLastVisibleTab();
        if (wasShowing != stillShowing) {
            Component[] c = this.displayer.getComponents();
            for (int i = 0; i < c.length; ++i) {
                c[i].repaint();
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 7;
        }
        if (prefHeight % 2 == 0) {
            ++prefHeight;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] result = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        AquaEditorTabDisplayerUI.configureButton(result[0], new LeftIcon());
        AquaEditorTabDisplayerUI.configureButton(result[1], new RightIcon());
        AquaEditorTabDisplayerUI.configureButton(result[2], new DownIcon());
        result[0].setPreferredSize(new Dimension(19, 19));
        result[1].setPreferredSize(new Dimension(19, 19));
        result[2].setPreferredSize(new Dimension(19, 19));
        result[0].setBorder(this.cborder);
        result[1].setBorder(this.cborder);
        result[2].setBorder(this.cborder);
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return result;
    }

    private static void configureButton(JButton button, Icon icon) {
        button.setIcon(icon);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
        button.setRolloverEnabled(false);
        button.setOpaque(false);
    }

    protected void paintAfterTabs(Graphics g) {
        int centerY = (this.displayer.getHeight() - 2) / 2 + 0 - 1 + this.getTabAreaInsets().top + 1;
        if (this.lineMiddleColor == null) {
            this.lineMiddleColor = ColorUtil.getMiddle(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        }
        g.setColor(this.lineMiddleColor);
        int rightLineStart = this.getTabsAreaWidth() - 14;
        int rightLineEnd = this.displayer.getWidth() - 9;
        if (this.displayer.getModel().size() > 0 && !this.scroll().isLastTabClipped()) {
            int idx = this.scroll().getLastVisibleTab(this.displayer.getWidth());
            rightLineStart = this.scroll().getX(idx) + this.scroll().getW(idx) + 1;
        } else if (this.displayer.getModel().size() == 0) {
            rightLineStart = 6;
        }
        if (this.scroll().getOffset() >= 0) {
            g.drawLine(6, centerY, 13, centerY);
        }
        g.drawLine(rightLineStart, centerY, rightLineEnd, centerY);
        if (this.lineHlColor == null) {
            this.lineHlColor = ColorUtil.getMiddle(this.lineMiddleColor, UIManager.getColor("control"));
        }
        g.setColor(this.lineHlColor);
        g.drawLine(rightLineStart, centerY + 1, rightLineEnd, centerY + 1);
        if (this.scroll().getOffset() > 0) {
            g.drawLine(6, centerY + 1, 10, centerY + 1);
        }
    }

    private static final void createImages() {
        img = new BufferedImage(60, 20, 3);
        JRadioButton jrb = new JRadioButton();
        CellRendererPane pane = new CellRendererPane();
        pane.add(jrb);
        jrb.setBounds(0, 0, 80, 20);
        jrb.setBackground(null);
        jrb.setOpaque(false);
        jrb.getModel().setRollover(false);
        jrb.setRolloverEnabled(false);
        jrb.getModel().setPressed(true);
        jrb.setSelected(false);
        Graphics g = img.getGraphics();
        jrb.paint(g);
        g.translate(20, 0);
        jrb.setSelected(true);
        jrb.paint(g);
        g.translate(20, 0);
        jrb.setEnabled(false);
        jrb.paint(g);
    }

    private class RadioButtonPseudoBorder
    implements Border {
        public RadioButtonPseudoBorder() {
            if (img == null) {
                AquaEditorTabDisplayerUI.createImages();
            }
        }

        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(3, 3, 3, 3);
            return ins;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Icon ic = ((JButton)c).getIcon();
            int pos = 0;
            if (!c.isEnabled()) {
                pos = 40;
            } else {
                boolean shouldSelect;
                boolean bl = AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() != -1 && AquaEditorTabDisplayerUI.this.displayer.isActive() && (ic.getClass() == (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon == null ? (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon = AquaEditorTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI$LeftIcon")) : class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon) && AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() < AquaEditorTabDisplayerUI.this.getFirstVisibleTab() || ic.getClass() == (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon == null ? (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon = AquaEditorTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI$RightIcon")) : class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon) && AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() > AquaEditorTabDisplayerUI.this.getLastVisibleTab()) ? true : (shouldSelect = false);
                if (shouldSelect) {
                    pos = 20;
                }
                if (shouldSelect) {
                    c.setForeground(new Color(0, 64, 128));
                } else {
                    c.setForeground(UIManager.getColor("controlDkShadow"));
                }
            }
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform at = AffineTransform.getTranslateInstance(-pos, -1.0);
            g2d.drawRenderedImage(img, at);
            ((LeftIcon)ic).dontpaint = false;
            ic.paintIcon(c, g, x + width / 4 + 2, y + width / 4 + 3);
            ((LeftIcon)ic).dontpaint = true;
        }
    }

    private static class DownIcon
    extends LeftIcon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int wid;
            if (this.dontpaint) {
                return;
            }
            y -= 5;
            if (aqua14204offByOneError) {
                ++x;
            }
            if ((wid = this.getIconWidth()) % 2 == 0) {
                --wid;
            }
            int hi = this.getIconHeight();
            xpoints[0] = x - 1;
            ypoints[0] = y + hi / 2;
            xpoints[1] = x + wid - 2;
            ypoints[1] = y + hi / 2;
            xpoints[2] = x + wid / 2 - 1;
            ypoints[2] = y + hi;
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class RightIcon
    extends LeftIcon {
        private RightIcon() {
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 7;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.dontpaint) {
                return;
            }
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            int wid = this.getIconWidth();
            int hi = this.getIconHeight() + 1;
            xpoints[0] = x + 3;
            ypoints[0] = y -= 2;
            xpoints[1] = x + 3;
            ypoints[1] = y + hi + 1;
            xpoints[2] = x + (wid - 4) + 1;
            ypoints[2] = y + hi / 2;
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        protected boolean dontpaint = true;

        private LeftIcon() {
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.dontpaint) {
                return;
            }
            if (!aqua14204offByOneError) {
                --x;
            }
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            int wid = this.getIconWidth();
            int hi = this.getIconHeight() + 1;
            xpoints[0] = x + (wid - 4);
            ypoints[0] = (y -= 3) + 1;
            xpoints[1] = xpoints[0];
            ypoints[1] = y + hi + 1;
            xpoints[2] = x + 2;
            ypoints[2] = y + hi / 2 + 1;
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class OSXTabLayout
    implements LayoutManager {
        private OSXTabLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets in = AquaEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] c = parent.getComponents();
            int x = parent.getWidth() - in.right + 3;
            int y = 0;
            int centerY = (AquaEditorTabDisplayerUI.this.displayer.getHeight() - 2) / 2 + 0 + AquaEditorTabDisplayerUI.this.getTabAreaInsets().top;
            for (int i = 0; i < c.length; ++i) {
                Dimension psize = c[i].getPreferredSize();
                y = centerY - psize.height / 2;
                int w = Math.min(psize.width, parent.getWidth() - x);
                c[i].setBounds(x, y, w, Math.min(psize.height, parent.getHeight()));
                x += psize.width;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return AquaEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return AquaEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

