/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;

final class RegexpUtils {
    static final String TESTSUITE_PREFIX = "Testsuite: ";
    static final String TESTSUITE_STATS_PREFIX = "Tests run: ";
    static final String FLOAT_NUMBER_REGEX = "[0-9]*(?:\\.[0-9]+)?";
    static final String TIME_SECS_REGEX = "([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String TESTSUITE_STATS_REGEX = "Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+), +Time elapsed: +([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String OUTPUT_DELIMITER_PREFIX = "--------";
    static final String STDOUT_LABEL = "Output";
    static final String STDERR_LABEL = "Error";
    static final String OUTPUT_DELIMITER_REGEX = "-{8,} (?:Standard (Output|Error)|-{3,}) -{8,}";
    static final String TESTCASE_PREFIX = "Testcase: ";
    static final String TESTCASE_ISSUE_REGEX = "\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    static final String TESTCASE_HEADER_PLAIN_REGEX = "\\p{Blank}*((?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)\\p{Blank}+took\\p{Blank}+([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String TESTCASE_HEADER_BRIEF_REGEX = "\\p{Blank}*((?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*) *\\( *((?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*) *\\) *:\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    static final String TESTCASE_EXCEPTION_REGEX = "((?:(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*\\.?(?:Exception|Error|ComparisonFailure))|java\\.lang\\.Throwable)(?: *: *(.*))?";
    static final String CALLSTACK_LINE_PREFIX = "at ";
    static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    static final String CALLSTACK_LINE_REGEX = "(?:\\t\\t?|  +| *\\t? *\\[catch\\] )at (?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)+(?: ?\\([^()]+\\))?";
    static final String LOCATION_IN_FILE_REGEX = "(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*(?:\\:[0-9]+)?";
    static final String XML_DECL_PREFIX = "<?xml";
    static final String XML_SPACE_REGEX = "[ \\t\\r\\n]";
    static final String XML_EQ_REGEX = "[ \\t\\r\\n]*=[ \\t\\r\\n]*";
    static final String XML_ENC_REGEX = "[A-Za-z][-A-Za-z0-9._]*";
    static final String XML_DECL_REGEX = "\\Q<?xml\\E[ \\t\\r\\n]+version[ \\t\\r\\n]*=[ \\t\\r\\n]*(?:\"1\\.0\"|'1\\.0')(?:[ \\t\\r\\n]+encoding[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])[A-Za-z][-A-Za-z0-9._]*\\1)?(?:[ \\t\\r\\n]+standalone[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])(?:yes|no)\\2)?[ \\t\\r\\n]*\\?>";
    static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static Reference instRef;
    private volatile Pattern fullJavaIdPattern;
    private volatile Pattern suiteStatsPattern;
    private volatile Pattern outputDelimPattern;
    private volatile Pattern testcaseIssuePattern;
    private volatile Pattern testcaseExceptPattern;
    private volatile Pattern callstackLinePattern;
    private volatile Pattern locationInFilePattern;
    private volatile Pattern testcaseHeaderBriefPattern;
    private volatile Pattern testcaseHeaderPlainPattern;
    private volatile Pattern xmlDeclPattern;
    private volatile Pattern floatNumPattern;

    static synchronized RegexpUtils getInstance() {
        RegexpUtils instance;
        Object inst;
        if (instRef == null || (inst = instRef.get()) == null) {
            instance = new RegexpUtils();
            instRef = new WeakReference<RegexpUtils>(instance);
        } else {
            instance = (RegexpUtils)inst;
        }
        return instance;
    }

    private RegexpUtils() {
    }

    Pattern getFullJavaIdPattern() {
        if (this.fullJavaIdPattern == null) {
            this.fullJavaIdPattern = Pattern.compile("(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*");
        }
        return this.fullJavaIdPattern;
    }

    Pattern getSuiteStatsPattern() {
        if (this.suiteStatsPattern == null) {
            this.suiteStatsPattern = Pattern.compile(TESTSUITE_STATS_REGEX);
        }
        return this.suiteStatsPattern;
    }

    Pattern getOutputDelimPattern() {
        if (this.outputDelimPattern == null) {
            this.outputDelimPattern = Pattern.compile(OUTPUT_DELIMITER_REGEX);
        }
        return this.outputDelimPattern;
    }

    Pattern getTestcaseHeaderBriefPattern() {
        if (this.testcaseHeaderBriefPattern == null) {
            this.testcaseHeaderBriefPattern = Pattern.compile(TESTCASE_HEADER_BRIEF_REGEX);
        }
        return this.testcaseHeaderBriefPattern;
    }

    Pattern getTestcaseHeaderPlainPattern() {
        if (this.testcaseHeaderPlainPattern == null) {
            this.testcaseHeaderPlainPattern = Pattern.compile(TESTCASE_HEADER_PLAIN_REGEX);
        }
        return this.testcaseHeaderPlainPattern;
    }

    Pattern getTestcaseIssuePattern() {
        if (this.testcaseIssuePattern == null) {
            this.testcaseIssuePattern = Pattern.compile(TESTCASE_ISSUE_REGEX);
        }
        return this.testcaseIssuePattern;
    }

    Pattern getTestcaseExceptionPattern() {
        if (this.testcaseExceptPattern == null) {
            this.testcaseExceptPattern = Pattern.compile(TESTCASE_EXCEPTION_REGEX);
        }
        return this.testcaseExceptPattern;
    }

    Pattern getCallstackLinePattern() {
        if (this.callstackLinePattern == null) {
            this.callstackLinePattern = Pattern.compile(CALLSTACK_LINE_REGEX);
        }
        return this.callstackLinePattern;
    }

    Pattern getLocationInFilePattern() {
        if (this.locationInFilePattern == null) {
            this.locationInFilePattern = Pattern.compile(LOCATION_IN_FILE_REGEX);
        }
        return this.locationInFilePattern;
    }

    Pattern getXmlDeclPattern() {
        if (this.xmlDeclPattern == null) {
            this.xmlDeclPattern = Pattern.compile(XML_DECL_REGEX);
        }
        return this.xmlDeclPattern;
    }

    Pattern getFloatNumPattern() {
        if (this.floatNumPattern == null) {
            this.floatNumPattern = Pattern.compile(FLOAT_NUMBER_REGEX);
        }
        return this.floatNumPattern;
    }

    int parseTimeMillis(String timeString) throws NumberFormatException {
        int millis;
        int secs;
        int dotIndex = timeString.indexOf(46);
        if (dotIndex == -1) {
            secs = Integer.parseInt(timeString);
            millis = 0;
        } else {
            secs = dotIndex == 0 ? 0 : Integer.parseInt(timeString.substring(0, dotIndex));
            String fractString = timeString.substring(dotIndex + 1);
            if (fractString.length() > 4) {
                fractString = fractString.substring(0, 4);
            }
            int fractNum = Integer.parseInt(fractString);
            switch (fractString.length()) {
                case 1: {
                    millis = 100 * fractNum;
                    break;
                }
                case 2: {
                    millis = 10 * fractNum;
                    break;
                }
                case 3: {
                    millis = fractNum;
                    break;
                }
                case 4: {
                    millis = (fractNum + 5) / 10;
                    break;
                }
                default: {
                    assert (false);
                    millis = 0;
                }
            }
        }
        return 1000 * secs + millis;
    }

    int parseTimeMillisNoNFE(String timeStr) {
        if (timeStr == null || !this.getFloatNumPattern().matcher(timeStr).matches()) {
            return -1;
        }
        try {
            return this.parseTimeMillis(timeStr);
        }
        catch (NumberFormatException ex) {
            assert (false);
            return -1;
        }
    }

    static String specialTrim(String string) {
        char c;
        int lead;
        int len = string.length();
        if (len == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        for (lead = 0; lead < len && ((c = chars[lead]) == ' ' || c == '\t'); ++lead) {
        }
        if (lead == len) {
            return string.substring(len);
        }
        int trail = len;
        while ((c = chars[--trail]) == ' ' || c == '\t') {
        }
        if (lead == 0 && trail == len - 1) {
            return string;
        }
        return string.substring(lead, trail + 1);
    }
}

