/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakProxyClassPathImplementation
implements ClassPathImplementation {
    private final CopyOnWriteArraySet<WeakReference<ClassPathImplementation>> classPathRefs = new CopyOnWriteArraySet();
    private final PropertyChangeListener classPathsListener = new DelegatesListener();
    private List<PathResourceImplementation> resourcesCache;
    private ArrayList<PropertyChangeListener> listeners;

    public WeakProxyClassPathImplementation(ClassPathImplementation[] classPaths) {
        if (classPaths == null) {
            throw new IllegalArgumentException();
        }
        for (ClassPathImplementation classPath : classPaths) {
            if (classPaths == null) continue;
            classPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.classPathsListener, (Object)classPath));
            this.classPathRefs.add(new CleanupReference<ClassPathImplementation>(classPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        WeakProxyClassPathImplementation weakProxyClassPathImplementation = this;
        synchronized (weakProxyClassPathImplementation) {
            if (this.resourcesCache != null) {
                return this.resourcesCache;
            }
        }
        ArrayList result = new ArrayList(this.classPathRefs.size() * 10);
        for (WeakReference<ClassPathImplementation> classPathRef : this.classPathRefs) {
            ClassPathImplementation classPath = (ClassPathImplementation)classPathRef.get();
            if (classPath == null) continue;
            List subPath = classPath.getResources();
            assert (subPath != null) : "ClassPathImplementation.getResources() returned null. ClassPathImplementation.class: " + classPath.getClass().toString() + " ClassPathImplementation: " + classPath.toString();
            result.addAll(subPath);
        }
        WeakProxyClassPathImplementation weakProxyClassPathImplementation2 = this;
        synchronized (weakProxyClassPathImplementation2) {
            if (this.resourcesCache == null) {
                this.resourcesCache = Collections.unmodifiableList(result);
            }
            return this.resourcesCache;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer("[");
        for (WeakReference<ClassPathImplementation> classPathRef : this.classPathRefs) {
            ClassPathImplementation classPath = (ClassPathImplementation)classPathRef.get();
            if (classPath == null) continue;
            builder.append(classPath.toString());
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(String propertyName) {
        Iterator it = null;
        WeakProxyClassPathImplementation weakProxyClassPathImplementation = this;
        synchronized (weakProxyClassPathImplementation) {
            this.resourcesCache = null;
            if (this.listeners == null) {
                return;
            }
            it = ((ArrayList)this.listeners.clone()).iterator();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, null, null);
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CleanupReference<T>
    extends WeakReference<T>
    implements Runnable {
        public CleanupReference(T referent) {
            super(referent, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            WeakProxyClassPathImplementation.this.classPathRefs.remove(this);
            WeakProxyClassPathImplementation.this.change("resources");
        }
    }

    private class DelegatesListener
    implements PropertyChangeListener {
        private DelegatesListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            WeakProxyClassPathImplementation.this.change(evt.getPropertyName());
        }
    }
}

