/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseRenderer
extends Renderer {
    public static final String BUNDLE_ATTR = "com.sun.faces.bundle";
    private static String[] booleanPassthruAttributes = new String[]{"disabled", "readonly", "ismap"};
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onclick", "ondblclick", "onfocus", "onchange", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "size", "summary", "tabindex", "target", "title", "usemap", "width"};

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    public ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer == null) {
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            writer = renderKit.createResponseWriter((Writer)response.getWriter(), "text/html", request.getCharacterEncoding());
            context.setResponseWriter(writer);
        }
        return writer;
    }

    protected String getKeyAndLookupInBundle(FacesContext context, UIComponent component, String keyAttr) throws MissingResourceException {
        String key = null;
        String bundleName = null;
        ResourceBundle bundle = null;
        key = (String)component.getAttributes().get(keyAttr);
        bundleName = (String)component.getAttributes().get(BUNDLE_ATTR);
        if (bundleName == null) {
            UIViewRoot root = context.getViewRoot();
            bundleName = (String)root.getAttributes().get(BUNDLE_ATTR);
        }
        if (null == key || null == bundleName) {
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        if (null == Thread.currentThread().getContextClassLoader().getResource("javax.servlet.jsp.jstl.fmt.LocalizationContext")) {
            Object[] params = new Object[]{"javax.servlet.jsp.jstl.fmt.LocalizationContext"};
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        return bundle.getString(key);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected static void renderBooleanPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        boolean result = false;
        for (int i = 0; i < booleanPassthruAttributes.length; ++i) {
            Object value = component.getAttributes().get(booleanPassthruAttributes[i]);
            if (value == null) continue;
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = new Boolean((String)value);
            }
            if (!result) continue;
            writer.writeAttribute(booleanPassthruAttributes[i], (Object)booleanPassthruAttributes[i], booleanPassthruAttributes[i]);
        }
    }

    protected static void renderPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        BaseRenderer.renderPassThruAttributes(writer, component, null);
    }

    protected static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        boolean skip = false;
        for (int i = 0; i < passthruAttributes.length; ++i) {
            Object value;
            skip = false;
            if (null != excludes) {
                int jLen = excludes.length;
                for (int j = 0; j < jLen; ++j) {
                    if (null == excludes[j] || !excludes[j].equals(passthruAttributes[i])) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || (value = component.getAttributes().get(passthruAttributes[i])) == null || !BaseRenderer.shouldRenderAttribute(value)) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.writeAttribute(passthruAttributes[i], (Object)((String)value), passthruAttributes[i]);
        }
    }

    protected static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    public static boolean componentIsDisabledOnReadonly(UIComponent component) {
        Object disabledOrReadonly = null;
        boolean result = false;
        Object v = component.getAttributes().get("disabled");
        disabledOrReadonly = v;
        if (null != v) {
            result = disabledOrReadonly instanceof String ? ((String)disabledOrReadonly).equalsIgnoreCase("true") : disabledOrReadonly.equals(Boolean.TRUE);
        }
        if (!result && null != (disabledOrReadonly = component.getAttributes().get("readonly"))) {
            result = disabledOrReadonly instanceof String ? ((String)disabledOrReadonly).equalsIgnoreCase("true") : disabledOrReadonly.equals(Boolean.TRUE);
        }
        return result;
    }
}

