/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.spi.sql.editor.SQLEditorProvider;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class SQLEditorProviderImpl
implements SQLEditorProvider {
    private static final String CMD_FOLDER = "Databases/SQLCommands";
    static /* synthetic */ Class class$org$netbeans$modules$db$sql$editor$SQLEditorProviderImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSQLEditor(DatabaseConnection dbconn, String sql, boolean execute) {
        DataObject sqlDo;
        FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileObject tmpFo = root.getFileObject(CMD_FOLDER);
        if (tmpFo == null) {
            try {
                tmpFo = FileUtil.createFolder((FileObject)root, (String)CMD_FOLDER);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        FileObject sqlFo = null;
        int i = 1;
        while (true) {
            String nameFmt = NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$editor$SQLEditorProviderImpl == null ? SQLEditorProviderImpl.class$("org.netbeans.modules.db.sql.editor.SQLEditorProviderImpl") : class$org$netbeans$modules$db$sql$editor$SQLEditorProviderImpl), (String)"LBL_SQLCommandFileName");
            String name = MessageFormat.format(nameFmt, new Integer(i));
            try {
                sqlFo = tmpFo.createData(name);
            }
            catch (IOException e) {
                ++i;
                continue;
            }
            break;
        }
        try {
            FileLock lock = sqlFo.lock();
            try {
                OutputStream stream = sqlFo.getOutputStream(lock);
                try {
                    stream.write(239);
                    stream.write(187);
                    stream.write(191);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "utf-8"));
                    writer.write(sql);
                    writer.close();
                }
                finally {
                    stream.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        try {
            sqlDo = DataObject.find((FileObject)sqlFo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        OpenCookie openCookie = (OpenCookie)sqlDo.getCookie(OpenCookie.class);
        openCookie.open();
        SQLExecuteCookie sqlCookie = (SQLExecuteCookie)sqlDo.getCookie(SQLExecuteCookie.class);
        sqlCookie.setDatabaseConnection(dbconn);
        if (execute) {
            sqlCookie.execute();
        }
    }
}

