/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NbSafeDeleteRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin;

    public NbSafeDeleteRefactoringPlugin(AbstractRefactoring refactoring) {
        super(refactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            SafeDeleteRefactoring delete = (SafeDeleteRefactoring)this.refactoring;
            Problem problem = null;
            Element[] elements = delete.getElementsToDelete();
            for (int i = 0; i < elements.length; ++i) {
                JavaClass clzz;
                Resource res;
                FileObject fo;
                Project project;
                if (!(elements[i] instanceof JavaClass) || (project = FileOwnerQuery.getOwner((FileObject)(fo = JavaModel.getFileObject((Resource)(res = (clzz = (JavaClass)elements[i]).getResource()))))) == null || !(project instanceof NbModuleProject)) continue;
                this.checkMetaInfServices(project, clzz, refactoringElements);
                this.checkManifest((NbModuleProject)project, clzz, refactoringElements);
                this.checkLayer((NbModuleProject)project, clzz, refactoringElements);
            }
            err.log("Gonna return problem: " + problem);
            Problem problem2 = problem;
            return problem2;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(JavaClass clazz, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return new ManifestSafeDeleteRefactoringElement(clazz, manifestFile, attributeValue, attributeKey, section);
    }

    protected RefactoringElementImplementation createMetaInfServicesRefactoring(JavaClass clazz, FileObject serviceFile, int line) {
        return new ServicesSafeDeleteRefactoringElement(clazz, serviceFile);
    }

    protected RefactoringElementImplementation createLayerRefactoring(Constructor constructor, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return new LayerSafeDeleteRefactoringElement(constructor.getName(), handle, layerFileObject);
    }

    protected RefactoringElementImplementation createLayerRefactoring(JavaClass clazz, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return new LayerSafeDeleteRefactoringElement(clazz.getSimpleName(), handle, layerFileObject, layerAttribute);
    }

    protected RefactoringElementImplementation createLayerRefactoring(Method method, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return new LayerSafeDeleteRefactoringElement(method.getName(), handle, layerFileObject);
    }

    public final class LayerSafeDeleteRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private File parent;
        private FileObject layerFO;
        private LayerUtils.LayerHandle handle;
        private String attribute;

        public LayerSafeDeleteRefactoringElement(String name, LayerUtils.LayerHandle handle, FileObject layerFo, String attr) {
            this(name, handle, layerFo);
            this.attribute = attr;
        }

        public LayerSafeDeleteRefactoringElement(String name, LayerUtils.LayerHandle handle, FileObject layerFo) {
            this.name = name;
            this.handle = handle;
            this.parentFile = handle.getLayerFile();
            this.parent = FileUtil.toFile((FileObject)this.parentFile);
            this.layerFO = layerFo;
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin = NbSafeDeleteRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbSafeDeleteRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin), (String)"TXT_LayerDelete", (Object)this.name);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                if (this.attribute != null) {
                    this.layerFO.setAttribute(this.attribute, null);
                    if ("originalFile".equals(this.attribute)) {
                        this.layerFO.delete();
                    }
                } else {
                    this.layerFO.delete();
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        public void undoExternalChange() {
        }
    }

    public final class ServicesSafeDeleteRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private String oldName;
        private String oldContent;
        private File parent;

        public ServicesSafeDeleteRefactoringElement(JavaClass clazz, FileObject file) {
            this.name = clazz.getSimpleName();
            this.parentFile = file;
            this.oldName = clazz.getName();
            this.oldContent = Utility.readFileIntoString(this.parentFile);
            this.parent = FileUtil.toFile((FileObject)this.parentFile);
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin = NbSafeDeleteRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbSafeDeleteRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin), (String)"TXT_ServicesDelete", (Object)this.name);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            String content = Utility.readFileIntoString(this.parentFile);
            if (content != null) {
                String longName = this.oldName;
                longName = longName.replaceAll("[.]", "\\.");
                content = content.replaceAll("^" + longName + "[ \\\n]?", "");
                boolean hasMoreThanComments = false;
                StringTokenizer tok = new StringTokenizer(content, "\n");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken().trim();
                    if (token.length() <= 0 || Pattern.matches("^[#].*", token)) continue;
                    hasMoreThanComments = true;
                    break;
                }
                if (hasMoreThanComments) {
                    Utility.writeFileFromString(this.parentFile, content);
                } else {
                    try {
                        this.parentFile.delete();
                    }
                    catch (IOException exc) {
                        AbstractRefactoringPlugin.err.notify((Throwable)exc);
                    }
                }
            }
        }

        public void undoExternalChange() {
            try {
                if (this.oldContent != null) {
                    FileObject fo;
                    if (!this.parent.exists() && (fo = FileUtil.toFileObject((File)this.parent.getParentFile())) != null) {
                        this.parentFile = fo.createData(this.parent.getName());
                    }
                    Utility.writeFileFromString(this.parentFile, this.oldContent);
                }
            }
            catch (IOException exc) {
                AbstractRefactoringPlugin.err.notify((Throwable)exc);
            }
        }
    }

    public final class ManifestSafeDeleteRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private JavaClass clazz;
        private String attrName;
        private String sectionName = null;
        private String oldName;
        private String oldContent;

        public ManifestSafeDeleteRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName) {
            this.name = attributeValue;
            this.clazz = clazz;
            this.parentFile = parentFile;
            this.attrName = attributeName;
            this.oldName = clazz.getName();
            this.oldContent = Utility.readFileIntoString(parentFile);
        }

        public ManifestSafeDeleteRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName, String secName) {
            this(clazz, parentFile, attributeValue, attributeName);
            this.sectionName = secName;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin = NbSafeDeleteRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbSafeDeleteRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin), (String)"TXT_ManifestSectionDelete", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin = NbSafeDeleteRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbSafeDeleteRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbSafeDeleteRefactoringPlugin), (String)"TXT_ManifestDelete", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performExternalChange() {
            FileLock lock = null;
            OutputStream stream = null;
            InputStream instream = null;
            try {
                instream = this.parentFile.getInputStream();
                EditableManifest manifest = new EditableManifest(instream);
                instream.close();
                instream = null;
                if (this.sectionName != null) {
                    manifest.removeSection(this.name);
                } else {
                    manifest.removeAttribute(this.attrName, null);
                }
                lock = this.parentFile.lock();
                stream = this.parentFile.getOutputStream(lock);
                manifest.write(stream);
            }
            catch (FileNotFoundException ex) {
                AbstractRefactoringPlugin.err.notify((Throwable)ex);
            }
            catch (IOException exc) {
                AbstractRefactoringPlugin.err.notify((Throwable)exc);
            }
            finally {
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        AbstractRefactoringPlugin.err.notify((Throwable)ex);
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        AbstractRefactoringPlugin.err.notify((Throwable)ex);
                    }
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        public void undoExternalChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }
}

