/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class BindingPanel
extends SaveableSectionInnerPanel {
    private Binding binding;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private BindingActionListener actionListener;
    private Definitions primaryDefinitions;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingPanel(SectionView view, Binding binding, Definitions primaryDefinitions) {
        super(view);
        this.binding = binding;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.binding.getModel();
        this.initComponents();
        this.enableMIMEContentCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
        this.modelListener = new ModelChangeListener();
        WSDLModel primaryModel = primaryDefinitions.getModel();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)primaryModel);
        primaryModel.addPropertyChangeListener(pcl);
        this.actionListener = new BindingActionListener();
        ActionListener al = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.actionListener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(al);
    }

    private boolean getMIMEContentOfParent() {
        DefinitionsCustomization dc;
        EnableMIMEContent mimeContent;
        List dcs = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (mimeContent = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableMIMEContent()) != null) {
            return mimeContent.isEnabled();
        }
        return false;
    }

    private void sync() {
        List ee = this.binding.getExtensibilityElements(BindingCustomization.class);
        if (ee.size() == 1) {
            BindingCustomization bc = (BindingCustomization)ee.get(0);
            EnableMIMEContent emc = bc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.binding.getExtensibilityElements(BindingCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.enableMIMEContentCB) {
            if (ee.size() > 0) {
                BindingCustomization bc = (BindingCustomization)ee.get(0);
                EnableMIMEContent emc = bc.getEnableMIMEContent();
                if (emc == null) {
                    try {
                        this.model.startTransaction();
                        emc = factory.createEnableMIMEContent(this.model);
                        emc.setEnabled(this.getEnableMIMEContent());
                        bc.setEnableMIMEContent(emc);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                BindingCustomization bc = factory.createBindingCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent());
                    bc.setEnableMIMEContent(emc);
                    this.binding.addExtensibilityElement((ExtensibilityElement)bc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setActionCommand(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setLabel(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.enableMIMEContentCB).addContainerGap(301, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(25, 25, 25).add((Component)this.enableMIMEContentCB).addContainerGap(28, Short.MAX_VALUE)));
    }

    class BindingActionListener
    implements ActionListener {
        BindingActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            BindingPanel.this.setValue((JComponent)e.getSource(), null);
        }
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            EnableMIMEContent emc;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableMIMEContent && (parent = (WSDLComponent)(emc = (EnableMIMEContent)source).getParent()) instanceof DefinitionsCustomization) {
                BindingPanel.this.sync();
            }
        }
    }
}

