/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.ModelProvider;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class CellRenderer
extends DefaultTreeCellRenderer
implements ListCellRenderer,
TreeCellRenderer {
    private static Color unfocusedSelFg;
    private static Color unfocusedSelBg;
    private boolean inSetContainerWidth = false;
    private int containerWidth = 50;
    private boolean widthChanged = true;
    private int scrollPaneWidth = -1;
    private int charCount = 20;
    private int charWidth = 8;
    private static final Color relatedColor;
    private static final Color relatedBorder;
    private RelatedItemProvider provider = null;
    private boolean related;
    private boolean primary = false;
    private boolean showDragFeedback = false;
    private boolean renderingCombo = false;
    private boolean selected = false;
    private boolean lead = false;
    private boolean focused = false;
    private boolean tree = false;
    private static Graphics scratch;
    private WeightedString str = null;
    private static final Icon WAIT_ICON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContainerWidth(JComponent jc) {
        if (this.inSetContainerWidth) {
            return;
        }
        this.inSetContainerWidth = true;
        try {
            this.setContainerWidth(jc.getWidth());
        }
        finally {
            this.inSetContainerWidth = false;
        }
    }

    private void setContainerWidth(int i) {
        if (this.containerWidth != i) {
            this.containerWidth = i;
            this.widthChanged = true;
        }
    }

    private void setScrollPaneWidth(JComponent jc) {
        Container scrollPane = jc.getParent();
        if (scrollPane != null) {
            scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, jc.getParent());
        }
        if (scrollPane != null) {
            int newWidth = scrollPane.getWidth();
            boolean bl = this.widthChanged = this.scrollPaneWidth != newWidth;
            if (this.widthChanged) {
                this.scrollPaneWidth = newWidth;
            }
        } else {
            boolean bl = this.widthChanged = this.scrollPaneWidth != -1;
            if (this.widthChanged) {
                this.scrollPaneWidth = -1;
            }
        }
    }

    private void calcCharCount(Graphics g, FontMetrics fm) {
        int calcWidth = this.scrollPaneWidth == -1 ? this.containerWidth : this.scrollPaneWidth;
        int wid = calcWidth - this.getIconTextGap();
        String test = "abcdefghkmnopqrstuvwxyzABCDEFG";
        int swidth = fm.stringWidth(test);
        this.charWidth = swidth / test.length();
        this.charCount = Math.max(5, wid / this.charWidth);
        this.widthChanged = false;
    }

    private boolean isSelected() {
        return this.selected;
    }

    private boolean isParentFocused() {
        return this.focused && !this.renderingCombo;
    }

    private void setSelected(boolean val) {
        this.selected = val;
    }

    private void setLead(boolean val) {
        this.lead = val;
    }

    private void setParentFocused(boolean val) {
        this.focused = val;
    }

    private void setRenderingCombo(boolean val) {
        this.renderingCombo = val;
    }

    public Color getBackground() {
        return this.renderingCombo && !this.isSelected() ? null : super.getBackground();
    }

    public Color getBackgroundNonSelectionColor() {
        if (this.renderingCombo) {
            return this.isSelected() ? this.getBackgroundSelectionColor() : null;
        }
        return super.getBackgroundNonSelectionColor();
    }

    private void setRelatedItemProvider(RelatedItemProvider p) {
        this.provider = p;
    }

    private boolean isRelated() {
        return this.related && !this.isSelected();
    }

    private void setRelated(boolean val) {
        this.related = val;
    }

    private void setPrimary(boolean val) {
        this.primary = val;
    }

    private boolean isTree() {
        return this.tree;
    }

    private void setTree(boolean val) {
        this.tree = val;
    }

    void setShowDragFeedback(boolean val) {
        this.showDragFeedback = val;
    }

    private boolean isShowDragFeedback() {
        return this.showDragFeedback;
    }

    public Component getListCellRendererComponent(JList jList, Object obj, int idx, boolean sel, boolean lead) {
        this.str = null;
        this.setSelected(sel);
        this.setLead(lead);
        this.setParentFocused(jList.hasFocus());
        if (jList.getModel() instanceof DisplayProvider) {
            if (jList.getModel() instanceof RelatedItemProvider) {
                this.setRelatedItemProvider((RelatedItemProvider)((Object)jList.getModel()));
            }
            this.configureFrom((DisplayProvider)((Object)jList.getModel()), obj);
            this.setContainerWidth(jList);
            if (this.shouldAbbreviate()) {
                this.setScrollPaneWidth(jList);
            }
        } else if (obj instanceof ModelProvider) {
            this.setText(((ModelProvider)obj).getDisplayName());
            this.setIcon(null);
        } else {
            this.setText(obj == null ? "" : obj.toString());
            this.setIcon(null);
        }
        this.setRenderingCombo(jList.getModel() instanceof ComboBoxModel);
        if (sel) {
            this.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setFont(jList.getFont());
        this.setTree(false);
        return this;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = new Font(font.getName(), font.getStyle(), font.getSize());
        }
        super.setFont(font);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object obj, boolean sel, boolean exp, boolean leaf, int row, boolean lead) {
        this.str = null;
        this.setSelected(sel);
        this.setLead(lead);
        this.setParentFocused(jTree.hasFocus());
        this.setRenderingCombo(false);
        if (jTree.getModel() instanceof DisplayProvider) {
            if (jTree.getModel() instanceof RelatedItemProvider) {
                this.setRelatedItemProvider((RelatedItemProvider)((Object)jTree.getModel()));
            }
            this.configureFrom((DisplayProvider)((Object)jTree.getModel()), obj);
            this.setContainerWidth(jTree);
        } else {
            this.setText(obj == null ? "" : obj.toString());
            this.setIcon(null);
        }
        if (sel) {
            this.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setFont(jTree.getFont());
        this.setTree(true);
        return this;
    }

    private void configureFrom(DisplayProvider dp, Object obj) {
        if (AbstractModel.isWaitMarker(obj)) {
            this.setText(NbBundle.getMessage((Class)CellRenderer.class, (String)"MSG_PleaseWait"));
            this.setIcon(WAIT_ICON);
        } else if (AbstractModel.isInvalidMarker(obj)) {
            this.setText(NbBundle.getMessage((Class)CellRenderer.class, (String)"MSG_Invalid"));
            this.setIcon(null);
        } else {
            this.setIcon(dp.getIcon(obj));
            this.setWeightedString(dp.getName(obj));
        }
        if (this.provider != null) {
            this.setRelated(this.provider.isRelated(obj));
            this.setPrimary(this.provider.isPrimary(obj));
        }
    }

    public Dimension getPreferredSize() {
        String s;
        if (this.isTree()) {
            boolean pad = false;
            if (this.str != null) {
                this.setText(this.str.toString());
                int markup = this.str.allMarkupTypes();
                if ((markup & 2) != 0 || (markup & 0x80) != 0) {
                    pad = true;
                }
            }
            Dimension d = super.getPreferredSize();
            ++d.width;
            if (pad) {
                d.width = (int)((float)d.width * 1.15f);
            }
            return d;
        }
        String string = s = this.str == null ? this.getText() : this.str.toString();
        if (s == null) {
            return new Dimension(16, 100);
        }
        Font f = this.getFont();
        if (f == null) {
            f = UIManager.getFont("controlFont");
        }
        FontMetrics fm = scratch.getFontMetrics(f);
        int w = (this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() : 0) + fm.stringWidth(s);
        Dimension result = new Dimension(w += 8, Math.max(16, fm.getHeight()));
        if (this.isTree()) {
            result.width = this.containerWidth - this.getLocation().x + (this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() : 0);
        }
        return result;
    }

    private void setWeightedString(WeightedString as) {
        this.str = as;
    }

    public void paint(Graphics g) {
        if (this.str == null) {
            super.paint(g);
        } else {
            Icon ic = this.getIcon();
            Insets ins = this.getInsets();
            int x = ins.left;
            if (ic != null) {
                x += ic.getIconWidth() + this.getIconTextGap();
            }
            boolean selected = this.isSelected();
            boolean parentFocused = this.isParentFocused();
            if (this.isShowDragFeedback() && selected) {
                g.setColor(this.getForeground());
                g.drawLine(0, 0, this.containerWidth, 0);
            } else if (this.isRelated()) {
                g.setColor(relatedColor);
                g.fillRoundRect(2, 1, this.containerWidth - 5, this.getHeight() - 2, 16, 16);
                g.setColor(relatedBorder);
                g.drawRoundRect(2, 1, this.containerWidth - 5, this.getHeight() - 2, 16, 16);
            } else if (parentFocused) {
                Color borderSel;
                g.setColor(selected ? this.getOurBackgroundSelectionColor() : this.getOurBackgroundNonSelectionColor());
                g.fillRect(this.isTree() ? x : 0, 0, this.containerWidth - ((this.isTree() ? x : 0) + 1), this.getHeight() - 1);
                if (selected && (borderSel = this.getBorderSelectionColor()) != null) {
                    g.setColor(borderSel);
                    if (this.isTree()) {
                        g.drawRect(x, 0, this.getWidth() - (x + 1), this.getHeight() - 1);
                    } else {
                        g.drawRect(0, 0, this.containerWidth - 1, this.getHeight() - 1);
                    }
                }
            } else {
                Color bgNonSelection = this.getOurBackgroundNonSelectionColor();
                g.setColor(selected ? CellRenderer.getUnfocusedSelectionBackground(bgNonSelection) : bgNonSelection);
                g.fillRect(this.isTree() ? x : 0, 0, this.containerWidth - ((this.isTree() ? x : 0) + 1), this.getHeight() - 1);
            }
            if (ic != null) {
                ic.paintIcon(this, g, ins.left, ins.top);
            }
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            if (this.widthChanged) {
                this.calcCharCount(g, fm);
            }
            int fheight = g.getFontMetrics().getHeight();
            int y = ins.top + g.getFontMetrics().getMaxAscent();
            int h = this.getHeight() - (ins.top + ins.bottom);
            if (fheight < h) {
                y += (h - fheight) / 2;
            }
            if (parentFocused) {
                g.setColor(selected ? this.getOurTextSelectionColor() : this.getOurTextNonSelectionColor());
            } else {
                g.setColor(selected ? CellRenderer.getUnfocusedSelectionForeground() : this.getOurTextNonSelectionColor());
            }
            int cc = this.shouldAbbreviate() ? this.charCount : Integer.MAX_VALUE;
            this.str.getPainter().paint(g, x, y, this.str, cc, !this.isSelected());
        }
        this.setRelatedItemProvider(null);
        this.setRelated(false);
        this.setPrimary(false);
    }

    private boolean shouldAbbreviate() {
        if (this.isTree()) {
            return false;
        }
        return Boolean.getBoolean("navigator.string.abbrevs");
    }

    private Color getOurBackgroundSelectionColor() {
        Color result = this.getBackgroundSelectionColor();
        if (result == null) {
            result = Color.blue;
        }
        return result;
    }

    private Color getOurBackgroundNonSelectionColor() {
        Color result = this.getBackgroundNonSelectionColor();
        if (result == null) {
            result = Color.white;
        }
        return result;
    }

    private Color getOurTextSelectionColor() {
        Color result = this.getTextSelectionColor();
        if (result == null) {
            result = Color.white;
        }
        return result;
    }

    private Color getOurTextNonSelectionColor() {
        Color result = this.getTextNonSelectionColor();
        if (result == null) {
            result = Color.black;
        }
        return result;
    }

    private static Color getUnfocusedSelectionBackground(Color bgNonSelection) {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!bgNonSelection.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public void firePropertyChange(String s, Object a, Object b) {
    }

    static {
        relatedColor = new Color(255, 240, 205);
        relatedBorder = new Color(255, 215, 207);
        scratch = new BufferedImage(2, 2, 2).getGraphics();
        WAIT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif"));
    }
}

