/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener {
    private static Log log = LogFactory.getLog((Class)PersistentManagerBase.class);
    private static final String info = "PersistentManagerBase/1.1";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected int maxActiveSessions = -1;
    private static String name = "PersistentManagerBase";
    protected boolean started = false;
    protected Store store = null;
    protected boolean saveOnRestart = true;
    protected int maxIdleBackup = -1;
    protected int minIdleSwap = -1;
    protected int maxIdleSwap = -1;
    protected int rejectedSessions = 0;
    protected long processingTime = 0L;

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", new Integer(oldBackup), new Integer(this.maxIdleBackup));
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", new Integer(oldMaxIdleSwap), new Integer(this.maxIdleSwap));
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", new Integer(oldMinIdleSwap), new Integer(this.minIdleSwap));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String getInfo() {
        return info;
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e) {
            log.error((Object)("checking isLoaded for id, " + id + ", " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public String getName() {
        return name;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager((Manager)this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", new Boolean(oldSaveOnRestart), new Boolean(this.saveOnRestart));
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception clearing the Store: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception clearing the Store: " + e));
            e.printStackTrace();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].isValid()) continue;
            ++this.expiredSessions;
            ++expireHere;
        }
        this.processPersistenceChecks();
        if (this.getStore() != null && this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
        long timeEnd = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public void removeSuper(Session session) {
        super.remove(session);
    }

    public void load() {
        this.sessions.clear();
        if (this.store == null) {
            return;
        }
        String[] ids = null;
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    ids = (String[])AccessController.doPrivileged(new PrivilegedStoreKeys());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during load: " + exception));
                    exception.printStackTrace();
                }
            } else {
                ids = this.store.keys();
            }
        }
        catch (IOException e) {
            log.error((Object)("Can't load sessions from store, " + e.getMessage()), (Throwable)e);
            return;
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.loading", (Object)String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapIn(ids[i]);
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Failed load session from store, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void remove(Session session) {
        super.remove(session);
        if (this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    protected void removeSession(String id) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during removeSession: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.remove(id);
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception removing session  " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.unloading", (Object)String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapOut(sessions[i]);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected Session swapIn(String id) throws IOException {
        Session session;
        block11: {
            if (this.store == null) {
                return null;
            }
            session = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        session = (Session)AccessController.doPrivileged(new PrivilegedStoreLoad(id));
                        break block11;
                    }
                    catch (PrivilegedActionException ex) {
                        Exception exception = ex.getException();
                        log.error((Object)("Exception in the Store during swapIn: " + exception));
                        if (exception instanceof IOException) {
                            throw (IOException)exception;
                        }
                        if (exception instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)exception;
                        }
                        break block11;
                    }
                }
                session = this.store.load(id);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)sm.getString("persistentManager.deserializeError", (Object)id, (Object)e));
                throw new IllegalStateException(sm.getString("persistentManager.deserializeError", (Object)id, (Object)e));
            }
        }
        if (session == null) {
            return null;
        }
        if (!session.isValid()) {
            log.error((Object)"session swapped in is invalid or expired");
            session.expire();
            this.removeSession(id);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.swapIn", (Object)id));
        }
        session.setManager((Manager)this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        session.endAccess();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during writeSession: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e) {
            log.error((Object)sm.getString("persistentManager.serializeError", (Object)session.getIdInternal(), (Object)e));
            throw e;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            log.info((Object)sm.getString("standardManager.alreadyStarted"));
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Force random number initialization starting");
        }
        String dummy = this.generateSessionId();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Force random number initialization completed");
        }
        if (this.store == null) {
            log.error((Object)"No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)this.store).start();
        }
    }

    public void stop() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        if (!this.isStarted()) {
            log.info((Object)sm.getString("standardManager.notStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)this.getStore()).stop();
        }
        this.random = null;
        if (this.initialized) {
            this.destroy();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("standardManager.sessionTimeout", (Object)event.getNewValue().toString()));
            }
        }
    }

    protected void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleSwap || timeIdle <= this.minIdleSwap) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("persistentManager.swapMaxIdle", (Object)session.getIdInternal(), (Object)new Integer(timeIdle)));
                }
                try {
                    this.swapOut((Session)session);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    protected void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.tooManyActive", (Object)new Integer(sessions.length)));
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < sessions.length && toswap > 0; ++i) {
            int timeIdle = (int)((timeNow - sessions[i].getLastAccessedTime()) / 1000L);
            if (timeIdle <= this.minIdleSwap) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("persistentManager.swapTooManyActive", (Object)sessions[i].getIdInternal(), (Object)new Integer(timeIdle)));
            }
            try {
                this.swapOut(sessions[i]);
            }
            catch (IOException e) {
                // empty catch block
            }
            --toswap;
        }
    }

    protected void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleBackup) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("persistentManager.backupMaxIdle", (Object)session.getIdInternal(), (Object)new Integer(timeIdle)));
                }
                try {
                    this.writeSession((Session)session);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction {
        PrivilegedStoreKeys() {
        }

        public Object run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction {
        private String id;

        PrivilegedStoreLoad(String id) {
            this.id = id;
        }

        public Object run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction {
        private String id;

        PrivilegedStoreRemove(String id) {
            this.id = id;
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction {
        PrivilegedStoreClear() {
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }
}

