/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;

public final class JMIUtils {
    public static List getAllClasses(Resource res) throws JmiException {
        LinkedList l = new LinkedList();
        Iterator it = res.getClassifiers().iterator();
        while (it.hasNext()) {
            JMIUtils.addAllClasses((JavaClass)it.next(), l);
        }
        return l;
    }

    public static String multipartIdToName(MultipartId id) {
        LinkedList<String> list = new LinkedList<String>();
        while (id != null) {
            if (id.getTypeArguments().size() > 0) {
                return "java.lang.Object";
            }
            list.addFirst(id.getName());
            id = id.getParent();
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private static void addAllClasses(JavaClass jc, List container) throws JmiException {
        container.add(jc);
        Iterator it = jc.getFeatures().iterator();
        while (it.hasNext()) {
            Object feature = it.next();
            if (!(feature instanceof JavaClass)) continue;
            JMIUtils.addAllClasses((JavaClass)feature, container);
        }
    }
}

