/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.WrappedTextView;

class ExtPlainView
extends PlainView {
    private final Segment SEGMENT = new Segment();
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static Map hintsMap = null;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    ExtPlainView(Element elem) {
        super(elem);
    }

    public void paint(Graphics g, Shape allocation) {
        ((Graphics2D)g).addRenderingHints(ExtPlainView.getHints());
        super.paint(g, allocation);
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof OutputDocument) {
            Segment s = SwingUtilities.isEventDispatchThread() ? this.SEGMENT : new Segment();
            doc.getText(p0, p1 - p0, s);
            g.setColor(ExtPlainView.getColorForLocation(p0, doc, true));
            int ret = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
            if (g.getColor() == WrappedTextView.selectedLinkFg || g.getColor() == WrappedTextView.selectedImportantLinkFg) {
                this.underline(g, s, x, p0, y);
            }
            return ret;
        }
        return super.drawUnselectedText(g, x, y, p0, p1);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof OutputDocument) {
            Segment s = SwingUtilities.isEventDispatchThread() ? this.SEGMENT : new Segment();
            doc.getText(p0, p1 - p0, s);
            g.setColor(ExtPlainView.getColorForLocation(p0, doc, false));
            int ret = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
            if (g.getColor() == WrappedTextView.selectedLinkFg || g.getColor() == WrappedTextView.selectedImportantLinkFg) {
                this.underline(g, s, x, p0, y);
            }
            return ret;
        }
        return super.drawUnselectedText(g, x, y, p0, p1);
    }

    private void underline(Graphics g, Segment s, int x, int p0, int y) {
        int end;
        int wid = g.getFontMetrics().charWidth(' ');
        char[] txt = s.array;
        int txtOffset = s.offset;
        int txtCount = s.count;
        int n = s.offset + s.count;
        int tabCount = 0;
        int wsCount = 0;
        for (int i = s.offset; i < n; ++i) {
            if (txt[i] == '\t') {
                x = (int)this.nextTabStop(x, p0 + i - txtOffset);
                ++tabCount;
                continue;
            }
            if (!Character.isWhitespace(txt[i])) break;
            x += wid;
            ++wsCount;
        }
        if ((end = x + wid * (txtCount - (wsCount + tabCount + 1))) > x) {
            g.drawLine(x, y + 1, end, y + 1);
        }
    }

    private static Color getColorForLocation(int start, Document d, boolean selected) {
        OutputDocument od = (OutputDocument)d;
        int line = od.getElementIndex(start);
        boolean hyperlink = od.getLines().isHyperlink(line);
        boolean important = hyperlink ? od.getLines().isImportantHyperlink(line) : false;
        boolean isErr = od.getLines().isErr(line);
        return hyperlink ? (important ? (selected ? WrappedTextView.selectedImportantLinkFg : WrappedTextView.unselectedImportantLinkFg) : (selected ? WrappedTextView.selectedLinkFg : WrappedTextView.unselectedLinkFg)) : (selected ? (isErr ? WrappedTextView.selectedErr : WrappedTextView.selectedFg) : (isErr ? WrappedTextView.unselectedErr : WrappedTextView.unselectedFg));
    }
}

