/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.clazz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsIdClassPred;

public class AllFieldsOfIdClassDefinedInEntity
extends AbstractRule {
    private List<String> missingFieldNames = new ArrayList<String>();

    public AllFieldsOfIdClassDefinedInEntity() {
        super(null, Arrays.asList(new AnnotatedAsIdClassPred()));
    }

    public String getId() {
        return "AllFieldsOfIdClassDefinedInEntity";
    }

    protected String getMessageKey() {
        return "MSG_MissingIdField";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && ctx.getBeanAccessType() == BeanAccessType.FIELD && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            JavaClass idClass = PersistenceAPIHelper.getIdClass(javaClass);
            if (idClass == null) {
                return null;
            }
            for (ClassMember cm : idClass.getContents()) {
                Field idField;
                if (!(cm instanceof Field) || javaClass.getField((idField = (Field)Field.class.cast(cm)).getName(), false) != null) continue;
                this.missingFieldNames.add(idField.getName());
            }
            if (!this.missingFieldNames.isEmpty()) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }

    protected Object[] getMessageParameters() {
        StringBuilder sb = new StringBuilder();
        for (String f : this.missingFieldNames) {
            sb.append(f).append(" ");
        }
        Object[] result = new Object[]{sb.toString()};
        return result;
    }

    public void reset() {
        this.missingFieldNames.clear();
    }
}

