/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.nodes;

import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import java.util.Iterator;
import javax.swing.Action;
import org.netbeans.modules.websvc.api.registry.WebServiceMethod;
import org.netbeans.modules.websvc.registry.actions.TestWebServiceMethodAction;
import org.netbeans.modules.websvc.registry.nodes.WebServicesNode;
import org.netbeans.modules.websvc.registry.util.Util;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WebServiceMethodNode
extends AbstractNode
implements WebServiceMethod {
    private JavaMethod javaMethod;
    private Port port;

    public WebServiceMethodNode() {
        this(null, null);
    }

    public Object getJavaMethod() {
        return this.javaMethod;
    }

    public WebServiceMethodNode(Port inPort, Operation inOperation) {
        super(Children.LEAF);
        this.port = inPort;
        if (null == inOperation) {
            return;
        }
        this.javaMethod = inOperation.getJavaMethod();
        this.setName(this.javaMethod.getName());
        this.setIconBaseWithExtension("org/netbeans/modules/websvc/registry/resources/methodicon.png");
        String signature = this.javaMethod.getReturnType().getFormalName() + " " + this.javaMethod.getName() + "(";
        Iterator parameterIterator = this.javaMethod.getParameters();
        JavaParameter currentParam = null;
        while (parameterIterator.hasNext()) {
            currentParam = (JavaParameter)parameterIterator.next();
            String parameterType = Util.getParameterType(inPort, currentParam);
            signature = signature + parameterType + " " + currentParam.getName();
            if (!parameterIterator.hasNext()) continue;
            signature = signature + ", ";
        }
        signature = signature + ")";
        this.setShortDescription(signature);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(TestWebServiceMethodAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get(TestWebServiceMethodAction.class);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ss = sheet.get("data");
        if (ss == null) {
            ss = new Sheet.Set();
            ss.setName("data");
            ss.setDisplayName(NbBundle.getMessage(WebServiceMethodNode.class, (String)"METHOD_INFO"));
            ss.setShortDescription(NbBundle.getMessage(WebServiceMethodNode.class, (String)"METHOD_INFO"));
            sheet.put(ss);
        }
        try {
            Sheet.Set exceptionSet;
            Iterator paramIterator;
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)this.javaMethod, String.class, "getName", null);
            p.setName("name");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_NAME"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_NAME"));
            ss.put((Node.Property)p);
            String signature = this.javaMethod.getReturnType().getRealName() + " " + this.javaMethod.getName() + "(";
            Iterator tempIterator = this.javaMethod.getParameters();
            JavaParameter currentparam = null;
            while (tempIterator.hasNext()) {
                currentparam = (JavaParameter)tempIterator.next();
                signature = signature + currentparam.getType().getRealName() + " " + currentparam.getName();
                if (!tempIterator.hasNext()) continue;
                signature = signature + ", ";
            }
            signature = signature + ")";
            Iterator excpIterator = this.javaMethod.getExceptions();
            if (excpIterator.hasNext()) {
                signature = signature + " throws";
                while (excpIterator.hasNext()) {
                    String currentExcp = (String)excpIterator.next();
                    signature = signature + " " + currentExcp;
                    if (!excpIterator.hasNext()) continue;
                    signature = signature + ",";
                }
            }
            p = new PropertySupport.Reflection((Object)signature, String.class, "toString", null);
            p.setName("signature");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_SIGNATURE"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_SIGNATURE"));
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)this.javaMethod.getReturnType(), String.class, "getRealName", null);
            p.setName("returntype");
            p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_RETURNTYPE"));
            p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_RETURNTYPE"));
            ss.put((Node.Property)p);
            Sheet.Set paramSet = sheet.get("parameters");
            if (paramSet == null) {
                paramSet = new Sheet.Set();
                paramSet.setName("parameters");
                paramSet.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMDIVIDER"));
                paramSet.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMDIVIDER"));
                sheet.put(paramSet);
            }
            if ((paramIterator = this.javaMethod.getParameters()).hasNext()) {
                p = new PropertySupport.Reflection((Object)NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMTYPE"), String.class, "toString", null);
                p.setName("paramdivider2");
                p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMNAME"));
                p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMNAME") + "-" + NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMTYPE"));
                paramSet.put((Node.Property)p);
                JavaParameter currentParameter = null;
                int ii = 0;
                while (paramIterator.hasNext()) {
                    currentParameter = (JavaParameter)paramIterator.next();
                    p = currentParameter.getType().isHolder() ? new PropertySupport.Reflection((Object)Util.getParameterType(this.port, currentParameter), String.class, "toString", null) : new PropertySupport.Reflection((Object)currentParameter.getType(), String.class, "getRealName", null);
                    p.setName("paramname" + ii);
                    p.setDisplayName(currentParameter.getName());
                    p.setShortDescription(currentParameter.getName() + "-" + currentParameter.getType().getRealName());
                    paramSet.put((Node.Property)p);
                    ++ii;
                }
            }
            if ((exceptionSet = sheet.get("exceptions")) == null) {
                exceptionSet = new Sheet.Set();
                exceptionSet.setName("exceptions");
                exceptionSet.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                exceptionSet.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                sheet.put(exceptionSet);
            }
            Iterator exceptionIterator = this.javaMethod.getExceptions();
            String currentException = null;
            int ii = 0;
            while (exceptionIterator.hasNext()) {
                currentException = (String)exceptionIterator.next();
                p = new PropertySupport.Reflection((Object)currentException, String.class, "toString", null);
                p.setName("exception" + ii);
                p.setDisplayName(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMTYPE"));
                p.setShortDescription(NbBundle.getMessage(WebServicesNode.class, (String)"METHOD_PARAMTYPE"));
                exceptionSet.put((Node.Property)p);
                ++ii;
            }
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        return sheet;
    }
}

