/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.ui.TargetMappingPanel;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectCustomizer
extends JPanel
implements HelpCtx.Provider {
    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private List panels;
    private AntProjectHelper helper;
    private FreeformProject project;
    private DialogDescriptor dialogDescriptor;
    private static final String GENERAL_ICON = "general.gif";
    private JPanel categoryPanel;
    private JPanel customizerPanel;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public ProjectCustomizer(FreeformProject project, AntProjectHelper helper) {
        this.helper = helper;
        this.project = project;
        this.initComponents();
        HelpCtx.setHelpIDString((JComponent)this.customizerPanel, (String)("org.netbeans.modules.ant.freeform.ui.ProjectCustomizer." + Util.getMergedHelpIDFragments(project)));
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)new CategoryView(this.createRootNode()), this.fillConstraints);
    }

    void save() {
        Iterator it = this.panels.iterator();
        while (it.hasNext()) {
            ProjectPropertiesPanel panel = (ProjectPropertiesPanel)it.next();
            panel.storeValues();
        }
    }

    private void initComponents() {
        this.categoryPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.customizerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer"));
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(new EtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.categoryPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSN_ProjectCustomizer_categoryPanel"));
        this.categoryPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer_categoryPanel"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.customizerPanel, gridBagConstraints);
        this.customizerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSN_ProjectCustomizer_customizerPanel"));
        this.customizerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer_customizerPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 8, 8);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"LBL_Customizer_Categories"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
    }

    public HelpCtx getHelpCtx() {
        if (this.currentCustomizer != null) {
            HelpCtx customizerCtx = HelpCtx.findHelp((Component)this.currentCustomizer);
            if (customizerCtx.getHelpID() != null) {
                return new HelpCtx(customizerCtx.getHelpID() + "." + Util.getMergedHelpIDFragments(this.project));
            }
            return customizerCtx;
        }
        return HelpCtx.findHelp((Component)this.customizerPanel);
    }

    private List getProjectCustomizerPanels() {
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)this.project.getLookup().lookup(AuxiliaryConfiguration.class);
        AntProjectHelper helper = this.project.helper();
        PropertyEvaluator eval = this.project.evaluator();
        ArrayList<TargetMappingPanel.Panel> panels = new ArrayList<TargetMappingPanel.Panel>();
        ArrayList extraTargets = new ArrayList();
        Iterator natures = FreeformProject.PROJECT_NATURES.allInstances().iterator();
        while (natures.hasNext()) {
            ProjectNature pn = (ProjectNature)natures.next();
            panels.addAll(pn.getCustomizerPanels(this.project, helper, eval, aux));
            extraTargets.addAll(pn.getExtraTargets(this.project, helper, eval, aux));
        }
        panels.add(new TargetMappingPanel.Panel(extraTargets, eval, helper));
        Collections.sort(panels, new PanelsComparator());
        return panels;
    }

    private Node createRootNode() {
        String ICON_FOLDER = "org/netbeans/modules/ant/freeform/resources/";
        ResourceBundle bundle = NbBundle.getBundle((Class)ProjectCustomizer.class);
        ArrayList<ConfigurationDescription> l = new ArrayList<ConfigurationDescription>();
        this.panels = this.getProjectCustomizerPanels();
        Iterator it = this.panels.iterator();
        while (it.hasNext()) {
            ProjectPropertiesPanel panel = (ProjectPropertiesPanel)it.next();
            ConfigurationDescription cd = new ConfigurationDescription(panel.getDisplayName(), panel.getDisplayName(), ICON_FOLDER + GENERAL_ICON, panel, null);
            l.add(cd);
        }
        ConfigurationDescription rootDescription = new ConfigurationDescription("InvisibleRoot", "InvisibleRoot", null, null, l.toArray(new ConfigurationDescription[l.size()]));
        return new ConfigurationNode(rootDescription);
    }

    private static class ConfigurationChildren
    extends Children.Keys {
        private Collection descriptions;

        public ConfigurationChildren(ConfigurationDescription[] descriptions) {
            this.descriptions = Arrays.asList(descriptions);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new ConfigurationNode((ConfigurationDescription)key)};
        }
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private ProjectPropertiesPanel panel;
        private final String iconResource;

        public ConfigurationNode(ConfigurationDescription description) {
            super((Children)(description.children == null ? Children.LEAF : new ConfigurationChildren(description.children)));
            this.setName(description.name);
            this.setDisplayName(description.displayName);
            this.iconResource = description.iconResource;
            this.panel = description.panel;
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            if (this.panel == null) {
                return null;
            }
            return this.panel.getComponent();
        }

        public Image getIcon(int type) {
            if (this.iconResource != null) {
                return Utilities.loadImage((String)this.iconResource, (boolean)true);
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            if (this.iconResource != null) {
                return Utilities.loadImage((String)this.iconResource, (boolean)true);
            }
            return super.getOpenedIcon(type);
        }
    }

    private static class ConfigurationDescription {
        private String name;
        private String displayName;
        private String iconResource;
        private ProjectPropertiesPanel panel;
        private ConfigurationDescription[] children;

        ConfigurationDescription(String name, String displayName, String iconResource, ProjectPropertiesPanel panel, ConfigurationDescription[] children) {
            this.name = name;
            this.displayName = displayName;
            this.iconResource = iconResource;
            this.panel = panel;
            this.children = children;
        }
    }

    private static class PanelsComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private PanelsComparator() {
        }

        public int compare(Object o1, Object o2) {
            ProjectPropertiesPanel p1 = (ProjectPropertiesPanel)o1;
            ProjectPropertiesPanel p2 = (ProjectPropertiesPanel)o2;
            if (p1.getPreferredPosition() == p2.getPreferredPosition()) {
                return 0;
            }
            return p1.getPreferredPosition() - p2.getPreferredPosition();
        }

        public boolean equals(Object obj) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer == null ? (class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer = ProjectCustomizer.class$("org.netbeans.modules.ant.freeform.ui.ProjectCustomizer")) : class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer).desiredAssertionStatus();
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private BeanTreeView btv;

        CategoryView(Node rootNode) {
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.btv.setDragSource(false);
            this.btv.setDragSource(false);
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(rootNode);
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
            this.selectFirstNode();
            this.btv.expandAll();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void addNotify() {
            super.addNotify();
            this.btv.expandAll();
        }

        private void selectFirstNode() {
            Node[] nodes;
            Children ch = this.manager.getRootContext().getChildren();
            if (ch != null && (nodes = ch.getNodes()) != null && nodes.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodes[0]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] nodes = CategoryView.this.manager.getSelectedNodes();
                    if (nodes == null || nodes.length <= 0) {
                        return;
                    }
                    Node node = nodes[0];
                    if (ProjectCustomizer.this.currentCustomizer != null) {
                        ProjectCustomizer.this.customizerPanel.remove(ProjectCustomizer.this.currentCustomizer);
                    }
                    if (node.hasCustomizer()) {
                        ProjectCustomizer.this.currentCustomizer = node.getCustomizer();
                        ProjectCustomizer.this.customizerPanel.add(ProjectCustomizer.this.currentCustomizer, ProjectCustomizer.this.fillConstraints);
                        ProjectCustomizer.this.customizerPanel.validate();
                        ProjectCustomizer.this.customizerPanel.repaint();
                        if (ProjectCustomizer.this.dialogDescriptor != null) {
                            ProjectCustomizer.this.dialogDescriptor.setHelpCtx(ProjectCustomizer.this.getHelpCtx());
                        }
                    } else {
                        ProjectCustomizer.this.currentCustomizer = null;
                    }
                    return;
                }
            }
        }
    }
}

