/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.actions.ConnectUsingDriverAction;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.util.Mutex;

public final class ConnectionManager {
    private static ConnectionManager DEFAULT;

    public static synchronized ConnectionManager getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ConnectionManager();
        }
        return DEFAULT;
    }

    public DatabaseConnection[] getConnections() {
        org.netbeans.modules.db.explorer.DatabaseConnection[] conns = ConnectionList.getDefault().getConnections();
        DatabaseConnection[] dbconns = new DatabaseConnection[conns.length];
        for (int i = 0; i < conns.length; ++i) {
            dbconns[i] = conns[i].getDatabaseConnection();
        }
        return dbconns;
    }

    public DatabaseConnection getConnection(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        org.netbeans.modules.db.explorer.DatabaseConnection[] conns = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < conns.length; ++i) {
            DatabaseConnection dbconn = conns[i].getDatabaseConnection();
            if (!name.equals(dbconn.getName())) continue;
            return dbconn;
        }
        return null;
    }

    public void addConnection(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnectionNoConnect(dbconn.getDelegate());
    }

    public void showAddConnectionDialog(JDBCDriver driver) {
        this.showAddConnectionDialog(driver, null, null, null);
    }

    public void showAddConnectionDialog(JDBCDriver driver, String databaseUrl) {
        this.showAddConnectionDialog(driver, databaseUrl, null, null);
    }

    public void showAddConnectionDialog(final JDBCDriver driver, final String databaseUrl, final String user, final String password) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(driver, databaseUrl, user, password);
            }
        });
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver) {
        return this.showAddConnectionDialogFromEventThread(driver, null, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver, String databaseUrl) {
        return this.showAddConnectionDialogFromEventThread(driver, databaseUrl, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver, String databaseUrl, String user, String password) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The current thread is not the event dispatching thread.");
        }
        org.netbeans.modules.db.explorer.DatabaseConnection internalDBConn = new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(driver, databaseUrl, user, password);
        if (internalDBConn != null) {
            return internalDBConn.getDatabaseConnection();
        }
        return null;
    }

    public void showConnectionDialog(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        dbconn.getDelegate().showConnectionDialog();
    }

    public void disconnect(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        try {
            dbconn.getDelegate().disconnect();
        }
        catch (DatabaseException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public void selectConnectionInExplorer(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        dbconn.getDelegate().selectInExplorer();
    }

    public void addConnectionListener(ConnectionListener listener) {
        ConnectionList.getDefault().addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        ConnectionList.getDefault().removeConnectionListener(listener);
    }
}

