/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.moveclass.AbstractMoveClassRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class TldMoveClassRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (Resource resource : resources) {
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            WebModule wm = WebModule.getWebModule((FileObject)fo);
            FileObject target = moveClassRefactor.getTargetClassPathRoot();
            WebModule wmNew = null;
            if (target != null) {
                wmNew = WebModule.getWebModule((FileObject)moveClassRefactor.getTargetClassPathRoot());
            }
            if (wm == null) continue;
            boolean moveToAnotherProject = false;
            if (wmNew != null) {
                moveToAnotherProject = !wm.equals((Object)wmNew);
            }
            FileObject webInf = wm.getWebInf();
            Enumeration e = null;
            if (webInf != null) {
                e = webInf.getChildren(true);
            }
            if (e == null) continue;
            while (e.hasMoreElements()) {
                FileObject tld = (FileObject)e.nextElement();
                FileObject tldNew = null;
                if (!this.isTld(tld)) continue;
                DataObject tldData = null;
                DataObject newTldData = null;
                try {
                    tldData = DataObject.find((FileObject)tld);
                }
                catch (DataObjectNotFoundException dne) {
                    // empty catch block
                }
                if (moveToAnotherProject) {
                    FileObject webInfNew = wmNew.getWebInf();
                    Enumeration e2 = null;
                    if (webInfNew != null) {
                        e2 = webInfNew.getChildren(true);
                    }
                    while (e2.hasMoreElements()) {
                        tldNew = (FileObject)e2.nextElement();
                        if (!this.isTld(tldNew)) continue;
                        try {
                            newTldData = DataObject.find((FileObject)tldNew);
                            break;
                        }
                        catch (DataObjectNotFoundException dne) {
                        }
                    }
                    if (newTldData == null) {
                        Problem newProblem = new Problem(false, NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibNotExistMoveClassOtherProjectInvalidProblem"));
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
                if (tldData == null || !(tldData instanceof TLDDataObject)) continue;
                Taglib taglib = null;
                try {
                    taglib = ((TLDDataObject)tldData).getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    List classes = resource.getClassifiers();
                    err.log("Classes in resource: " + classes);
                    for (int j = 0; j < classes.size(); ++j) {
                        ListenerType[] listenerTypes;
                        String validatorClass;
                        ValidatorType validatorType;
                        FunctionType[] functionTypes;
                        AbstractMoveClassRefactoringElement elem;
                        JavaClass jClass = (JavaClass)classes.get(j);
                        err.log("javaclass: " + jClass);
                        String name = jClass.getName();
                        err.log("name: " + name);
                        String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                        err.log("targetPackage: " + targetPackage);
                        String newName = targetPackage + "." + jClass.getSimpleName();
                        err.log("newname: " + newName);
                        TagType[] tagTypes = taglib.getTag();
                        if (tagTypes != null && tagTypes.length > 0) {
                            for (int tt = 0; tt < tagTypes.length; ++tt) {
                                TagType tagT = tagTypes[tt];
                                String tagClass = tagT.getTagClass();
                                String teiClass = tagT.getTeiClass();
                                if (!moveToAnotherProject) {
                                    if (tagClass != null && tagClass.equals(name)) {
                                        elem = new TaglibTagClassMoveClassRefactoringElement(tldData, name, newName);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                    }
                                    if (teiClass == null || !teiClass.equals(name)) continue;
                                    elem = new TaglibTeiClassMoveClassRefactoringElement(tldData, name, newName);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                    continue;
                                }
                                if (newTldData == null) continue;
                                if (tagClass != null && tagClass.equals(name)) {
                                    elem = new TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement(tldData, newTldData, name, newName);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                }
                                if (teiClass == null || !teiClass.equals(name)) continue;
                                elem = new TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement(tldData, newTldData, name, newName);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                        }
                        if ((functionTypes = taglib.getFunction()) != null && functionTypes.length > 0) {
                            for (int tt = 0; tt < functionTypes.length; ++tt) {
                                FunctionType functionT = functionTypes[tt];
                                String functionClass = functionT.getFunctionClass();
                                if (functionClass == null || !functionClass.equals(name)) continue;
                                elem = new TaglibFunctionClassMoveClassRefactoringElement(tldData, name, newName);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                        }
                        if ((validatorType = taglib.getValidator()) != null && (validatorClass = validatorType.getValidatorClass()) != null && validatorClass.equals(name)) {
                            TaglibValidatorClassMoveClassRefactoringElement elem2 = new TaglibValidatorClassMoveClassRefactoringElement(tldData, name, newName);
                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                        }
                        if ((listenerTypes = taglib.getListener()) == null || listenerTypes.length <= 0) continue;
                        for (int tt = 0; tt < listenerTypes.length; ++tt) {
                            ListenerType listenerT = listenerTypes[tt];
                            String listenerClass = listenerT.getListenerClass();
                            if (listenerClass == null || !listenerClass.equals(name)) continue;
                            TaglibListenerClassMoveClassRefactoringElement elem3 = new TaglibListenerClassMoveClassRefactoringElement(tldData, name, newName);
                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                        }
                    }
                    continue;
                }
                Object[] args = new Object[]{tld.getNameExt()};
                String msg = MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibMoveClassInvalidProblem"), args);
                Problem newProblem = new Problem(false, msg);
                problem = Utility.addProblemsToEnd(problem, newProblem);
            }
        }
        return problem;
    }

    private boolean isTld(FileObject fo) {
        String ext;
        boolean isTld = false;
        if (fo != null && "tld".equalsIgnoreCase(ext = fo.getExt())) {
            isTld = true;
        }
        return isTld;
    }

    public final class TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;
        protected DataObject newData = null;

        public TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) {
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibListenerClassReferenceMoveClassOtherProject"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("perform external change: TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement");
                    ListenerType listener = null;
                    ListenerType[] listeners = taglib.getListener();
                    for (int i = 0; i < listeners.length; ++i) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (!this.oldName.equals(listenerClass)) continue;
                        listener = listeners[i];
                        break;
                    }
                    if (listener != null) {
                        taglib.removeListener(listener);
                        listener.setListenerClass(this.newName);
                        newTaglib.addListener(listener);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("undo external change: TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement");
                    ListenerType listener = null;
                    ListenerType[] listeners = newTaglib.getListener();
                    for (int i = 0; i < listeners.length; ++i) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (!this.newName.equals(listenerClass)) continue;
                        listener = listeners[i];
                        break;
                    }
                    if (listener != null) {
                        newTaglib.removeListener(listener);
                        listener.setListenerClass(this.oldName);
                        taglib.addListener(listener);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibListenerClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data;

        public TaglibListenerClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibListenerClassMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    ListenerType listener = null;
                    ListenerType[] listeners = taglib.getListener();
                    for (int i = 0; i < listeners.length; ++i) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (!this.oldName.equals(listenerClass)) continue;
                        listener = listeners[i];
                        break;
                    }
                    if (listener != null) {
                        listener.setListenerClass(this.newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    ListenerType listener = null;
                    ListenerType[] listeners = taglib.getListener();
                    for (int i = 0; i < listeners.length; ++i) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (!this.newName.equals(listenerClass)) continue;
                        listener = listeners[i];
                        break;
                    }
                    if (listener != null) {
                        listener.setListenerClass(this.oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;
        protected DataObject newData = null;

        public TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) {
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibValidatorClassReferenceMoveClassOtherProject"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    String validatorClass;
                    err.log("perform external change: TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement");
                    ValidatorType validator = taglib.getValidator();
                    if (validator != null && this.oldName.equals(validatorClass = validator.getValidatorClass())) {
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    String validatorClass;
                    err.log("undo external change: TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement");
                    ValidatorType validator = newTaglib.getValidator();
                    if (validator != null && this.newName.equals(validatorClass = validator.getValidatorClass())) {
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibValidatorClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data;

        public TaglibValidatorClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibValidatorClassMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                ValidatorType validator;
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && (validator = taglib.getValidator()) != null) {
                    validator.setValidatorClass(this.newName);
                    try {
                        if (tdo != null) {
                            tdo.write(taglib);
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().log(1, ioe.getMessage());
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                ValidatorType validator;
                FileObject tldFO = this.data.getPrimaryFile();
                Taglib taglib = null;
                TLDDataObject tdo = (TLDDataObject)this.data;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && (validator = taglib.getValidator()) != null) {
                    validator.setValidatorClass(this.oldName);
                    try {
                        if (tdo != null) {
                            tdo.write(taglib);
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().log(1, ioe.getMessage());
                    }
                }
            }
        }
    }

    public final class TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;
        protected DataObject newData = null;

        public TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) {
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibFunctionClassReferenceMoveClassOtherProject"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("perform external change: TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement");
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i = 0; i < functions.length; ++i) {
                        String functionClass = functions[i].getFunctionClass();
                        if (!this.oldName.equals(functionClass)) continue;
                        function = functions[i];
                        break;
                    }
                    if (function != null) {
                        taglib.removeFunction(function);
                        function.setFunctionClass(this.newName);
                        newTaglib.addFunction(function);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("undo external change: TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement");
                    FunctionType function = null;
                    FunctionType[] functions = newTaglib.getFunction();
                    for (int i = 0; i < functions.length; ++i) {
                        String functionClass = functions[i].getFunctionClass();
                        if (!this.newName.equals(functionClass)) continue;
                        function = functions[i];
                        break;
                    }
                    if (function != null) {
                        newTaglib.removeFunction(function);
                        function.setFunctionClass(this.oldName);
                        taglib.addFunction(function);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibFunctionClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data;

        public TaglibFunctionClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibFunctionClassMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i = 0; i < functions.length; ++i) {
                        String functionClass = functions[i].getFunctionClass();
                        if (!this.oldName.equals(functionClass)) continue;
                        function = functions[i];
                        break;
                    }
                    if (function != null) {
                        function.setFunctionClass(this.newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i = 0; i < functions.length; ++i) {
                        String functionClass = functions[i].getFunctionClass();
                        if (!this.newName.equals(functionClass)) continue;
                        function = functions[i];
                        break;
                    }
                    if (function != null) {
                        function.setFunctionClass(this.oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;
        protected DataObject newData = null;

        public TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) {
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibTeiClassReferenceMoveClassOtherProject"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String teiClass = tags[i].getTeiClass();
                        if (!this.oldName.equals(teiClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        taglib.removeTag(tag);
                        tag.setTeiClass(this.newName);
                        newTaglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("undo external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = newTaglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String teiClass = tags[i].getTeiClass();
                        if (!this.newName.equals(teiClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        newTaglib.removeTag(tag);
                        tag.setTeiClass(this.oldName);
                        taglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibTeiClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;

        public TaglibTeiClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibTeiClassMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String teiClass = tags[i].getTagClass();
                        if (!this.oldName.equals(teiClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        tag.setTeiClass(this.newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String teiClass = tags[i].getTagClass();
                        if (!this.newName.equals(teiClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        tag.setTeiClass(this.oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;
        protected DataObject newData = null;

        public TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) {
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.data.getPrimaryFile().getNameExt(), this.newData.getPrimaryFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibTagClassReferenceMoveClassOtherProject"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String tagClass = tags[i].getTagClass();
                        if (!this.oldName.equals(tagClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        taglib.removeTag(tag);
                        tag.setTagClass(this.newName);
                        newTaglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                FileObject newTldFO = this.newData.getPrimaryFile();
                TLDDataObject newTdo = (TLDDataObject)this.newData;
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null && newTaglib != null) {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = newTaglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String tagClass = tags[i].getTagClass();
                        if (!this.newName.equals(tagClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        newTaglib.removeTag(tag);
                        tag.setTagClass(this.oldName);
                        taglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibTagClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected DataObject data = null;

        public TaglibTagClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, (String)"TXT_TaglibTagClassMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    err.log("perform external change: TaglibTagClassMoveClassRefactoringElement");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String tagClass = tags[i].getTagClass();
                        if (!this.oldName.equals(tagClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        tag.setTagClass(this.newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject tldFO = this.data.getPrimaryFile();
                TLDDataObject tdo = (TLDDataObject)this.data;
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (taglib != null) {
                    err.log("undo external change: TaglibTagClassMoveClassRefactoringElement");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i = 0; i < tags.length; ++i) {
                        String tagClass = tags[i].getTagClass();
                        if (!this.newName.equals(tagClass)) continue;
                        tag = tags[i];
                        break;
                    }
                    if (tag != null) {
                        tag.setTagClass(this.oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().log(1, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }
}

