/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.rename.EjbJarRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.EntityRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.JaxWsXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.PersistenceXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.SunJaxWsXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.TldRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.WebXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.WebservicesXmlRenameRefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class J2EERenameRefactoringPlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private EjbJarRenameRefactoring ejbJarRenameRefactor;
    private WebXmlRenameRefactoring webXmlRenameRefactor;
    private TldRenameRefactoring tldRenameRefactor;
    private WebservicesXmlRenameRefactoring webservicesXmlRenameRefactor;
    private PersistenceXmlRenameRefactoring persistenceXmlRenameRefactoring = new PersistenceXmlRenameRefactoring();
    private EntityRenameRefactoring entityRenameRefactoring = new EntityRenameRefactoring();
    private JaxWsXmlRenameRefactoring jaxWsXmlRenameRefactoring = new JaxWsXmlRenameRefactoring();
    private SunJaxWsXmlRenameRefactoring sunJaxWsXmlRenameRefactoring = new SunJaxWsXmlRenameRefactoring();
    private final RenameRefactoring renameRefactoring;
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.renameRefactoring.rename");

    public J2EERenameRefactoringPlugin(AbstractRefactoring refactoring) {
        this.renameRefactoring = (RenameRefactoring)refactoring;
    }

    public Problem preCheck() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            RefObject refO = (RefObject)this.renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            Problem webSvcProblem = this.getWebservicesXmlRenameRefactor().preCheck(refO);
            problem = Utility.addProblemsToEnd(problem, webSvcProblem);
            if (!Utility.isEjb30(refO)) {
                Problem ejbJarProblem = this.getEjbJarRenameRefactor().preCheck(refO);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            } else if (Utility.hasEjbJar(Utility.getRelevantEjbModules(refO))) {
                Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EERenameRefactoringPlugin.class, (String)"TXT_EjbJarRenameWarning"));
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            semafor.set(null);
        }
        return problem;
    }

    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            RefObject refO = (RefObject)this.renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            String newName = this.renameRefactoring.getNewName();
            err.log("newname: " + newName);
            if (!Utility.isEjb30(refO)) {
                Problem ejbJarProblem = this.getEjbJarRenameRefactor().fastCheckParameters(refO, newName);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            Problem wsvcProblem = this.getWebservicesXmlRenameRefactor().fastCheckParameters(refO, newName);
            problem = Utility.addProblemsToEnd(problem, wsvcProblem);
            semafor.set(null);
        }
        return problem;
    }

    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            RefObject refO = (RefObject)this.renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            String newName = this.renameRefactoring.getNewName();
            err.log("newname: " + newName);
            if (!Utility.isEjb30(refO)) {
                Problem ejbJarProblem = this.getEjbJarRenameRefactor().checkParameters(refO, newName);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            Problem wsvcProblem = this.getWebservicesXmlRenameRefactor().checkParameters(refO, newName);
            problem = Utility.addProblemsToEnd(problem, wsvcProblem);
            semafor.set(null);
        }
        return problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            RefObject refO = (RefObject)this.renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            String newName = this.renameRefactoring.getNewName();
            err.log("newname: " + newName);
            Problem webXmlProblem = this.getWebXmlRenameRefactor().prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webXmlProblem);
            Problem tldProblem = this.getTldRenameRefactor().prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, tldProblem);
            if (!Utility.isEjb30(refO)) {
                Problem ejbJarProblem = this.getEjbJarRenameRefactor().prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            Problem webservicesProblem = this.getWebservicesXmlRenameRefactor().prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webservicesProblem);
            Problem persistenceXmlProblem = this.persistenceXmlRenameRefactoring.prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, persistenceXmlProblem);
            Problem entityRenameProblem = this.entityRenameRefactoring.prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, entityRenameProblem);
            Problem jaxXmlProblem = this.jaxWsXmlRenameRefactoring.prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, jaxXmlProblem);
            Problem sunJaxXmlProblem = this.sunJaxWsXmlRenameRefactoring.prepare((AbstractRefactoring)this.renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, sunJaxXmlProblem);
            semafor.set(null);
        }
        err.log("Gonna return problem: " + problem);
        return problem;
    }

    public void cancelRequest() {
    }

    private EjbJarRenameRefactoring getEjbJarRenameRefactor() {
        if (this.ejbJarRenameRefactor == null) {
            this.ejbJarRenameRefactor = new EjbJarRenameRefactoring();
        }
        return this.ejbJarRenameRefactor;
    }

    private WebXmlRenameRefactoring getWebXmlRenameRefactor() {
        if (this.webXmlRenameRefactor == null) {
            this.webXmlRenameRefactor = new WebXmlRenameRefactoring();
        }
        return this.webXmlRenameRefactor;
    }

    private TldRenameRefactoring getTldRenameRefactor() {
        if (this.tldRenameRefactor == null) {
            this.tldRenameRefactor = new TldRenameRefactoring();
        }
        return this.tldRenameRefactor;
    }

    private WebservicesXmlRenameRefactoring getWebservicesXmlRenameRefactor() {
        if (this.webservicesXmlRenameRefactor == null) {
            this.webservicesXmlRenameRefactor = new WebservicesXmlRenameRefactoring();
        }
        return this.webservicesXmlRenameRefactor;
    }
}

