/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.MemberClassScope;
import org.netbeans.modules.javacore.parser.MemberFieldScope;
import org.netbeans.modules.javacore.parser.MethodScope;
import org.netbeans.modules.javacore.parser.MethodScopeMember;
import org.netbeans.modules.javacore.parser.PackageImpScope;
import org.netbeans.modules.javacore.parser.ScopeMember;
import org.netbeans.modules.javacore.parser.SingleImpScope;
import org.netbeans.modules.javacore.parser.StaticImportScope;
import org.netbeans.modules.javacore.parser.TypeParamScope;

public class Scope
implements ScopeMember {
    private Scope parentScope;
    private Map positiveCache;
    private Set negativeCache;
    private ArrayList members;
    static final /* synthetic */ boolean $assertionsDisabled;

    Scope(Scope parent) {
        this.parentScope = parent;
        this.positiveCache = new HashMap();
        this.negativeCache = new HashSet();
        this.members = new ArrayList();
    }

    public Object lookup(Object key) {
        Object val = this.positiveCache.get(key);
        if (val != null) {
            return val;
        }
        if (!this.negativeCache.contains(key)) {
            val = this.lookupMembers(key);
        }
        if (val == null && this.parentScope != null) {
            val = this.parentScope.lookup(key);
        }
        return val;
    }

    void addMember(ScopeMember member) {
        this.positiveCache.clear();
        this.negativeCache.clear();
        this.members.add(member);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Scope) {
            Scope sc = (Scope)obj;
            if (!this.members.equals(sc.members)) {
                return false;
            }
            if (this.parentScope == null) {
                return this.parentScope == sc.parentScope;
            }
            return this.parentScope.equals(sc.parentScope);
        }
        return false;
    }

    protected Object clone() {
        Scope cloned = new Scope(this.parentScope);
        cloned.members = (ArrayList)this.members.clone();
        return cloned;
    }

    private Object lookupMembers(Object key) {
        Iterator it = this.members.iterator();
        Object value = null;
        while (it.hasNext()) {
            ScopeMember m = (ScopeMember)it.next();
            Object val = m.lookup(key);
            if (val == null) continue;
            if (value == null) {
                value = val;
                continue;
            }
            if (value.equals(val)) continue;
            JMManager.getLog().log("Ambiguos reference " + key + ":" + value + ":" + val);
        }
        if (value != null) {
            this.positiveCache.put(key, value);
        } else {
            this.negativeCache.add(key);
        }
        return value;
    }

    static Scope createMemberTypeScope(ClassDefinition jcls, MDRParser sc) {
        if (jcls instanceof ParameterizedType) {
            jcls = ((ParameterizedType)jcls).getDefinition();
        }
        if (jcls instanceof UnresolvedClass) {
            return new Scope(null);
        }
        MOFID id = ((BaseObjectHandler)jcls)._getMofId();
        Map cache = Scope.getCacheFor(Scope.class.getName() + "createMemberTypeScope");
        Scope scope = (Scope)cache.get(id);
        if (scope == null) {
            cache.put(id, new Scope(null));
            scope = Scope.constructMemberTypeScope(jcls, sc);
            cache.put(id, scope);
        }
        return scope;
    }

    static Scope constructMemberTypeScope(ClassDefinition jcls, MDRParser sc) {
        ArrayList<Scope> superScopes = new ArrayList<Scope>(2);
        Scope superScope = null;
        JavaClass superJavaClass = Scope.getSuperClass(jcls, sc);
        Collection interfaces = Scope.getInterfaces(jcls, sc);
        Iterator ifaceIt = interfaces.iterator();
        if (superJavaClass != null && !(superJavaClass instanceof UnresolvedClass)) {
            superScopes.add(Scope.createMemberTypeScope((ClassDefinition)superJavaClass, sc));
        }
        while (ifaceIt.hasNext()) {
            JavaClass ifaceClass = (JavaClass)ifaceIt.next();
            if (ifaceClass == null || ifaceClass instanceof UnresolvedClass) continue;
            superScopes.add(Scope.createMemberTypeScope((ClassDefinition)ifaceClass, sc));
        }
        if (!superScopes.isEmpty()) {
            Iterator scopeIt = superScopes.iterator();
            superScope = new Scope(null);
            while (scopeIt.hasNext()) {
                superScope.addMember((ScopeMember)scopeIt.next());
            }
        }
        Scope memberScope = new Scope(superScope);
        if (jcls instanceof JavaClass) {
            memberScope.addMember(new MemberClassScope((JavaClass)jcls));
        }
        return memberScope;
    }

    static Scope createTypeScope(String jpck, ClassPath classPath, ElementInfo[] imports) {
        Scope packageImp = new Scope(null);
        Scope currentPackage = new Scope(packageImp);
        Scope singleImp = new Scope(currentPackage);
        Scope memberTypes = new Scope(singleImp);
        packageImp.addMember(new PackageImpScope("java.lang", classPath));
        currentPackage.addMember(new PackageImpScope(jpck, classPath));
        if (imports != null) {
            for (int i = 0; i < imports.length; ++i) {
                ElementInfo importInfo = imports[i];
                String name = importInfo.name;
                if (importInfo.infoType == 68) {
                    packageImp.addMember(new PackageImpScope(name, classPath));
                    continue;
                }
                singleImp.addMember(new SingleImpScope(name));
            }
        }
        return singleImp;
    }

    static Scope createStaticImpScope(Resource rsc) {
        Scope packageImp = new Scope(null);
        Scope singleImp = new Scope(packageImp);
        Scope memberTypes = new Scope(singleImp);
        Object[] imports = rsc.getImports().toArray();
        JavaClassClassImpl jclsClass = (JavaClassClassImpl)((JavaModelPackage)rsc.refImmediatePackage()).getJavaClass();
        for (int i = 0; i < imports.length; ++i) {
            String className;
            JavaClass javaClass;
            Import imp = (Import)imports[i];
            if (!imp.isStatic()) continue;
            String name = imp.getName();
            if (imp.isOnDemand()) {
                JavaClass javaClass2 = jclsClass.resolveClass(name, true);
                if (javaClass2 == null) continue;
                packageImp.addMember(Scope.createStaticImportScope(javaClass2, null));
                continue;
            }
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1 || (javaClass = jclsClass.resolveClass(className = name.substring(0, lastDot), true)) == null) continue;
            singleImp.addMember(Scope.createStaticImportScope(javaClass, name.substring(lastDot + 1)));
        }
        return singleImp;
    }

    static MethodScope createMethodScope(ClassDefinition jcls) {
        if (jcls instanceof UnresolvedClass) {
            return new MethodScope(null);
        }
        MOFID id = ((BaseObjectHandler)jcls)._getMofId();
        Map cache = Scope.getCacheFor(Scope.class.getName() + "createMethodScope");
        MethodScope scope = (MethodScope)cache.get(id);
        if (scope == null) {
            scope = Scope.createMethodScopeImpl(jcls);
            cache.put(id, scope);
        }
        return scope;
    }

    private static MethodScope createMethodScopeImpl(ClassDefinition jcls) {
        JavaClass superJavaClass = jcls.getSuperClass();
        Iterator ifaceIt = jcls.getInterfaces().iterator();
        ArrayList<MethodScope> superScopes = new ArrayList<MethodScope>(2);
        if (superJavaClass != null) {
            superScopes.add(Scope.createMethodScope((ClassDefinition)superJavaClass));
        }
        while (ifaceIt.hasNext()) {
            JavaClass ifaceClass = (JavaClass)ifaceIt.next();
            if (ifaceClass == null) continue;
            superScopes.add(Scope.createMethodScope((ClassDefinition)ifaceClass));
        }
        MethodScope superScope = new MethodScope(null);
        Iterator scopeIt = superScopes.iterator();
        while (scopeIt.hasNext()) {
            superScope.addMember((ScopeMember)scopeIt.next());
        }
        MethodScope memberScope = new MethodScope(superScope);
        memberScope.addMember(new MethodScopeMember(jcls));
        return memberScope;
    }

    static Scope createStaticImportScope(JavaClass jcls, String name) {
        if (jcls instanceof UnresolvedClass) {
            return new Scope(null);
        }
        return Scope.createStaticImportScopeImpl(jcls, name);
    }

    private static Scope createStaticImportScopeImpl(JavaClass jcls, String name) {
        JavaClass superJavaClass = jcls.getSuperClass();
        Iterator ifaceIt = jcls.getInterfaces().iterator();
        ArrayList<Scope> superScopes = new ArrayList<Scope>(2);
        if (superJavaClass != null) {
            superScopes.add(Scope.createStaticImportScope(superJavaClass, name));
        }
        while (ifaceIt.hasNext()) {
            JavaClass ifaceClass = (JavaClass)ifaceIt.next();
            if (ifaceClass == null) continue;
            superScopes.add(Scope.createStaticImportScope(ifaceClass, name));
        }
        Scope superScope = new Scope(null);
        Iterator scopeIt = superScopes.iterator();
        while (scopeIt.hasNext()) {
            superScope.addMember((ScopeMember)scopeIt.next());
        }
        Scope memberScope = new Scope(superScope);
        memberScope.addMember(new StaticImportScope(jcls, name));
        return memberScope;
    }

    static Scope createFieldScope(ClassDefinition jcls) {
        if (jcls instanceof UnresolvedClass) {
            return new Scope(null);
        }
        MOFID id = ((BaseObjectHandler)jcls)._getMofId();
        Map cache = Scope.getCacheFor(Scope.class.getName() + "createFieldScope");
        Scope scope = (Scope)cache.get(id);
        if (scope == null) {
            scope = Scope.createFieldScopeImpl(jcls);
            cache.put(id, scope);
        }
        return scope;
    }

    private static Scope createFieldScopeImpl(ClassDefinition jcls) {
        JavaClass superJavaClass = jcls.getSuperClass();
        Iterator ifaceIt = jcls.getInterfaces().iterator();
        ArrayList<Scope> superScopes = new ArrayList<Scope>(2);
        if (superJavaClass != null) {
            superScopes.add(Scope.createFieldScope((ClassDefinition)superJavaClass));
        }
        while (ifaceIt.hasNext()) {
            JavaClass ifaceClass = (JavaClass)ifaceIt.next();
            if (ifaceClass == null) continue;
            superScopes.add(Scope.createFieldScope((ClassDefinition)ifaceClass));
        }
        Scope superScope = new Scope(null);
        Iterator scopeIt = superScopes.iterator();
        while (scopeIt.hasNext()) {
            superScope.addMember((ScopeMember)scopeIt.next());
        }
        Scope memberScope = new Scope(superScope);
        memberScope.addMember(new MemberFieldScope(jcls));
        return memberScope;
    }

    private static Map getCacheFor(String cacheId) {
        HashMap cache;
        ExclusiveMutex mutex = JMManager.getTransactionMutex();
        Map parserCache = mutex.getParserCache();
        SoftReference ref = (SoftReference)parserCache.get(cacheId);
        HashMap hashMap = cache = ref == null ? null : (HashMap)ref.get();
        if (cache == null) {
            cache = new HashMap();
            parserCache.put(cacheId, new SoftReference(cache));
        }
        return cache;
    }

    private static JavaClass getSuperClass(ClassDefinition jcls, MDRParser sc) {
        if (sc != null) {
            return sc.getSuperClass(jcls);
        }
        return jcls.getSuperClass();
    }

    private static Collection getInterfaces(ClassDefinition jcls, MDRParser sc) {
        if (sc != null) {
            return sc.getInterfaces(jcls);
        }
        return jcls.getInterfaces();
    }

    public static Scope createTypeScope(Resource rsc, ClassPath classPath) {
        String jpck = rsc.getPackageName();
        List importCol = rsc.getImports();
        Iterator it = importCol.iterator();
        ArrayList<ElementInfo> imports = new ArrayList<ElementInfo>();
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            if (imp.isStatic()) continue;
            int infoType = imp.isOnDemand() ? 68 : 54;
            imports.add(new ElementInfo(null, infoType, imp.getName()));
        }
        return Scope.createTypeScope(jpck, classPath, imports.toArray(new ElementInfo[imports.size()]));
    }

    public static Scope computeTypeScope(Element element) {
        Scope classScope;
        if (element instanceof JavaClass) {
            Scope parent;
            JavaClass javaClass = (JavaClass)element;
            ClassDefinition decl = javaClass.getDeclaringClass();
            if (element instanceof JavaClassImpl && ((JavaClassImpl)element).isTransient() && decl == null) {
                parent = Scope.computeTypeScope((Element)JavaModelUtil.getDeclaringFeature((Element)element.refImmediateComposite()));
            } else if (decl == null) {
                ClassPath cp = JavaMetamodel.getManager().getClassPath();
                parent = Scope.createTypeScope(element.getResource(), cp);
            } else {
                parent = Scope.computeTypeScope((Element)decl);
            }
            classScope = new Scope(parent);
            classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)javaClass, null));
            Iterator typeParIt = javaClass.getTypeParameters().iterator();
            while (typeParIt.hasNext()) {
                TypeParameter tp = (TypeParameter)typeParIt.next();
                classScope.addMember(new TypeParamScope(tp));
            }
        } else if (element instanceof ClassMember) {
            ClassMember cm = (ClassMember)element;
            classScope = Scope.computeTypeScope((Element)cm.getDeclaringClass());
            if (cm instanceof CallableFeature) {
                CallableFeature cf = (CallableFeature)cm;
                classScope = new Scope(classScope);
                Iterator typeParIt = cf.getTypeParameters().iterator();
                while (typeParIt.hasNext()) {
                    TypeParameter tp = (TypeParameter)typeParIt.next();
                    classScope.addMember(new TypeParamScope(tp));
                }
            }
        } else if (element instanceof ClassDefinition) {
            Scope parent = Scope.computeTypeScope((Element)JavaModelUtil.getDeclaringFeature(element));
            classScope = new Scope(parent);
            classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)element, null));
        } else {
            Feature feature = JavaModelUtil.getDeclaringFeature(element);
            if (!$assertionsDisabled && feature == null) {
                throw new AssertionError((Object)("Invalid element " + element));
            }
            classScope = Scope.computeTypeScope((Element)feature);
        }
        return classScope;
    }

    static {
        $assertionsDisabled = !Scope.class.desiredAssertionStatus();
    }
}

