/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.handlers.AttrListWrapper;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.LightAttrList;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ArrayRef;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.ParameterInfo;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.openide.util.Utilities;

public abstract class ParameterImpl
extends SemiPersistentElement
implements Parameter {
    private static final ElementInfo DEFAULT_INFO = new ParameterInfo(null, 30, null, false, null, false, null);
    private TypeReference typeName = null;
    private int dimCount = 0;
    private LightAttrList annotations = null;
    private boolean internalSetDim = false;
    private static final int FINAL_OPT = 0;
    private static final int TYPE = 1;
    private static final int VARARG_OPT = 2;
    private static final int VARIABLE_DECLARATOR_ID = 3;

    protected ParameterImpl(StorableObject s) {
        super(s);
    }

    protected void matchPersistent(ElementInfo info) {
        super.matchPersistent(info);
        ParameterInfo pinfo = (ParameterInfo)info;
        if (pinfo.isFinal != this.isFinal()) {
            this.setFinal(pinfo.isFinal);
        }
        if (pinfo.isVarArg != this.isVarArg()) {
            this.setVarArg(pinfo.isVarArg);
        }
        if (!this.isPersisted()) {
            this.setPersisted(true);
            this.persist();
            this.setTypeRef(pinfo.type);
            this.persistChildren(this.getPersistentList("annotations", this.super_getAnnotations()), pinfo.annotations);
        } else {
            if (!Utilities.compareObjects((Object)pinfo.type, (Object)this.getTypeRef())) {
                this.setType(this.resolveType(pinfo.type));
            }
            this.processMembers(this.getAnnotations(), pinfo.annotations);
        }
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void resetChildren() {
        super.resetChildren();
        if (this.typeName != null) {
            TypeReference temp = this.typeName;
            this.changeChild((Element)this.typeName, null);
            this.typeName = null;
            temp.refDelete();
        }
        if (this.annotations != null) {
            this.annotations.setInnerList((List)this.getPersistentList("annotations", this.super_getAnnotations()));
        }
        this.childrenInited = false;
    }

    public Type getType() {
        this.checkUpToDate();
        return this.resolveType(this.getTypeRef());
    }

    private void fireTypeNameChange(TypeReference typeReference) {
        TypeReference oldValue = null;
        TypeReference newValue = null;
        if (this.childrenInited && !this.disableChanges) {
            oldValue = this.getTypeName();
            newValue = typeReference;
        }
        this.fireAttrChange("typeName", oldValue, newValue);
    }

    public void setType(Type newValue) {
        TypeRef tr = ParameterImpl.typeToTypeRef(newValue);
        TypeReference typeReference = null;
        if (!this.disableChanges) {
            this.updateDimCount(tr);
            typeReference = (TypeReference)this.typeRefToTypeReference(tr, this.getDimCount());
        }
        this.fireTypeNameChange(typeReference);
        this._setTypeName(typeReference, tr);
    }

    private void updateDimCount(TypeRef tr) {
        int dimCount = this.getDimCount();
        if (tr instanceof ArrayRef) {
            if (((ArrayRef)tr).dimCount < dimCount) {
                this._setDimCount(((ArrayRef)tr).dimCount);
            }
        } else if (dimCount > 0) {
            this._setDimCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setDimCount(int dimCount) {
        this.internalSetDim = true;
        try {
            this.setDimCount(dimCount);
        }
        finally {
            this.internalSetDim = false;
        }
    }

    public TypeReference getTypeName() {
        this.checkUpToDate();
        if (!this.childrenInited) {
            this.initChildren();
        }
        return this.typeName;
    }

    public void setTypeName(TypeReference typeName) {
        this._setTypeName(typeName, ParameterImpl.typeReferenceToTypeRef((Element)typeName, this.getDimCount()));
    }

    private void _setTypeName(TypeReference typeName, TypeRef typeRef) {
        if (!this.disableChanges) {
            this.objectChanged(64);
            this.changeChild((Element)this.getTypeName(), (Element)typeName);
            this.typeName = typeName;
        }
        this.setTypeRef(typeRef);
    }

    public void setFinal(boolean newValue) {
        this.objectChanged(4);
        this.super_setFinal(newValue);
    }

    public List getAnnotations() {
        this.checkUpToDate();
        if (this.annotations == null) {
            this.annotations = this.createChildrenList("annotations", (AttrListWrapper)this.super_getAnnotations(), null, 32768);
        }
        return this.annotations;
    }

    protected abstract void super_setFinal(boolean var1);

    public void setVarArg(boolean newValue) {
        this.objectChanged(32);
        this.super_setVarArg(newValue);
    }

    protected abstract void super_setVarArg(boolean var1);

    protected ASTree getPartTree(ElementPartKind part) {
        if (ElementPartKindEnum.NAME.equals((Object)part)) {
            return this.getASTree().getSubTrees()[3].getSubTrees()[0];
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part);
    }

    public String getSourceText() {
        String origElem = this.checkChange();
        if (origElem != null) {
            return origElem;
        }
        StringBuffer buf = new StringBuffer();
        Iterator annIt = this.getAnnotations().iterator();
        while (annIt.hasNext()) {
            AnnotationImpl ann = (AnnotationImpl)((Object)annIt.next());
            buf.append(ann.getSourceText()).append(' ');
        }
        if (this.isFinal()) {
            buf.append("final ");
        }
        buf.append(((MetadataElement)this.getTypeName()).getSourceText());
        if (this.isVarArg()) {
            buf.append("...");
        }
        buf.append(' ');
        buf.append(this.getName());
        this.appendDims(buf, this.getDimCount());
        return buf.toString();
    }

    protected void diffModifiers(List diffList, ASTree nextNode, ASTProvider parser) {
        int startOffset;
        String text = "";
        Iterator annIt = this.getAnnotations().iterator();
        while (annIt.hasNext()) {
            AnnotationImpl ann = (AnnotationImpl)((Object)annIt.next());
            text = text + ann.getSourceText();
            if (!annIt.hasNext()) continue;
            text = text + ' ';
        }
        if (this.isFinal()) {
            if (text.length() > 0) {
                text = text + ' ';
            }
            text = text + "final";
        }
        int nextToken = nextNode.getFirstToken();
        int endOffset = parser.getToken(nextToken).getStartOffset();
        ASTree modifiers = this.getASTree().getSubTrees()[0];
        if (modifiers != null) {
            int startToken = modifiers.getFirstToken();
            startOffset = parser.getToken(startToken).getStartOffset();
            if (text.length() > 0) {
                int endToken = modifiers.getLastToken();
                endOffset = parser.getToken(endToken).getEndOffset();
            }
        } else {
            startOffset = endOffset;
            text = text + ' ';
        }
        diffList.add(new DiffElement(startOffset, endOffset, text));
    }

    public void getDiff(List diffList) {
        MDRParser parser = this.getParser();
        ASTree[] children = this.getASTree().getSubTrees();
        if (this.isChanged(4) || this.isChanged(32768)) {
            this.diffModifiers(diffList, children[1], parser);
        } else if (children[0] != null) {
            ParameterInfo astInfo = (ParameterInfo)this.getElementInfo();
            this.getCollectionDiff(diffList, parser, 32768, astInfo.annotations, this.getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " ");
        }
        this.getChildDiff(diffList, parser, children[1], (MetadataElement)this.getTypeName(), 64);
        if (this.isChanged(32)) {
            this.replaceNode(diffList, parser, children[2], this.isVarArg() ? "..." : "", parser.getToken(children[1].getLastToken()).getEndOffset(), "");
        }
        ASTree[] varDeclaratorIdChildren = children[3].getSubTrees();
        if (this.isChanged(2)) {
            Token identifier = (Token)varDeclaratorIdChildren[0];
            int startOffset = identifier.getStartOffset();
            int endOffset = identifier.getEndOffset();
            diffList.add(new DiffElement(startOffset, endOffset, this.getName()));
        }
        if (this.isChanged(8192)) {
            this.replaceNode(diffList, parser, varDeclaratorIdChildren[1], this.appendDims(new StringBuffer(), this.getDimCount()).toString(), ParameterImpl.getEndOffset(this.getParser(), varDeclaratorIdChildren[0]), "");
        }
    }

    public void replaceChild(Element oldElement, Element newElement) {
        if (this.childrenInited) {
            if (oldElement.equals(this.typeName)) {
                this.setTypeName((TypeReference)newElement);
                return;
            }
            if (this.replaceObject(this.annotations, oldElement, newElement)) {
                return;
            }
        }
        super.replaceChild(oldElement, newElement);
    }

    public int getDimCount() {
        ASTree dims;
        if (this.isChanged(8192)) {
            return this.dimCount;
        }
        ASTree tree = this.getASTree();
        if (tree != null && (dims = tree.getSubTrees()[3].getSubTrees()[1]) != null) {
            return (dims.getLastToken() - dims.getFirstToken() + 1) / 2;
        }
        return 0;
    }

    public void setDimCount(int dimCount) {
        this.objectChanged(8192);
        this.dimCount = dimCount;
        if (!this.internalSetDim) {
            this.setTypeRef(ParameterImpl.typeReferenceToTypeRef((Element)this.getTypeName(), dimCount));
        }
    }

    public List getChildren() {
        ArrayList list = new ArrayList(1);
        list.addAll(this.getAnnotations());
        ParameterImpl.addIfNotNull(list, this.getTypeName());
        return list;
    }

    protected void initChildren() {
        this.childrenInited = false;
        ParameterInfo info = (ParameterInfo)this.getElementInfo();
        ASTree tree = info.getTypeAST(this);
        this.typeName = (TypeReference)this.initOrCreate((Element)this.typeName, tree);
        this.annotations = this.createChildrenList(this.annotations, "annotations", (AttrListWrapper)this.super_getAnnotations(), ((ParameterInfo)this.getElementInfo()).annotations, 32768);
        this.childrenInited = true;
    }

    protected void setData(List annotations, TypeReference typeName, int dimCount) {
        this.changeChild(null, (Element)typeName);
        this.typeName = typeName;
        this.annotations = this.createChildrenList("annotations", (AttrListWrapper)this.super_getAnnotations(), annotations, 32768);
        this.dimCount = dimCount;
        this.setTypeRef(ParameterImpl.typeReferenceToTypeRef((Element)typeName, dimCount));
        this.childrenInited = true;
    }

    protected void setTypeRef(TypeRef type) {
        this._getDelegate().setSlot1((Object)type);
    }

    public TypeRef getTypeRef() {
        return (TypeRef)this._getDelegate().getSlot1();
    }

    public boolean isPersisted() {
        return this._getDelegate().getSlot2() != null;
    }

    public void setPersisted(boolean persisted) {
        this._getDelegate().setSlot2((Object)(persisted ? "" : null));
    }

    void childChanged(MetadataElement mpi) {
        super.childChanged(mpi);
        if (this.childrenInited && mpi == this.typeName) {
            this.setTypeName((TypeReference)mpi);
        }
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getParameter().createParameter(this.getName(), ParameterImpl.duplicateList(this.getAnnotations(), targetExtent), this.isFinal(), (TypeReference)ParameterImpl.duplicateElement((Element)this.getTypeName(), targetExtent), this.getDimCount(), this.isVarArg());
    }

    public void fixImports(Element scope, Element original) {
        Parameter par = (Parameter)original;
        ParameterImpl.fixImports(scope, this.getAnnotations(), par.getAnnotations());
        this.setTypeName(JavaModelUtil.resolveImportsForType(scope, par.getType()));
        this.setDimCount(0);
    }

    protected abstract List super_getAnnotations();

    protected void _delete() {
        this.deleteChildren("annotations", (AttrListWrapper)this.super_getAnnotations());
        if (this.childrenInited) {
            this.deleteChild((Element)this.typeName);
        }
        super._delete();
    }
}

